/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.plugins.visitor;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.net.URL;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.metadata.spi.signature.ConstructorParametersSignature;
import org.jboss.metadata.spi.signature.MethodParametersSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.AnnotatedInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.MemberInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.scanning.plugins.helpers.ResourceOwnerFinder;
import org.jboss.scanning.plugins.visitor.ReflectProvider;
import org.jboss.scanning.plugins.visitor.ReflectResourceVisitor;

public abstract class ClassHierarchyResourceVisitor
extends ReflectResourceVisitor {
    private ResourceOwnerFinder finder;
    private boolean checkInterfaces;
    private boolean checkSuper;

    protected ClassHierarchyResourceVisitor(ReflectProvider provider, ResourceOwnerFinder finder) {
        super(provider);
        if (finder == null) {
            throw new IllegalArgumentException("Null finder");
        }
        this.finder = finder;
    }

    protected abstract boolean isRelevant(ClassInfo var1);

    protected void handleClass(ResourceContext resource, ClassInfo classInfo) throws Exception {
        if (classInfo == null || !this.isRelevant(classInfo)) {
            return;
        }
        String className = classInfo.getName();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Scanning class " + className + " for annotations"));
        }
        URL ownerURL = this.finder.findOwnerURL(resource);
        this.handleRelevantClass(classInfo, ownerURL);
        Annotation[] annotations = classInfo.getUnderlyingAnnotations();
        this.handleAnnotations(ElementType.TYPE, (Signature)null, annotations, className, ownerURL);
        this.handleMembers(ElementType.CONSTRUCTOR, (AnnotatedInfo[])classInfo.getDeclaredConstructors(), className, ownerURL);
        this.handleMembers(ElementType.METHOD, (AnnotatedInfo[])classInfo.getDeclaredMethods(), className, ownerURL);
        this.handleMembers(ElementType.FIELD, (AnnotatedInfo[])classInfo.getDeclaredFields(), className, ownerURL);
        if (this.checkInterfaces || this.checkSuper) {
            InterfaceInfo[] interfaces;
            if (this.checkInterfaces && (interfaces = classInfo.getInterfaces()) != null && interfaces.length > 0) {
                for (InterfaceInfo intf : interfaces) {
                    this.handleClass((ClassInfo)intf);
                }
            }
            if (this.checkSuper) {
                this.handleClass(classInfo.getSuperclass());
            }
        }
    }

    protected void handleRelevantClass(ClassInfo classInfo, URL ownerURL) {
    }

    protected void handleMembers(ElementType type, AnnotatedInfo[] members, String className, URL ownerURL) throws Exception {
        if (members != null && members.length > 0) {
            for (AnnotatedInfo ainfo : members) {
                if (!(ainfo instanceof MemberInfo)) {
                    throw new IllegalArgumentException("Can only handle member info: " + ainfo);
                }
                Annotation[] annotations = ainfo.getUnderlyingAnnotations();
                MemberInfo member = (MemberInfo)MemberInfo.class.cast(ainfo);
                this.handleAnnotations(type, member, annotations, className, ownerURL);
                if (!this.isParametrized(ainfo)) continue;
                Annotation[][] paramAnnotations = this.getParameterAnnotations(member);
                for (int index = 0; index < paramAnnotations.length; ++index) {
                    Signature signature = this.getParameterSignature(member, index);
                    this.handleAnnotations(ElementType.PARAMETER, signature, paramAnnotations[index], className, ownerURL);
                }
            }
        }
    }

    protected boolean isParametrized(AnnotatedInfo member) {
        return member instanceof MethodInfo || member instanceof ConstructorInfo;
    }

    protected Annotation[][] getParameterAnnotations(MemberInfo info) {
        ParameterInfo[] pinfos;
        if (info instanceof ConstructorInfo) {
            ConstructorInfo ci = (ConstructorInfo)ConstructorInfo.class.cast(info);
            pinfos = ci.getParameters();
        } else if (info instanceof MethodInfo) {
            MethodInfo mi = (MethodInfo)MethodInfo.class.cast(info);
            pinfos = mi.getParameters();
        } else {
            throw new IllegalArgumentException("Cannot handle info: " + info);
        }
        Annotation[][] values = new Annotation[pinfos.length][];
        for (int i = 0; i < pinfos.length; ++i) {
            ParameterInfo pi = pinfos[i];
            values[i] = pi.getUnderlyingAnnotations();
        }
        return values;
    }

    protected Signature getParameterSignature(MemberInfo info, int index) {
        if (info instanceof ConstructorInfo) {
            ConstructorInfo ci = (ConstructorInfo)ConstructorInfo.class.cast(info);
            return new ConstructorParametersSignature(ci, index);
        }
        if (info instanceof MethodInfo) {
            MethodInfo mi = (MethodInfo)MethodInfo.class.cast(info);
            return new MethodParametersSignature(mi, index);
        }
        throw new IllegalArgumentException("Cannot handle info: " + info);
    }

    protected void handleAnnotations(ElementType type, MemberInfo member, Annotation[] annotations, String className, URL ownerURL) throws Exception {
        Signature signature = null;
        if (member != null) {
            signature = Signature.getSignature((MemberInfo)member);
        }
        this.handleAnnotations(type, signature, annotations, className, ownerURL);
    }

    protected void handleAnnotations(ElementType type, Signature signature, Annotation[] annotations, String className, URL ownerURL) {
    }

    public void setCheckInterfaces(boolean checkInterfaces) {
        this.checkInterfaces = checkInterfaces;
    }

    public void setCheckSuper(boolean checkSuper) {
        this.checkSuper = checkSuper;
    }
}

