/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.FinalizedClientResponse;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;

public class AbortedResponse
extends FinalizedClientResponse {
    public AbortedResponse(ClientConfiguration configuration, Response response) {
        super(configuration, RESTEasyTracingLogger.empty());
        for (Map.Entry entry : response.getMetadata().entrySet()) {
            for (Object obj : (List)entry.getValue()) {
                this.getMetadata().add((Object)((String)entry.getKey()), (Object)configuration.toHeaderString(obj));
            }
        }
        this.setStatus(response.getStatus());
        this.setEntity(response.getEntity());
        if (response instanceof BuiltResponse) {
            BuiltResponse built = (BuiltResponse)response;
            this.setEntityClass(built.getEntityClass());
            this.setGenericType(built.getGenericType());
            this.setAnnotations(built.getAnnotations());
        }
        if (response.getEntity() != null) {
            MediaType mediaType = this.getMediaType();
            if (mediaType == null) {
                mediaType = MediaType.WILDCARD_TYPE;
                this.getHeaders().putSingle((Object)"Content-Type", (Object)"*/*");
            }
            if (!(response.getEntity() instanceof InputStream)) {
                MessageBodyWriter<?> writer = configuration.getMessageBodyWriter(this.getEntityClass(), this.getGenericType(), null, mediaType);
                if (writer == null) {
                    throw new ProcessingException(Messages.MESSAGES.failedToBufferAbortedResponseNoWriter(mediaType, this.entityClass.getName()));
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    writer.writeTo(this.getEntity(), this.getEntityClass(), this.getGenericType(), this.getAnnotations(), mediaType, this.getHeaders(), (OutputStream)baos);
                }
                catch (IOException e) {
                    throw new ProcessingException(Messages.MESSAGES.failedToBufferAbortedResponse(), (Throwable)e);
                }
                this.bufferedEntity = baos.toByteArray();
                this.setInputStream(new ByteArrayInputStream(this.bufferedEntity));
            } else {
                InputStream is = (InputStream)response.getEntity();
                this.setInputStream(is);
            }
        }
    }

    @Override
    protected void setInputStream(InputStream is) {
        this.is = is;
    }

    public synchronized <T> T readEntity(Class<T> type, Type genericType, Annotation[] anns) {
        this.setEntity(null);
        this.setAnnotations(null);
        return (T)super.readEntity(type, genericType, anns);
    }
}

