/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.kernel.spi.dependency.KernelControllerContext;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader setContextClassLoader(final KernelControllerContext context) throws Throwable {
        if (System.getSecurityManager() == null) {
            ClassLoader result = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(context.getClassLoader());
            return result;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                @Override
                public ClassLoader run() throws Exception {
                    try {
                        ClassLoader result = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(context.getClassLoader());
                        return result;
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("Error setting context classloader", e);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }

    static void resetContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }
}

