/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.CachingAnnotationMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.dependency.plugins.AbstractScopeInfo;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.ComponentMutableMetaData;
import org.jboss.metadata.spi.loader.MutableMetaDataLoader;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KernelScopeInfo
extends AbstractScopeInfo {
    private static final Logger log = Logger.getLogger(KernelScopeInfo.class);
    private BeanMetaData beanMetaData;

    public KernelScopeInfo(Object name, String className, BeanMetaData beanMetaData) {
        super(name, className);
        this.beanMetaData = beanMetaData;
    }

    public ScopeKey getScope() {
        Class<?> clazz;
        ClassLoader cl;
        ScopeKey key = super.getScope();
        Scope scope = key.getScope(CommonLevels.CLASS);
        if (scope == null) {
            return key;
        }
        Object qualifier = scope.getQualifier();
        if (qualifier instanceof Class) {
            return key;
        }
        String className = (String)qualifier;
        try {
            cl = Configurator.getClassLoader(this.beanMetaData);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error getting classloader for " + key, t);
        }
        try {
            clazz = Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load class: " + className + " for " + key, e);
        }
        key.addScope(new Scope(CommonLevels.CLASS, clazz));
        return key;
    }

    public void updateMetaData(MutableMetaDataRepository repository, ControllerContext context, MutableMetaDataLoader mutable, boolean add) {
        if (!(context instanceof KernelControllerContext)) {
            return;
        }
        KernelControllerContext kernelContext = (KernelControllerContext)context;
        this.updateClassAnnotations(mutable, kernelContext, add);
        if (mutable instanceof ComponentMutableMetaData) {
            this.updatePropertyAnnotations(repository, (ComponentMutableMetaData)mutable, kernelContext, add);
        } else if (add) {
            log.warn((Object)("Unable to add properties to mutable metadata that does not support components: " + mutable + " for " + context.toShortString()));
        }
    }

    private void updateClassAnnotations(MutableMetaDataLoader mutable, KernelControllerContext context, boolean add) {
        BeanMetaData beanMetaData = context.getBeanMetaData();
        if (beanMetaData != null) {
            ClassLoader cl;
            try {
                cl = Configurator.getClassLoader(beanMetaData);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error getting classloader for " + beanMetaData.getName(), t);
            }
            this.updateAnnotations(cl, mutable, beanMetaData.getAnnotations(), add);
        }
    }

    private void updatePropertyAnnotations(MutableMetaDataRepository repository, ComponentMutableMetaData mutable, KernelControllerContext context, boolean add) {
        ClassLoader cl;
        BeanMetaData beanMetaData = context.getBeanMetaData();
        if (beanMetaData == null) {
            return;
        }
        Set<PropertyMetaData> properties = beanMetaData.getProperties();
        if (properties == null || properties.size() == 0) {
            return;
        }
        BeanInfo beanInfo = context.getBeanInfo();
        if (beanInfo == null) {
            return;
        }
        try {
            cl = Configurator.getClassLoader(beanMetaData);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error getting classloader for metadata");
        }
        for (PropertyMetaData property : properties) {
            this.updatePropertyAnnotations(repository, cl, mutable, context, property, beanInfo, add);
        }
    }

    private void updatePropertyAnnotations(MutableMetaDataRepository repository, ClassLoader classloader, ComponentMutableMetaData mutable, KernelControllerContext context, PropertyMetaData propertyMetaData, BeanInfo beanInfo, boolean add) {
        FieldInfo fieldInfo;
        Set<AnnotationMetaData> propertyAnnotations = propertyMetaData.getAnnotations();
        if (propertyAnnotations == null || propertyAnnotations.size() == 0) {
            return;
        }
        PropertyInfo propertyInfo = beanInfo.getProperty(propertyMetaData.getName());
        MethodInfo methodInfo = propertyInfo.getGetter();
        if (methodInfo != null) {
            this.updateAnnotations(repository, classloader, mutable, context, methodInfo, propertyAnnotations, add);
        }
        if ((methodInfo = propertyInfo.getSetter()) != null) {
            this.updateAnnotations(repository, classloader, mutable, context, methodInfo, propertyAnnotations, add);
        }
        if ((fieldInfo = propertyInfo.getFieldInfo()) != null) {
            this.updateAnnotations(repository, classloader, mutable, context, fieldInfo, propertyAnnotations, add);
        }
    }

    private void updateAnnotations(MutableMetaDataRepository repository, ClassLoader classloader, ComponentMutableMetaData component, KernelControllerContext context, Signature signature, ScopeKey scope, Set<AnnotationMetaData> annotations, boolean add) {
        MutableMetaDataLoader mutable;
        MetaDataRetrieval retrieval = ((MetaDataRetrieval)component).getComponentMetaDataRetrieval(signature);
        if (retrieval != null) {
            mutable = this.getMutableMetaDataLoader(retrieval);
            if (mutable == null) {
                if (add) {
                    log.warn((Object)("MetaData is not mutable with signature: " + signature + " for " + context.toShortString()));
                }
                return;
            }
        } else if (add) {
            mutable = this.initMutableMetaDataRetrieval(repository, context, scope);
            component.addComponentMetaDataRetrieval(signature, (MetaDataRetrieval)mutable);
        } else {
            return;
        }
        this.updateAnnotations(classloader, mutable, annotations, add);
    }

    private void updateAnnotations(MutableMetaDataRepository repository, ClassLoader classloader, ComponentMutableMetaData component, KernelControllerContext context, MethodInfo methodInfo, Set<AnnotationMetaData> annotations, boolean add) {
        if (annotations == null || annotations.isEmpty()) {
            return;
        }
        MethodSignature signature = new MethodSignature(methodInfo);
        ScopeKey scope = new ScopeKey(CommonLevels.JOINPOINT_OVERRIDE, (Object)methodInfo.getName());
        this.updateAnnotations(repository, classloader, component, context, (Signature)signature, scope, annotations, add);
    }

    private void updateAnnotations(MutableMetaDataRepository repository, ClassLoader classloader, ComponentMutableMetaData component, KernelControllerContext context, FieldInfo fieldInfo, Set<AnnotationMetaData> annotations, boolean add) {
        if (annotations == null || annotations.isEmpty()) {
            return;
        }
        FieldSignature signature = new FieldSignature(fieldInfo);
        ScopeKey scope = new ScopeKey(CommonLevels.JOINPOINT_OVERRIDE, (Object)fieldInfo.getName());
        this.updateAnnotations(repository, classloader, component, context, (Signature)signature, scope, annotations, add);
    }

    private void updateAnnotations(ClassLoader classloader, MutableMetaDataLoader mutable, Set<AnnotationMetaData> annotations, boolean add) {
        if (annotations == null || annotations.size() == 0) {
            return;
        }
        for (AnnotationMetaData annotation : annotations) {
            Annotation annotationInstance;
            if (add) {
                annotationInstance = annotation.getAnnotationInstance(classloader);
                mutable.addAnnotation(annotationInstance);
                continue;
            }
            annotationInstance = null;
            if (annotation instanceof CachingAnnotationMetaData) {
                annotationInstance = ((CachingAnnotationMetaData)annotation).removeAnnotation();
            }
            if (annotationInstance == null) {
                annotationInstance = annotation.getAnnotationInstance(classloader);
            }
            if (annotationInstance == null) continue;
            mutable.removeAnnotation(annotationInstance.annotationType());
        }
    }

    protected MetaDataRetrieval createMetaDataRetrieval(ControllerContext context, List<MetaDataRetrieval> retrievals) {
        KernelController kernelController;
        MetaDataRetrieval result;
        Controller controller = context.getController();
        if (controller instanceof KernelController && (result = (kernelController = (KernelController)controller).getKernel().getMetaDataRepository().createMetaDataRetrieval(context, retrievals)) != null) {
            return result;
        }
        return super.createMetaDataRetrieval(context, retrievals);
    }
}

