/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.test.ext;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DebugResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.resolver.WarningResolutionListener;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.jboss.maven.plugins.test.ext.Environment;
import org.jboss.maven.plugins.test.ext.EnvironmentBuilder;
import org.jboss.maven.shared.xml.dom4j.DocumentLoader;

public class ExtenderMojo
extends AbstractMojo
implements LogEnabled {
    public static final String FILE_SEPARATOR = "/";
    protected MavenProject project;
    protected ArtifactRepository localRepository;
    protected ArtifactCollector artifactCollector;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected String extenderConfig;
    protected String extenderEnv;
    private Logger logger;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"starting test environment extension mojo");
        Environment environment = this.parseEnvironment();
        if (environment != null) {
            this.extendTestClasspath(environment);
        }
    }

    protected Environment parseEnvironment() throws MojoExecutionException {
        Document extenderConfigDocument = this.loadExtenderConfigDocument();
        if (extenderConfigDocument == null) {
            return null;
        }
        EnvironmentBuilder environmentBuilder = new EnvironmentBuilder();
        Iterator itr = extenderConfigDocument.getRootElement().elementIterator("environment");
        while (itr.hasNext()) {
            Element environmentElement = (Element)itr.next();
            if (!this.extenderEnv.equals(environmentBuilder.extractEnvironmentName(environmentElement))) continue;
            this.getLog().info((CharSequence)("found environment definition [" + this.extenderEnv + "]"));
            return environmentBuilder.buildEnvironment(environmentElement);
        }
        this.getLog().info((CharSequence)("Unable to locate appropriate extender env [" + this.extenderEnv + "] in specified config [" + this.extenderConfig + "]"));
        return null;
    }

    protected Document loadExtenderConfigDocument() throws MojoExecutionException {
        if (this.extenderConfig == null) {
            return null;
        }
        File extenderConfigFile = new File(this.extenderConfig);
        if (!extenderConfigFile.exists()) {
            this.getLog().warn((CharSequence)("Could not locate specified extender config file [" + this.extenderConfig + "]"));
            return null;
        }
        return new DocumentLoader(this.getLog()).loadDocument(extenderConfigFile);
    }

    protected void extendTestClasspath(Environment environment) throws MojoExecutionException {
        this.attachDependencies(environment.getDependencies());
        this.attachResources(environment.getResources());
    }

    protected void attachDependencies(List dependencies) throws MojoExecutionException {
        HashSet combinedDependencyArtifacts = new HashSet();
        combinedDependencyArtifacts.addAll(this.project.getDependencyArtifacts());
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        Iterator itr = dependencies.iterator();
        while (itr.hasNext()) {
            Dependency dependency = (Dependency)itr.next();
            try {
                VersionRange versionRange = VersionRange.createFromVersionSpec((String)dependency.getVersion());
                Artifact artifact = this.artifactFactory.createDependencyArtifact(dependency.getGroupId(), dependency.getArtifactId(), versionRange, dependency.getType(), dependency.getClassifier(), "test", false);
                artifacts.add(artifact);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException("Unable to parse version");
            }
        }
        try {
            ArrayList<Object> listeners = new ArrayList<Object>();
            listeners.add(new WarningResolutionListener(this.logger));
            if (this.logger.isDebugEnabled()) {
                listeners.add(new DebugResolutionListener(this.logger));
            }
            ArtifactResolutionResult artifactResolutionResult = this.artifactCollector.collect(artifacts, this.project.getArtifact(), this.localRepository, this.project.getRemoteArtifactRepositories(), this.artifactMetadataSource, null, listeners);
            itr = artifactResolutionResult.getArtifactResolutionNodes().iterator();
            while (itr.hasNext()) {
                ResolutionNode node = (ResolutionNode)itr.next();
                Artifact artifact = node.getArtifact();
                if (!artifact.isResolved()) {
                    this.artifactResolver.resolve(artifact, node.getRemoteRepositories(), this.localRepository);
                }
                this.getLog().info((CharSequence)("adding dependency artifact [" + this.extenderEnv + "] : " + artifact.getId()));
            }
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to download artifact " + this.buildInfo((AbstractArtifactResolutionException)e) + " : " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact " + this.buildInfo((AbstractArtifactResolutionException)e) + " : " + e.getMessage(), (Exception)((Object)e));
        }
        combinedDependencyArtifacts.addAll(artifacts);
        this.project.setDependencyArtifacts(combinedDependencyArtifacts);
        this.project.setArtifacts(null);
    }

    protected void attachResources(List resources) {
        Iterator itr = resources.iterator();
        while (itr.hasNext()) {
            Resource resource = (Resource)itr.next();
            this.alignToBaseDirectory(resource);
            this.project.addTestResource(resource);
        }
    }

    private void alignToBaseDirectory(Resource resource) {
        resource.setDirectory(this.alignToBaseDirectory(resource.getDirectory(), this.project.getBasedir()));
    }

    public String alignToBaseDirectory(String path, File basedir) {
        String s = this.stripBasedirToken(path);
        if (this.requiresBaseDirectoryAlignment(s)) {
            s = new File(basedir, s).getAbsolutePath();
        }
        return s;
    }

    private String stripBasedirToken(String s) {
        if (s != null && (s = s.trim()).startsWith("${basedir}")) {
            s = s.substring(11);
        }
        return s;
    }

    private boolean requiresBaseDirectoryAlignment(String s) {
        if (s != null) {
            File f = new File(s);
            return !s.startsWith(FILE_SEPARATOR) && !f.isAbsolute();
        }
        return false;
    }

    private String buildInfo(AbstractArtifactResolutionException e) {
        return "[" + e.getGroupId() + ":" + e.getArtifactId() + ":" + e.getVersion() + "]";
    }
}

