/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.test.ext;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Resource;
import org.dom4j.Element;
import org.jboss.maven.plugins.test.ext.Environment;
import org.jboss.maven.shared.xml.dom4j.AttributeValueExtracter;
import org.jboss.maven.shared.xml.dom4j.ElementValueExtracter;
import org.jboss.maven.shared.xml.dom4j.Extracter;
import org.jboss.maven.shared.xml.dom4j.NestedElementValueExtracter;

public class EnvironmentBuilder {
    public static final String ENVIRONMENT = "environment";
    private static Extracter ENV_NAME_EXTRACTER = new AttributeValueExtracter("name", true, null);
    private static Extracter BASIC_ELEMENT_VALUE_EXTRACTER = new ElementValueExtracter();
    private static Extracter GROUPID_EXTRACTER = new NestedElementValueExtracter("groupId", true, null);
    private static Extracter ARTIFACTID_EXTRACTER = new NestedElementValueExtracter("artifactId", true, null);
    private static Extracter VERSION_EXTRACTER = new NestedElementValueExtracter("version", true, null);
    private static Extracter TYPE_EXTRACTER = new NestedElementValueExtracter("type", false, "jar");
    private static Extracter CLASSIFIER_EXTRACTER = new NestedElementValueExtracter("classifier", false, null);
    private static Extracter SYSPATH_EXTRACTER = new NestedElementValueExtracter("systemPath", false, null);
    private static Extracter OPTIONAL_EXTRACTER = new NestedElementValueExtracter("optional", false, "false");
    private static Extracter DIRECTORY_EXTRACTER = new NestedElementValueExtracter("directory", true, null);
    private static Extracter TARGETPATH_EXTRACTER = new NestedElementValueExtracter("targetPath", false, null);
    private static Extracter FILTERING_EXTRACTER = new NestedElementValueExtracter("filtering", false, null);

    public String extractEnvironmentName(Element environmentElement) {
        return ENV_NAME_EXTRACTER.extract(environmentElement);
    }

    public Environment buildEnvironment(Element environmentElement) {
        return this.extractEnvironmentInfo(environmentElement);
    }

    private Environment extractEnvironmentInfo(Element environmentElement) {
        Element resourcesElement;
        Environment env = new Environment(this.extractEnvironmentName(environmentElement));
        Element dependenciesElement = environmentElement.element("dependencies");
        if (dependenciesElement != null) {
            Iterator dependencyElements = dependenciesElement.elementIterator("dependency");
            while (dependencyElements.hasNext()) {
                Element dependencyElement = (Element)dependencyElements.next();
                env.getDependencies().add(this.extractDependencyInfo(dependencyElement));
            }
        }
        if ((resourcesElement = environmentElement.element("testResources")) != null) {
            Iterator resourceElements = resourcesElement.elementIterator("testResource");
            while (resourceElements.hasNext()) {
                Element resourceElement = (Element)resourceElements.next();
                env.getResources().add(this.extractResourceInfo(resourceElement));
            }
        }
        return env;
    }

    private Dependency extractDependencyInfo(Element dependencyElement) {
        Dependency dependency = new Dependency();
        dependency.setModelEncoding(dependencyElement.getDocument().getXMLEncoding());
        dependency.setGroupId(GROUPID_EXTRACTER.extract(dependencyElement));
        dependency.setArtifactId(ARTIFACTID_EXTRACTER.extract(dependencyElement));
        dependency.setVersion(VERSION_EXTRACTER.extract(dependencyElement));
        dependency.setType(TYPE_EXTRACTER.extract(dependencyElement));
        dependency.setClassifier(CLASSIFIER_EXTRACTER.extract(dependencyElement));
        dependency.setSystemPath(SYSPATH_EXTRACTER.extract(dependencyElement));
        dependency.setOptional(Boolean.valueOf(OPTIONAL_EXTRACTER.extract(dependencyElement)).booleanValue());
        dependency.setScope("test");
        ArrayList<Object> exclusions = new ArrayList<Object>();
        Element exclusionsElement = dependencyElement.element("exclusions");
        if (exclusionsElement != null) {
            Iterator itr = exclusionsElement.elementIterator("exclusion");
            while (itr.hasNext()) {
                Element exclusionElement = (Element)itr.next();
                exclusions.add(this.extractExclusionInfo(exclusionElement));
            }
        }
        dependency.setExclusions(exclusions);
        return dependency;
    }

    private Object extractExclusionInfo(Element exclusionElement) {
        Exclusion exclusion = new Exclusion();
        exclusion.setModelEncoding(exclusionElement.getDocument().getXMLEncoding());
        exclusion.setGroupId(GROUPID_EXTRACTER.extract(exclusionElement));
        exclusion.setArtifactId(ARTIFACTID_EXTRACTER.extract(exclusionElement));
        return exclusion;
    }

    private Resource extractResourceInfo(Element resourceElement) {
        Resource resource = new Resource();
        resource.setModelEncoding(resourceElement.getDocument().getXMLEncoding());
        resource.setDirectory(DIRECTORY_EXTRACTER.extract(resourceElement));
        resource.setTargetPath(TARGETPATH_EXTRACTER.extract(resourceElement));
        resource.setFiltering(Boolean.valueOf(FILTERING_EXTRACTER.extract(resourceElement)).booleanValue());
        ArrayList<String> includes = new ArrayList<String>();
        Element includesElement = resourceElement.element("includes");
        if (includesElement != null) {
            Iterator itr = includesElement.elementIterator("include");
            while (itr.hasNext()) {
                Element includeElement = (Element)itr.next();
                includes.add(BASIC_ELEMENT_VALUE_EXTRACTER.extract(includeElement));
            }
        }
        resource.setIncludes(includes);
        ArrayList<String> excludes = new ArrayList<String>();
        Element excludesElement = resourceElement.element("excludes");
        if (excludesElement != null) {
            Iterator itr = excludesElement.elementIterator("exclude");
            while (itr.hasNext()) {
                Element excludeElement = (Element)itr.next();
                excludes.add(BASIC_ELEMENT_VALUE_EXTRACTER.extract(excludeElement));
            }
        }
        resource.setExcludes(excludes);
        return resource;
    }
}

