/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.QSCheckerException;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.common.UnusedPropertiesUtil;
import org.jboss.maven.plugins.qstools.config.ConfigurationProvider;
import org.jboss.maven.plugins.qstools.config.Rules;

@Component(role=QSChecker.class, hint="unusedPropertiesChecker")
public class UnusedPropertiesChecker
implements QSChecker {
    private int violationsQtd;
    @Requirement
    private ConfigurationProvider configurationProvider;
    @Requirement
    private UnusedPropertiesUtil unusedPropertiesUtil;

    @Override
    public int getViolatonsQtd() {
        return this.violationsQtd;
    }

    @Override
    public void resetViolationsQtd() {
        this.violationsQtd = 0;
    }

    @Override
    public String getCheckerDescription() {
        return "Checks if a project and its modules has a declared and unused propery";
    }

    @Override
    public Map<String, List<Violation>> check(MavenProject project, MavenSession mavenSession, List<MavenProject> reactorProjects, Log log) throws QSCheckerException {
        TreeMap<String, List<Violation>> results = new TreeMap<String, List<Violation>>();
        Rules rules = this.configurationProvider.getQuickstartsRules(project.getGroupId());
        if (rules.isCheckerIgnored(this)) {
            String msg = "Skiping %s for %s:%s";
            log.warn((CharSequence)String.format(msg, this.getClass().getSimpleName(), project.getGroupId(), project.getArtifactId()));
        } else {
            try {
                List<UnusedPropertiesUtil.PomInformation> unusedPropertyInfo = this.unusedPropertiesUtil.findUnusedProperties(reactorProjects, rules);
                for (UnusedPropertiesUtil.PomInformation pi : unusedPropertyInfo) {
                    String rootDirectory = (mavenSession.getExecutionRootDirectory() + File.separator).replace("\\", "\\\\");
                    String fileAsString = pi.getProject().getFile().getAbsolutePath().replace(rootDirectory, "");
                    if (results.get(fileAsString) == null) {
                        results.put(fileAsString, new ArrayList());
                    }
                    String msg = "Property [%s] was declared but was never used";
                    ((List)results.get(fileAsString)).add(new Violation(this.getClass(), pi.getLine(), String.format(msg, pi.getProperty())));
                    ++this.violationsQtd;
                }
                if (this.violationsQtd > 0) {
                    log.info((CharSequence)("There are " + this.violationsQtd + " checkers errors"));
                }
            }
            catch (Exception e) {
                throw new QSCheckerException(e);
            }
        }
        return results;
    }
}

