/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.config.ErrorManagerConfiguration;
import org.jboss.logmanager.config.FilterConfiguration;
import org.jboss.logmanager.config.FormatterConfiguration;
import org.jboss.logmanager.config.HandlerConfiguration;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.LoggerConfiguration;
import org.jboss.logmanager.config.PropertyConfigurable;

public final class PropertyConfigurator
implements Configurator {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final String ENCODING = "utf-8";
    private final LogContextConfiguration config;

    public PropertyConfigurator() {
        this(LogContext.getSystemLogContext());
    }

    public PropertyConfigurator(LogContext context) {
        this.config = LogContextConfiguration.Factory.create(context);
    }

    public LogContextConfiguration getLogContextConfiguration() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        try {
            properties.load(new InputStreamReader(inputStream, ENCODING));
            inputStream.close();
        }
        finally {
            PropertyConfigurator.safeClose(inputStream);
        }
        this.configure(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfiguration(OutputStream outputStream) throws IOException {
        try {
            PrintStream out = new PrintStream(outputStream, true, ENCODING);
            try {
                HashSet<String> implicitHandlers = new HashSet<String>();
                HashSet<String> implicitFormatters = new HashSet<String>();
                HashSet<String> implicitErrorManagers = new HashSet<String>();
                List<String> loggerNames = this.config.getLoggerNames();
                PropertyConfigurator.writePropertyComment(out, "Additional loggers to configure (the root logger is always configured)");
                out.printf("loggers=%s%n", PropertyConfigurator.toCsvString(loggerNames));
                LoggerConfiguration rootLogger = this.config.getLoggerConfiguration("");
                PropertyConfigurator.writeLoggerConfiguration(out, rootLogger, implicitHandlers);
                loggerNames.remove("");
                for (String loggerName : loggerNames) {
                    PropertyConfigurator.writeLoggerConfiguration(out, this.config.getLoggerConfiguration(loggerName), implicitHandlers);
                }
                List<String> allHandlerNames = this.config.getHandlerNames();
                ArrayList<String> explicitHandlerNames = new ArrayList<String>(allHandlerNames);
                explicitHandlerNames.removeAll(implicitHandlers);
                if (!explicitHandlerNames.isEmpty()) {
                    PropertyConfigurator.writePropertyComment(out, "Additional handlers to configure");
                    out.printf("handlers=%s%n%n", PropertyConfigurator.toCsvString(explicitHandlerNames));
                }
                for (String handlerName : allHandlerNames) {
                    PropertyConfigurator.writeHandlerConfiguration(out, this.config.getHandlerConfiguration(handlerName), implicitHandlers, implicitFormatters, implicitErrorManagers);
                }
                List<String> allFilterNames = this.config.getFilterNames();
                if (!allFilterNames.isEmpty()) {
                    PropertyConfigurator.writePropertyComment(out, "Additional filters to configure");
                    out.printf("filters=%s%n%n", PropertyConfigurator.toCsvString(allFilterNames));
                }
                for (String filterName : allFilterNames) {
                    PropertyConfigurator.writeFilterConfiguration(out, this.config.getFilterConfiguration(filterName));
                }
                List<String> allFormatterNames = this.config.getFormatterNames();
                ArrayList<String> explicitFormatterNames = new ArrayList<String>(allFormatterNames);
                explicitFormatterNames.removeAll(implicitFormatters);
                if (!explicitFormatterNames.isEmpty()) {
                    PropertyConfigurator.writePropertyComment(out, "Additional formatters to configure");
                    out.printf("formatters=%s%n%n", PropertyConfigurator.toCsvString(explicitFormatterNames));
                }
                for (String formatterName : allFormatterNames) {
                    PropertyConfigurator.writeFormatterConfiguration(out, this.config.getFormatterConfiguration(formatterName));
                }
                List<String> allErrorManagerNames = this.config.getErrorManagerNames();
                ArrayList<String> explicitErrorManagerNames = new ArrayList<String>(allErrorManagerNames);
                explicitErrorManagerNames.removeAll(implicitErrorManagers);
                if (!explicitErrorManagerNames.isEmpty()) {
                    PropertyConfigurator.writePropertyComment(out, "Additional errorManagers to configure");
                    out.printf("errorManagers=%s%n%n", PropertyConfigurator.toCsvString(explicitErrorManagerNames));
                }
                for (String errorManagerName : allErrorManagerNames) {
                    PropertyConfigurator.writeErrorManagerConfiguration(out, this.config.getErrorManagerConfiguration(errorManagerName));
                }
                out.close();
            }
            finally {
                PropertyConfigurator.safeClose(out);
            }
            outputStream.close();
        }
        finally {
            PropertyConfigurator.safeClose(outputStream);
        }
    }

    private static void writeLoggerConfiguration(PrintStream out, LoggerConfiguration logger, Set<String> implicitHandlers) throws IOException {
        if (logger != null) {
            List<String> handlerNames;
            Boolean useParentHandlers;
            String filterName;
            out.println();
            String name = logger.getName();
            String prefix = name.isEmpty() ? "logger." : "logger." + name + ".";
            String level = logger.getLevel();
            if (level != null) {
                PropertyConfigurator.writeProperty(out, prefix, "level", level);
            }
            if ((filterName = logger.getFilter()) != null) {
                PropertyConfigurator.writeProperty(out, prefix, "filter", filterName);
            }
            if ((useParentHandlers = logger.getUseParentHandlers()) != null) {
                PropertyConfigurator.writeProperty(out, prefix, "useParentHandlers", useParentHandlers);
            }
            if (!(handlerNames = logger.getHandlerNames()).isEmpty()) {
                PropertyConfigurator.writeProperty(out, prefix, "handlers", PropertyConfigurator.toCsvString(handlerNames));
                for (String handlerName : handlerNames) {
                    implicitHandlers.add(handlerName);
                }
            }
        }
    }

    private static void writeHandlerConfiguration(PrintStream out, HandlerConfiguration handler, Set<String> implicitHandlers, Set<String> implicitFormatters, Set<String> implicitErrorManagers) throws IOException {
        if (handler != null) {
            List<String> handlerNames;
            String errorManagerName;
            String formatterName;
            String filter;
            String level;
            out.println();
            String name = handler.getName();
            String prefix = "handler." + name + ".";
            String className = handler.getClassName();
            out.printf("handler.%s=%s%n", name, className);
            String moduleName = handler.getModuleName();
            if (moduleName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "module", moduleName);
            }
            if ((level = handler.getLevel()) != null) {
                PropertyConfigurator.writeProperty(out, prefix, "level", level);
            }
            if ((filter = handler.getFilter()) != null) {
                PropertyConfigurator.writeProperty(out, prefix, "filter", filter);
            }
            if ((formatterName = handler.getFormatterName()) != null) {
                PropertyConfigurator.writeProperty(out, prefix, "formatter", formatterName);
                implicitFormatters.add(formatterName);
            }
            if ((errorManagerName = handler.getErrorManagerName()) != null) {
                PropertyConfigurator.writeProperty(out, prefix, "errorManager", errorManagerName);
                implicitErrorManagers.add(errorManagerName);
            }
            if (!(handlerNames = handler.getHandlerNames()).isEmpty()) {
                PropertyConfigurator.writeProperty(out, prefix, "handlers", PropertyConfigurator.toCsvString(handlerNames));
                for (String handlerName : handlerNames) {
                    implicitHandlers.add(handlerName);
                }
            }
            PropertyConfigurator.writeProperties(out, prefix, handler);
        }
    }

    private static void writeFilterConfiguration(PrintStream out, FilterConfiguration filter) throws IOException {
        if (filter != null) {
            out.println();
            String name = filter.getName();
            String prefix = "filter." + name + ".";
            String className = filter.getClassName();
            PropertyConfigurator.writeProperty(out, "filter.", name, className);
            String moduleName = filter.getModuleName();
            if (moduleName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "module", moduleName);
            }
            PropertyConfigurator.writeProperties(out, prefix, filter);
        }
    }

    private static void writeFormatterConfiguration(PrintStream out, FormatterConfiguration formatter) throws IOException {
        if (formatter != null) {
            out.println();
            String name = formatter.getName();
            String prefix = "formatter." + name + ".";
            String className = formatter.getClassName();
            PropertyConfigurator.writeProperty(out, "formatter.", name, className);
            String moduleName = formatter.getModuleName();
            if (moduleName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "module", moduleName);
            }
            PropertyConfigurator.writeProperties(out, prefix, formatter);
        }
    }

    private static void writeErrorManagerConfiguration(PrintStream out, ErrorManagerConfiguration errorManager) throws IOException {
        if (errorManager != null) {
            out.println();
            String name = errorManager.getName();
            String prefix = "errorManager." + name + ".";
            String className = errorManager.getClassName();
            PropertyConfigurator.writeProperty(out, "errorManager.", name, className);
            String moduleName = errorManager.getModuleName();
            if (moduleName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "module", moduleName);
            }
            PropertyConfigurator.writeProperties(out, prefix, errorManager);
        }
    }

    private static void writePropertyComment(PrintStream out, String comment) {
        out.printf("%n# %s%n", comment);
    }

    private static void writeProperty(PrintStream out, String prefix, String name, Object value) {
        if (prefix == null) {
            out.printf("%s=%s%n", name, value);
        } else {
            out.printf("%s%s=%s%n", prefix, name, value);
        }
    }

    private static void writeProperties(PrintStream out, String prefix, PropertyConfigurable propertyConfigurable) {
        block6: {
            List<String> names = propertyConfigurable.getPropertyNames();
            if (names.isEmpty()) break block6;
            List<String> ctorProps = propertyConfigurable.getConstructorProperties();
            if (prefix == null) {
                out.printf("properties=%s%n", PropertyConfigurator.toCsvString(names));
                if (!ctorProps.isEmpty()) {
                    out.printf("constructorProperties=%s%n", PropertyConfigurator.toCsvString(ctorProps));
                }
                for (String name : names) {
                    PropertyConfigurator.writeProperty(out, null, name, propertyConfigurable.getPropertyValueString(name));
                }
            } else {
                out.printf("%sproperties=%s%n", prefix, PropertyConfigurator.toCsvString(names));
                if (!ctorProps.isEmpty()) {
                    out.printf("%sconstructorProperties=%s%n", prefix, PropertyConfigurator.toCsvString(ctorProps));
                }
                for (String name : names) {
                    PropertyConfigurator.writeProperty(out, prefix, name, propertyConfigurable.getPropertyValueString(name));
                }
            }
        }
    }

    private static String toCsvString(List<String> names) {
        StringBuilder result = new StringBuilder(1024);
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            String name = iterator.next();
            if (name.isEmpty()) continue;
            result.append(name);
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Properties properties) throws IOException {
        try {
            this.configureLogger(properties, "");
            for (String loggerName : PropertyConfigurator.getStringCsvArray(properties, "loggers")) {
                this.configureLogger(properties, loggerName);
            }
            for (String handlerName : PropertyConfigurator.getStringCsvArray(properties, "handlers")) {
                this.configureHandler(properties, handlerName);
            }
            for (String filterName : PropertyConfigurator.getStringCsvArray(properties, "filters")) {
                this.configureFilter(properties, filterName);
            }
            for (String formatterName : PropertyConfigurator.getStringCsvArray(properties, "formatters")) {
                this.configureFormatter(properties, formatterName);
            }
            for (String errorManagerName : PropertyConfigurator.getStringCsvArray(properties, "errorManagers")) {
                this.configureErrorManager(properties, errorManagerName);
            }
            this.config.commit();
        }
        finally {
            this.config.forget();
        }
    }

    private void configureLogger(Properties properties, String loggerName) throws IOException {
        String filterName;
        if (this.config.getLoggerConfiguration(loggerName) != null) {
            return;
        }
        LoggerConfiguration loggerConfiguration = this.config.addLoggerConfiguration(loggerName);
        String levelName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("logger", loggerName, "level"));
        if (levelName != null) {
            loggerConfiguration.setLevel(levelName);
        }
        if ((filterName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("logger", loggerName, "filter"))) != null) {
            loggerConfiguration.setFilter(filterName);
            this.configureFilter(properties, filterName);
        }
        String[] handlerNames = PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("logger", loggerName, "handlers"));
        loggerConfiguration.setHandlerNames(handlerNames);
        for (String name : handlerNames) {
            this.configureHandler(properties, name);
        }
        String useParentHandlersString = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("logger", loggerName, "useParentHandlers"));
        if (useParentHandlersString != null) {
            loggerConfiguration.setUseParentHandlers(Boolean.parseBoolean(useParentHandlersString));
        }
    }

    private void configureFilter(Properties properties, String filterName) throws IOException {
        if (this.config.getFilterConfiguration(filterName) != null) {
            return;
        }
        FilterConfiguration configuration = this.config.addFilterConfiguration(PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("filter", filterName, "module")), PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("filter", filterName)), filterName, PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("filter", filterName, "constructorProperties")));
        this.configureProperties(properties, configuration, PropertyConfigurator.getKey("filter", filterName));
    }

    private void configureFormatter(Properties properties, String formatterName) throws IOException {
        if (this.config.getFormatterConfiguration(formatterName) != null) {
            return;
        }
        FormatterConfiguration configuration = this.config.addFormatterConfiguration(PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("formatter", formatterName, "module")), PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("formatter", formatterName)), formatterName, PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("formatter", formatterName, "constructorProperties")));
        this.configureProperties(properties, configuration, PropertyConfigurator.getKey("formatter", formatterName));
    }

    private void configureErrorManager(Properties properties, String errorManagerName) throws IOException {
        if (this.config.getErrorManagerConfiguration(errorManagerName) != null) {
            return;
        }
        ErrorManagerConfiguration configuration = this.config.addErrorManagerConfiguration(PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("errorManager", errorManagerName, "module")), PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("errorManager", errorManagerName)), errorManagerName, PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("errorManager", errorManagerName, "constructorProperties")));
        this.configureProperties(properties, configuration, PropertyConfigurator.getKey("errorManager", errorManagerName));
    }

    private void configureHandler(Properties properties, String handlerName) throws IOException {
        String errorManagerName;
        String encoding;
        String formatterName;
        String levelName;
        if (this.config.getHandlerConfiguration(handlerName) != null) {
            return;
        }
        HandlerConfiguration configuration = this.config.addHandlerConfiguration(PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "module")), PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName)), handlerName, PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("handler", handlerName, "constructorProperties")));
        String filter = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "filter"));
        if (filter != null) {
            configuration.setFilter(filter);
        }
        if ((levelName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "level"))) != null) {
            configuration.setLevel(levelName);
        }
        if ((formatterName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "formatter"))) != null) {
            configuration.setFormatterName(formatterName);
            this.configureFormatter(properties, formatterName);
        }
        if ((encoding = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "encoding"))) != null) {
            configuration.setEncoding(encoding);
        }
        if ((errorManagerName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "errorManager"))) != null) {
            configuration.setErrorManagerName(errorManagerName);
            this.configureErrorManager(properties, errorManagerName);
        }
        String[] handlerNames = PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("handler", handlerName, "handlers"));
        configuration.setHandlerNames(handlerNames);
        for (String name : handlerNames) {
            this.configureHandler(properties, name);
        }
        this.configureProperties(properties, configuration, PropertyConfigurator.getKey("handler", handlerName));
    }

    private void configureProperties(Properties properties, PropertyConfigurable configurable, String prefix) throws IOException {
        List<String> propertyNames = PropertyConfigurator.getStringCsvList(properties, PropertyConfigurator.getKey(prefix, "properties"));
        for (String propertyName : propertyNames) {
            String valueString = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey(prefix, propertyName));
            if (valueString == null) continue;
            configurable.setPropertyValueString(propertyName, valueString);
        }
    }

    private static String getKey(String prefix, String objectName) {
        return objectName.length() > 0 ? prefix + "." + objectName : prefix;
    }

    private static String getKey(String prefix, String objectName, String key) {
        return objectName.length() > 0 ? prefix + "." + objectName + "." + key : prefix + "." + key;
    }

    private static String getStringProperty(Properties properties, String key) {
        return properties.getProperty(key);
    }

    private static String[] getStringCsvArray(Properties properties, String key) {
        String property = properties.getProperty(key, "");
        if (property == null) {
            return EMPTY_STRINGS;
        }
        String value = property.trim();
        if (value.length() == 0) {
            return EMPTY_STRINGS;
        }
        return value.split("\\s*,\\s*");
    }

    private static List<String> getStringCsvList(Properties properties, String key) {
        return new ArrayList<String>(Arrays.asList(PropertyConfigurator.getStringCsvArray(properties, key)));
    }

    private static void safeClose(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

