/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor;

import java.util.ServiceLoader;
import org.jboss.logging.processor.Annotations;
import org.jboss.logging.processor.BaseAnnotations;
import org.jboss.logging.processor.BaseLoggers;
import org.jboss.logging.processor.Loggers;
import org.jboss.logging.processor.apt.AptHelper;
import org.jboss.logging.processor.apt.AptHelperImpl;

public class Tools {
    private static volatile AptHelper aptHelper;
    private static volatile Annotations annotations;
    private static volatile Loggers loggers;
    private static final ServiceLoader<AptHelper> aptHelperLoader;
    private static final ServiceLoader<Annotations> annotationsLoader;
    private static final ServiceLoader<Loggers> loggersLoader;

    private Tools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Annotations annotations() {
        Annotations result = annotations;
        if (result == null) {
            ServiceLoader<Annotations> serviceLoader = annotationsLoader;
            synchronized (serviceLoader) {
                result = annotations;
                if (result == null) {
                    annotations = annotationsLoader.iterator().hasNext() ? (result = annotationsLoader.iterator().next()) : (result = new BaseAnnotations());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AptHelper aptHelper() {
        AptHelper result = aptHelper;
        if (result == null) {
            ServiceLoader<AptHelper> serviceLoader = aptHelperLoader;
            synchronized (serviceLoader) {
                result = aptHelper;
                if (result == null) {
                    aptHelper = aptHelperLoader.iterator().hasNext() ? (result = aptHelperLoader.iterator().next()) : (result = new AptHelperImpl());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Loggers loggers() {
        Loggers result = loggers;
        if (result == null) {
            ServiceLoader<Loggers> serviceLoader = loggersLoader;
            synchronized (serviceLoader) {
                result = loggers;
                if (result == null) {
                    loggers = loggersLoader.iterator().hasNext() ? (result = loggersLoader.iterator().next()) : (result = new BaseLoggers());
                }
            }
        }
        return result;
    }

    static {
        aptHelperLoader = ServiceLoader.load(AptHelper.class, Tools.class.getClassLoader());
        annotationsLoader = ServiceLoader.load(Annotations.class, Tools.class.getClassLoader());
        loggersLoader = ServiceLoader.load(Loggers.class, Tools.class.getClassLoader());
    }
}

