/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.validation.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import org.jboss.logging.Annotations;
import org.jboss.logging.validation.ValidationErrorMessage;
import org.jboss.logging.validation.ValidationMessage;
import org.jboss.logging.validation.validator.AbstractValidator;

public class MessageAnnotationValidator
extends AbstractValidator {
    private static final String ERROR_MESSAGE = "Only one method with the same name is allowed to be annotated the %s annotation.";

    public MessageAnnotationValidator(Annotations annotations, Types typeUtil) {
        super(annotations, typeUtil);
    }

    @Override
    public Collection<ValidationMessage> validate(TypeElement element, Collection<ExecutableElement> elementMethods) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        HashSet<Name> methodNames = new HashSet<Name>();
        for (ExecutableElement method : elementMethods) {
            if (!methodNames.add(method.getSimpleName())) continue;
            Collection<ExecutableElement> likeMethods = this.findByName(elementMethods, method.getSimpleName());
            boolean foundFirst = false;
            for (ExecutableElement m : likeMethods) {
                boolean found;
                boolean bl = found = m.getAnnotation(this.annotations.message()) != null;
                if (foundFirst && found) {
                    messages.add(ValidationErrorMessage.of(m, ERROR_MESSAGE, this.annotations.message().getName()));
                }
                foundFirst = found;
            }
        }
        return messages;
    }
}

