/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.validation.validator;

import java.util.ArrayList;
import java.util.Collection;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.jboss.logging.Annotations;
import org.jboss.logging.util.ElementHelper;
import org.jboss.logging.validation.ValidationErrorMessage;
import org.jboss.logging.validation.ValidationMessage;
import org.jboss.logging.validation.validator.AbstractValidator;

public class LoggerReturnTypeValidator
extends AbstractValidator {
    public LoggerReturnTypeValidator(Annotations annotations, Types typeUtil) {
        super(annotations, typeUtil);
    }

    @Override
    public Collection<ValidationMessage> validate(TypeElement element, Collection<ExecutableElement> elementMethods) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (ElementHelper.isAnnotatedWith(element, this.annotations.messageLogger())) {
            for (ExecutableElement method : elementMethods) {
                if (ElementHelper.isAnnotatedWith(method, this.annotations.logMessage())) {
                    if (method.getReturnType().getKind() == TypeKind.VOID) continue;
                    messages.add(ValidationErrorMessage.of(method, "Methods annotated with %s must have a void return type.", this.annotations.logMessage().getName()));
                    continue;
                }
                if (method.getReturnType().getKind() == TypeKind.VOID) {
                    messages.add(ValidationErrorMessage.of(method, "Cannot have a void return type if the method is not a log method."));
                    continue;
                }
                messages.addAll(this.checkMessageBundleMethod(element, method));
            }
        }
        return messages;
    }
}

