/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.validation;

import javax.lang.model.element.Element;
import org.jboss.logging.validation.ValidationMessage;

public class ValidationErrorMessage
implements ValidationMessage {
    private final Element element;
    private final String message;

    public ValidationErrorMessage(Element element, String message) {
        this.element = element;
        this.message = message;
    }

    public static ValidationErrorMessage of(Element element, String message) {
        return new ValidationErrorMessage(element, message);
    }

    public static ValidationErrorMessage of(Element element, String messageFormat, Object ... args) {
        return new ValidationErrorMessage(element, String.format(messageFormat, args));
    }

    @Override
    public ValidationMessage.MessageType type() {
        return ValidationMessage.MessageType.ERROR;
    }

    public int hashCode() {
        int prime = 31;
        int hash = 1;
        hash = 31 * hash + (this.element == null ? 0 : ((Object)this.element).hashCode());
        hash = 31 * hash + (this.message == null ? 0 : this.message.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ValidationErrorMessage)) {
            return false;
        }
        ValidationErrorMessage other = (ValidationErrorMessage)obj;
        if (this.element == null ? other.element != null : !((Object)this.element).equals(other.message)) {
            return false;
        }
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName()).append("(element=").append(this.element).append(", message=").append(this.message).append(")");
        return result.toString();
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

