/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.xb.annotations.JBossXmlCollection;
import org.jboss.xb.builder.runtime.AbstractPropertyHandler;
import org.jboss.xb.builder.runtime.BuilderUtil;
import org.jboss.xb.spi.BeanAdapter;

public class CollectionPropertyHandler
extends AbstractPropertyHandler {
    private final CollectionFactory colFactory;

    public CollectionPropertyHandler(PropertyInfo propertyInfo, TypeInfo propertyType) {
        super(propertyInfo, propertyType);
        ClassInfo collectionType = null;
        JBossXmlCollection xmlCol = (JBossXmlCollection)propertyInfo.getUnderlyingAnnotation(JBossXmlCollection.class);
        if (xmlCol != null) {
            collectionType = (ClassInfo)propertyType.getTypeInfoFactory().getTypeInfo(xmlCol.type());
        } else if (!Modifier.isAbstract(((ClassInfo)propertyType).getModifiers())) {
            collectionType = (ClassInfo)propertyType;
        }
        if (collectionType == null) {
            TypeInfo set = propertyType.getTypeInfoFactory().getTypeInfo(Set.class);
            this.colFactory = set.isAssignableFrom(propertyType) ? new HashSetFactory() : new ArrayListFactory();
        } else {
            ConstructorInfo constructor = collectionType.getDeclaredConstructor(null);
            if (constructor == null) {
                for (ConstructorInfo ctor : collectionType.getDeclaredConstructors()) {
                    if (ctor.getParameterTypes().length != 0) continue;
                    this.log.warn((Object)("ClassInfo.getDeclaredConstructor(null) didn't work for " + collectionType.getName() + ", found the default ctor in ClassInfo.getDeclaredConstructors()"));
                    constructor = ctor;
                    break;
                }
                if (constructor == null) {
                    throw new RuntimeException("Default constructor not found for " + collectionType.getName());
                }
            }
            this.colFactory = new CtorCollectionFactory(constructor);
        }
    }

    public void handle(PropertyInfo propertyInfo, TypeInfo propertyType, Object parent, Object child, QName qName) {
        BeanAdapter beanAdapter = (BeanAdapter)parent;
        Collection<Object> c = null;
        try {
            if (propertyInfo.getGetter() != null) {
                c = (Collection<Object>)beanAdapter.get(propertyInfo);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("QName " + qName + " error getting collection property " + propertyInfo.getName() + " for " + BuilderUtil.toDebugString(parent), t);
        }
        if (c == null) {
            try {
                c = this.colFactory.createCollection();
            }
            catch (Throwable t) {
                throw new RuntimeException("QName " + qName + " error creating collection: " + propertyType.getName(), t);
            }
            try {
                beanAdapter.set(propertyInfo, c);
            }
            catch (Throwable t) {
                throw new RuntimeException("QName " + qName + " error setting collection property " + propertyInfo.getName() + " for " + BuilderUtil.toDebugString(parent) + " with value " + BuilderUtil.toDebugString(c), t);
            }
        }
        try {
            c.add(child);
        }
        catch (Exception e) {
            throw new RuntimeException("QName " + qName + " error adding " + BuilderUtil.toDebugString(child) + " to collection " + BuilderUtil.toDebugString(c), e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CtorCollectionFactory
    implements CollectionFactory {
        private final ConstructorInfo ctor;

        CtorCollectionFactory(ConstructorInfo ctor) {
            this.ctor = ctor;
        }

        @Override
        public Collection<Object> createCollection() throws Throwable {
            return (Collection)this.ctor.newInstance(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashSetFactory
    implements CollectionFactory {
        private HashSetFactory() {
        }

        @Override
        public Collection<Object> createCollection() {
            return new HashSet<Object>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayListFactory
    implements CollectionFactory {
        private ArrayListFactory() {
        }

        @Override
        public Collection<Object> createCollection() {
            return new ArrayList<Object>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface CollectionFactory {
        public Collection<Object> createCollection() throws Throwable;
    }
}

