/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.lang.reflect.Method;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.GenericObjectModelProvider;
import org.jboss.xb.binding.MarshallingContext;
import org.jboss.xb.binding.ObjectModelProvider;

public class DelegatingObjectModelProvider
implements GenericObjectModelProvider {
    private static final Logger log = Logger.getLogger(DelegatingObjectModelProvider.class);
    private final ObjectModelProvider provider;
    private final boolean trace = log.isTraceEnabled();

    public DelegatingObjectModelProvider(ObjectModelProvider provider) {
        this.provider = provider;
    }

    public Object getChildren(Object o, MarshallingContext ctx, String namespaceURI, String localName) {
        return this.provideChildren(this.provider, o, namespaceURI, localName);
    }

    public Object getElementValue(Object o, MarshallingContext ctx, String namespaceURI, String localName) {
        return this.provideValue(this.provider, o, namespaceURI, localName);
    }

    public Object getAttributeValue(Object o, MarshallingContext ctx, String namespaceURI, String localName) {
        return this.provideAttributeValue(this.provider, o, namespaceURI, localName);
    }

    public Object getRoot(Object o, MarshallingContext ctx, String namespaceURI, String localName) {
        return this.provider.getRoot(o, null, namespaceURI, localName);
    }

    Object provideChildren(ObjectModelProvider provider, Object parent, String namespaceUri, String name) {
        Class<?> providerClass = provider.getClass();
        Class<?> parentClass = parent.getClass();
        String methodName = "getChildren";
        Object container = null;
        Method method = DelegatingObjectModelProvider.getProviderMethod(providerClass, methodName, new Class[]{parentClass, String.class, String.class});
        if (method != null) {
            try {
                container = method.invoke((Object)provider, parent, namespaceUri, name);
            }
            catch (Exception e) {
                log.error((Object)("Failed to invoke method " + methodName), (Throwable)e);
                throw new IllegalStateException("Failed to invoke method " + methodName);
            }
        } else if (this.trace) {
            log.trace((Object)("No " + methodName + " for " + name));
        }
        return container;
    }

    Object provideValue(ObjectModelProvider provider, Object parent, String namespaceUri, String name) {
        Class<?> providerClass = provider.getClass();
        Class<?> parentClass = parent.getClass();
        String methodName = "getElementValue";
        Object value = null;
        Method method = DelegatingObjectModelProvider.getProviderMethod(providerClass, methodName, new Class[]{parentClass, String.class, String.class});
        if (method != null) {
            try {
                value = method.invoke((Object)provider, parent, namespaceUri, name);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to invoke method " + methodName);
            }
        } else if (this.trace) {
            log.trace((Object)("No " + methodName + " for " + name));
        }
        return value;
    }

    Object provideAttributeValue(ObjectModelProvider provider, Object object, String namespaceUri, String name) {
        Class<?> providerClass = provider.getClass();
        Class<?> objectClass = object.getClass();
        String methodName = "getAttributeValue";
        Object value = null;
        Method method = DelegatingObjectModelProvider.getProviderMethod(providerClass, methodName, new Class[]{objectClass, String.class, String.class});
        if (method != null) {
            try {
                value = method.invoke((Object)provider, object, namespaceUri, name);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to invoke method " + methodName);
            }
        } else if (this.trace) {
            log.trace((Object)("No " + methodName + " for " + name));
        }
        return value;
    }

    private static Method getProviderMethod(Class providerClass, String methodName, Class[] args) {
        Method method = null;
        try {
            method = providerClass.getMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return method;
    }
}

