/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.txoj.recovery;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject;
import com.arjuna.ats.txoj.logging.txojLogger;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class TORecoveryModule
implements RecoveryModule {
    private Hashtable _uncommittedTOTable;
    private static ObjectStore _objectStore = null;

    public TORecoveryModule() {
        if (txojLogger.aitLoggerI18N.isDebugEnabled()) {
            txojLogger.aitLoggerI18N.debug("com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_1");
        }
        try {
            Class<?> osc = Class.forName(arjPropertyManager.getObjectStoreEnvironmentBean().getObjectStoreType());
            _objectStore = (ObjectStore)osc.newInstance();
        }
        catch (Throwable ex) {
            throw new FatalError(tsLogger.arjLoggerI18N.getString("com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_osproblem"), ex);
        }
    }

    @Override
    public void periodicWorkFirstPass() {
        block13: {
            if (txojLogger.aitLoggerI18N.isInfoEnabled()) {
                txojLogger.aitLoggerI18N.info("com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_3");
            }
            this._uncommittedTOTable = new Hashtable();
            try {
                InputObjectState types = new InputObjectState();
                if (!_objectStore.allTypes(types)) break block13;
                String theName = null;
                try {
                    boolean endOfList = false;
                    while (!endOfList) {
                        theName = types.unpackString();
                        if (theName.compareTo("") == 0) {
                            endOfList = true;
                            continue;
                        }
                        InputObjectState uids = new InputObjectState();
                        if (!_objectStore.allObjUids(theName, uids, 2)) continue;
                        Uid theUid = null;
                        try {
                            boolean endOfUids = false;
                            while (!endOfUids) {
                                theUid = UidHelper.unpackFrom(uids);
                                if (theUid.equals(Uid.nullUid())) {
                                    endOfUids = true;
                                    continue;
                                }
                                String newTypeString = new String(theName);
                                Uid newUid = new Uid(theUid);
                                this._uncommittedTOTable.put(newUid, newTypeString);
                                if (!txojLogger.aitLoggerI18N.isDebugEnabled()) continue;
                                txojLogger.aitLoggerI18N.debug("com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_4", new Object[]{newUid, newTypeString});
                            }
                        }
                        catch (Exception e) {
                        }
                    }
                }
                catch (IOException ex) {
                }
                catch (Exception e) {
                    if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
                        txojLogger.aitLoggerI18N.warn("com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_5", e);
                    }
                }
            }
            catch (Exception e) {
                if (!txojLogger.aitLoggerI18N.isWarnEnabled()) break block13;
                txojLogger.aitLoggerI18N.warn("com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_5", e);
            }
        }
    }

    @Override
    public void periodicWorkSecondPass() {
        if (txojLogger.aitLoggerI18N.isInfoEnabled()) {
            txojLogger.aitLoggerI18N.info("com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_6");
        }
        Enumeration uncommittedObjects = this._uncommittedTOTable.keys();
        while (uncommittedObjects.hasMoreElements()) {
            Uid objUid = (Uid)uncommittedObjects.nextElement();
            String objType = (String)this._uncommittedTOTable.get(objUid);
            try {
                if (_objectStore.currentState(objUid, objType) == 2) {
                    this.recoverObject(objUid, objType);
                    continue;
                }
                if (!txojLogger.aitLoggerI18N.isDebugEnabled()) continue;
                txojLogger.aitLoggerI18N.debug("com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_7", new Object[]{objUid, objType});
            }
            catch (ObjectStoreException ose) {
                if (!txojLogger.aitLoggerI18N.isDebugEnabled()) continue;
                txojLogger.aitLoggerI18N.debug("com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_8", new Object[]{objUid, objType});
            }
        }
    }

    protected void initialise() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug("TORecoveryModule.initialise()");
        }
    }

    private final void recoverObject(Uid objUid, String objType) {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug("TORecoveryModule.recoverObject(" + objUid + ", " + objType + ")");
        }
        RecoveredTransactionalObject recoveredTO = new RecoveredTransactionalObject(objUid, objType, _objectStore);
        recoveredTO.replayPhase2();
    }
}

