/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.txoj.recovery;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionStatus;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.Header;
import com.arjuna.ats.txoj.logging.txojLogger;

public class RecoveredTransactionalObject
extends StateManager {
    private Uid _ourUid;
    private Uid _owningTransactionUid;
    private Uid _originalProcessUid;
    private ObjectStore _objectStore;
    private String _type;
    private TransactionStatusConnectionManager _transactionStatusConnectionMgr;

    protected RecoveredTransactionalObject(Uid objectUid, String originalType, ObjectStore objectStore) {
        this._ourUid = objectUid;
        this._type = originalType;
        this._objectStore = objectStore;
        this._transactionStatusConnectionMgr = new TransactionStatusConnectionManager();
        if (txojLogger.aitLoggerI18N.isDebugEnabled()) {
            txojLogger.aitLoggerI18N.debug("com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_1", new Object[]{this._ourUid});
        }
    }

    protected final void replayPhase2() {
        if (this.findHoldingTransaction()) {
            if (txojLogger.aitLoggerI18N.isDebugEnabled()) {
                txojLogger.aitLoggerI18N.debug("com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_2", new Object[]{this._owningTransactionUid});
            }
            int tranStatus = this._transactionStatusConnectionMgr.getTransactionStatus(this._owningTransactionUid);
            if (txojLogger.aitLoggerI18N.isDebugEnabled()) {
                txojLogger.aitLoggerI18N.debug("com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_3", new Object[]{ActionStatus.stringForm(tranStatus)});
            }
            boolean inactive = false;
            if (tranStatus == 9) {
                if (txojLogger.aitLoggerI18N.isDebugEnabled()) {
                    if (inactive) {
                        txojLogger.aitLoggerI18N.debug("com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_4", new Object[]{Integer.toString(tranStatus), "true"});
                    } else {
                        txojLogger.aitLoggerI18N.debug("com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_4", new Object[]{Integer.toString(tranStatus), "false"});
                    }
                }
                inactive = true;
            }
            if (tranStatus == 4 || inactive) {
                this.rollback();
            } else {
                this.commit();
            }
        } else if (txojLogger.aitLoggerI18N.isDebugEnabled()) {
            txojLogger.aitLoggerI18N.debug("com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_5");
        }
    }

    private final boolean findHoldingTransaction() {
        InputObjectState uncommittedState = null;
        this._originalProcessUid = new Uid(Uid.nullUid());
        try {
            uncommittedState = this._objectStore.read_uncommitted(this._ourUid, this._type);
        }
        catch (ObjectStoreException e) {
            if (txojLogger.aitLoggerI18N.isDebugEnabled()) {
                txojLogger.aitLoggerI18N.debug("com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_6", new Object[]{e});
            }
            return false;
        }
        this._originalProcessUid = null;
        this._owningTransactionUid = null;
        try {
            Header hdr = new Header();
            this.unpackHeader(uncommittedState, hdr);
            this._originalProcessUid = hdr.getProcessId();
            this._owningTransactionUid = hdr.getTxId();
            if (txojLogger.aitLoggerI18N.isDebugEnabled()) {
                txojLogger.aitLoggerI18N.debug("com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_7", new Object[]{this._owningTransactionUid});
            }
            return this._owningTransactionUid.notEquals(Uid.nullUid());
        }
        catch (Exception e) {
            if (txojLogger.aitLoggerI18N.isDebugEnabled()) {
                txojLogger.aitLoggerI18N.debug("com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_8", new Object[]{e});
            }
            return false;
        }
    }

    private final void rollback() {
        block2: {
            try {
                this._objectStore.remove_uncommitted(this._ourUid, this._type);
            }
            catch (ObjectStoreException e) {
                if (!txojLogger.aitLoggerI18N.isWarnEnabled()) break block2;
                txojLogger.aitLoggerI18N.warn("com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_9", new Object[]{this._ourUid, e});
            }
        }
    }

    private final void commit() {
        block2: {
            try {
                this._objectStore.commit_state(this._ourUid, this._type);
            }
            catch (ObjectStoreException e) {
                if (!txojLogger.aitLoggerI18N.isWarnEnabled()) break block2;
                txojLogger.aitLoggerI18N.warn("com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_10", new Object[]{this._ourUid, e});
            }
        }
    }
}

