/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.internal.arjuna.objectstore.HashedStore;

public class HashedActionStore
extends HashedStore {
    private static boolean checkSync = false;

    @Override
    public int typeIs() {
        return 17;
    }

    public HashedActionStore() {
        this(13);
    }

    public HashedActionStore(int shareStatus) {
        super(shareStatus);
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("HashedStore.HashedActionStore( " + shareStatus + " )");
        }
        try {
            this.setupStore(arjPropertyManager.getObjectStoreEnvironmentBean().getLocalOSRoot());
        }
        catch (ObjectStoreException e) {
            throw new FatalError(e.toString(), e);
        }
    }

    public HashedActionStore(String locationOfStore) {
        this(locationOfStore, 13);
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("HashedStore.HashedActionStore(" + locationOfStore + ")");
        }
        try {
            this.setupStore(locationOfStore);
        }
        catch (ObjectStoreException e) {
            tsLogger.arjLogger.warn(e);
            throw new FatalError(e.toString(), e);
        }
    }

    public HashedActionStore(String locationOfStore, int shareStatus) {
        super(shareStatus);
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("HashedStore.HashedActionStore(" + locationOfStore + ")");
        }
        try {
            this.setupStore(locationOfStore);
        }
        catch (ObjectStoreException e) {
            tsLogger.arjLogger.warn(e);
            throw new FatalError(e.toString(), e);
        }
    }

    @Override
    protected synchronized boolean setupStore(String location) throws ObjectStoreException {
        if (!checkSync) {
            if (arjPropertyManager.getObjectStoreEnvironmentBean().isTransactionSync()) {
                this.syncOn();
            } else {
                this.syncOff();
            }
        }
        checkSync = true;
        return super.setupStore(location);
    }
}

