/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.arjuna.utils.FileLock;
import com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore;
import java.io.File;

public abstract class FileLockingStore
extends FileSystemStore {
    @Override
    protected abstract InputObjectState read_state(Uid var1, String var2, int var3) throws ObjectStoreException;

    @Override
    protected abstract boolean remove_state(Uid var1, String var2, int var3) throws ObjectStoreException;

    @Override
    protected abstract boolean write_state(Uid var1, String var2, OutputObjectState var3, int var4) throws ObjectStoreException;

    public FileLockingStore(String locationOfStore, int ss) {
        super(locationOfStore, ss);
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("FileLockingStore.FileLockingStore(" + locationOfStore + ")");
        }
    }

    @Override
    protected synchronized boolean lock(File fd, int lmode, boolean create) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("FileLockingStore.lock(" + fd + ", " + FileLock.modeString(lmode) + ", " + create + ")");
        }
        FileLock fileLock = new FileLock(fd);
        return fileLock.lock(lmode, create);
    }

    @Override
    protected synchronized boolean unlock(File fd) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("FileLockingStore.unlock(" + fd + ")");
        }
        FileLock fileLock = new FileLock(fd);
        return fileLock.unlock();
    }
}

