/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.common;

import com.arjuna.ats.arjuna.logging.tsLogger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ClassloadingUtility {
    private static final char BREAKCHARACTER = ';';

    public static <T> T loadAndInstantiateClass(Class<T> iface, String className) {
        Class<?> clazz;
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("Loading class " + className);
        }
        if (className == null) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.common.ClassloadingUtility_1");
            return null;
        }
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.common.ClassloadingUtility_2", new Object[]{className}, e);
            return null;
        }
        T instance = null;
        try {
            Class<T> clazz2 = clazz.asSubclass(iface);
            instance = clazz2.newInstance();
        }
        catch (ClassCastException e) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.common.ClassloadingUtility_3", new Object[]{className, iface.getName()}, e);
        }
        catch (InstantiationException e) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.common.ClassloadingUtility_4", new Object[]{className}, e);
        }
        catch (IllegalAccessException e) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.common.ClassloadingUtility_5", new Object[]{className}, e);
        }
        return instance;
    }

    public static <T> List<T> loadAndInstantiateClassesWithInit(Class<T> iface, List<String> classNamesWithOptionalInitParams) {
        ArrayList<T> instances = new ArrayList<T>();
        for (String theClassAndParameter : classNamesWithOptionalInitParams) {
            int breakPosition = theClassAndParameter.indexOf(59);
            String theClass = null;
            String theParameter = null;
            if (breakPosition != -1) {
                theClass = theClassAndParameter.substring(0, breakPosition);
                theParameter = theClassAndParameter.substring(breakPosition + 1);
            } else {
                theClass = theClassAndParameter;
            }
            T instance = ClassloadingUtility.loadAndInstantiateClass(iface, theClass);
            if (theClass != null && theParameter != null) {
                try {
                    Method method = instance.getClass().getMethod("initialise", String.class);
                    method.invoke(instance, theParameter);
                }
                catch (Exception e) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.common.ClassloadingUtility_6", new Object[]{theClassAndParameter}, e);
                    continue;
                }
            }
            if (instance == null) continue;
            instances.add(instance);
        }
        return instances;
    }

    public static String getNameForClass(Object instance) {
        if (instance == null) {
            return null;
        }
        return instance.getClass().getName();
    }

    public static List<String> getNamesForClasses(List<? extends Object> instances) {
        ArrayList<String> names = new ArrayList<String>();
        if (instances != null) {
            for (Object object : instances) {
                String name = ClassloadingUtility.getNameForClass(object);
                if (name == null) continue;
                names.add(name);
            }
        }
        return names;
    }
}

