/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.keygen;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.EJBException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCIdentityColumnCreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.keygen.GetTCLAction;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;

public class JDBCInformixCreateCommand
extends JDBCIdentityColumnCreateCommand {
    private static final String NAME = "class-name";
    private static final String DEFAULT_CLASS = "com.informix.jdbc.IfxStatement";
    private static final String METHOD = "method";
    private static final String DEFAULT_METHOD = "getSerial";
    private String className;
    private String methodName;
    private Method method;
    private Method getUnderlyingStatement;

    public void init(JDBCStoreManager manager) throws DeploymentException {
        super.init(manager);
        ClassLoader loader = GetTCLAction.getContextClassLoader();
        try {
            Class<?> psClass = loader.loadClass(this.className);
            this.method = psClass.getMethod(this.methodName, null);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load driver class: " + this.className, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new DeploymentException("Driver does not have method: " + this.methodName + "()");
        }
        try {
            Class<?> wrapperClass = loader.loadClass("org.jboss.resource.adapter.jdbc.StatementAccess");
            this.getUnderlyingStatement = wrapperClass.getMethod("getUnderlyingStatement", null);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load org.jboss.resource.adapter.jdbc.StatementAccess", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new DeploymentException("StatementAccess.getUnderlyingStatement not found", (Throwable)e);
        }
    }

    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException {
        super.initEntityCommand(entityCommand);
        this.className = entityCommand.getAttribute(NAME);
        if (this.className == null) {
            this.className = DEFAULT_CLASS;
        }
        this.methodName = entityCommand.getAttribute(METHOD);
        if (this.methodName == null) {
            this.methodName = DEFAULT_METHOD;
        }
    }

    protected int executeInsert(int paramIndex, PreparedStatement ps, EntityEnterpriseContext ctx) throws SQLException {
        int rows = ps.executeUpdate();
        Statement stmt = ps;
        do {
            try {
                Object[] args = new Object[]{};
                stmt = (Statement)this.getUnderlyingStatement.invoke((Object)stmt, args);
            }
            catch (IllegalAccessException e) {
                SQLException ex = new SQLException("Failed to invoke getUnderlyingStatement");
                ex.initCause(e);
                throw ex;
            }
            catch (InvocationTargetException e) {
                SQLException ex = new SQLException("Failed to invoke getUnderlyingStatement");
                ex.initCause(e);
                throw ex;
            }
        } while (stmt != null && !this.method.getDeclaringClass().isInstance(stmt));
        try {
            Number pk = (Number)this.method.invoke((Object)stmt, null);
            this.pkField.setInstanceValue(ctx, pk);
            return rows;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Error extracting generated keys", e);
        }
    }
}

