/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.standard;

import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import junit.framework.TestCase;
import org.jboss.test.jmx.compliance.standard.support.Trivial;

public class TrivialTEST
extends TestCase {
    public TrivialTEST(String s) {
        super(s);
    }

    public void testRegistration() {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        Trivial trivial = new Trivial();
        ObjectName name = null;
        try {
            name = new ObjectName("trivial:key=val");
            server.registerMBean(trivial, name);
        }
        catch (Exception e) {
            TrivialTEST.fail((String)("registration failed: " + e.getMessage()));
        }
        TrivialTEST.assertTrue((String)"expected server to report it as registered", (boolean)server.isRegistered(name));
    }

    public void testConstructorInfo() {
        MBeanInfo info = this.getTrivialInfo();
        MBeanConstructorInfo[] constructors = info.getConstructors();
        TrivialTEST.assertEquals((String)"constructor list length", (int)1, (int)constructors.length);
        TrivialTEST.assertEquals((String)"constructor name", (String)Trivial.class.getName(), (String)constructors[0].getName());
        MBeanParameterInfo[] params = constructors[0].getSignature();
        TrivialTEST.assertEquals((String)"constructor signature length", (int)0, (int)params.length);
    }

    public void testAttributeInfo() {
        MBeanInfo info = this.getTrivialInfo();
        MBeanAttributeInfo[] attributes = info.getAttributes();
        TrivialTEST.assertEquals((String)"attribute list length", (int)1, (int)attributes.length);
        TrivialTEST.assertEquals((String)"attribute name", (String)"Something", (String)attributes[0].getName());
        TrivialTEST.assertEquals((String)"attribute type", (String)String.class.getName(), (String)attributes[0].getType());
        TrivialTEST.assertEquals((String)"attribute readable", (boolean)true, (boolean)attributes[0].isReadable());
        TrivialTEST.assertEquals((String)"attribute writable", (boolean)true, (boolean)attributes[0].isWritable());
        TrivialTEST.assertEquals((String)"attribute isIs", (boolean)false, (boolean)attributes[0].isIs());
    }

    public void testOperationInfo() {
        MBeanInfo info = this.getTrivialInfo();
        MBeanOperationInfo[] operations = info.getOperations();
        TrivialTEST.assertEquals((String)"operations list length", (int)1, (int)operations.length);
        TrivialTEST.assertEquals((String)"operation name", (String)"doOperation", (String)operations[0].getName());
        TrivialTEST.assertEquals((String)"operation return type", (String)Void.TYPE.getName(), (String)operations[0].getReturnType());
        TrivialTEST.assertEquals((String)"operation impact", (int)3, (int)operations[0].getImpact());
        MBeanParameterInfo[] params = operations[0].getSignature();
        TrivialTEST.assertEquals((String)"signature length", (int)1, (int)params.length);
        TrivialTEST.assertEquals((String)"parameter type", (String)String.class.getName(), (String)params[0].getType());
    }

    public void testNotificationInfo() {
        MBeanInfo info = this.getTrivialInfo();
        MBeanNotificationInfo[] notifications = info.getNotifications();
        TrivialTEST.assertEquals((String)"notification list length", (int)0, (int)notifications.length);
    }

    private MBeanInfo getTrivialInfo() {
        MBeanInfo info = null;
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            Trivial trivial = new Trivial();
            ObjectName name = new ObjectName("trivial:key=val");
            server.registerMBean(trivial, name);
            info = server.getMBeanInfo(name);
        }
        catch (MalformedObjectNameException e) {
            TrivialTEST.fail((String)"got spurious MalformedObjectNameException");
        }
        catch (InstanceAlreadyExistsException e) {
            TrivialTEST.fail((String)"got spurious InstanceAlreadyExistsException");
        }
        catch (MBeanRegistrationException e) {
            TrivialTEST.fail((String)"got spurious MBeanRegistrationException");
        }
        catch (NotCompliantMBeanException e) {
            TrivialTEST.fail((String)"got spurious NotCompliantMBeanException");
        }
        catch (InstanceNotFoundException e) {
            TrivialTEST.fail((String)"got spurious InstanceNotFoundException");
        }
        catch (IntrospectionException e) {
            TrivialTEST.fail((String)"got spurious IntrospectionException");
        }
        catch (ReflectionException e) {
            TrivialTEST.fail((String)"got spurious ReflectionException");
        }
        return info;
    }
}

