/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.openmbean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.InvalidOpenTypeException;
import javax.management.openmbean.KeyAlreadyExistsException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import junit.framework.TestCase;

public class TabularDataSupportTestCase
extends TestCase {
    public TabularDataSupportTestCase(String s) {
        super(s);
    }

    public void testTabularDataSupport() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        new TabularDataSupport(tabularType);
        new TabularDataSupport(tabularType, 100, 0.5f);
    }

    public void testGetTabularType() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        TabularDataSupportTestCase.assertTrue((String)"Expected the same tabular type", (boolean)data.getTabularType().equals(tabularType));
    }

    public void testCalculateIndex() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        Object[] index = data.calculateIndex(compData);
        TabularDataSupportTestCase.assertTrue((String)"Expected index element 0 to be value1", (boolean)index[0].equals("value1"));
        TabularDataSupportTestCase.assertTrue((String)"Expected index element 1 to be 2", (boolean)index[1].equals(new Integer(2)));
        map = new HashMap();
        map.put("name1", "value2");
        map.put("name2", new Integer(3));
        compData = new CompositeDataSupport(rowType, map);
        index = data.calculateIndex(compData);
        TabularDataSupportTestCase.assertTrue((String)"Expected index element 0 to be value2", (boolean)index[0].equals("value2"));
        TabularDataSupportTestCase.assertTrue((String)"Expected index element 1 to be 3", (boolean)index[1].equals(new Integer(3)));
    }

    public void testContainsKeyObject() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsKey null", (!data.containsKey(null) ? 1 : 0) != 0);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsKey not an Object array", (!data.containsKey(new Object()) ? 1 : 0) != 0);
        Object[] index = new Object[]{"value1", new Integer(2)};
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsKey on empty data", (!data.containsKey((Object)index) ? 1 : 0) != 0);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(3));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsKey on index not present", (!data.containsKey((Object)index) ? 1 : 0) != 0);
        map = new HashMap();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        compData = new CompositeDataSupport(rowType, map);
        data.put(compData);
        TabularDataSupportTestCase.assertTrue((String)"Expected containsKey", (boolean)data.containsKey((Object)index));
        map = new HashMap();
        map.put("name1", "value1");
        map.put("name2", new Integer(3));
        compData = new CompositeDataSupport(rowType, map);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsKey on index still not present", (!data.containsKey((Object)data.calculateIndex(compData)) ? 1 : 0) != 0);
        data.remove(index);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect removed data in containsKey", (!data.containsKey((Object)index) ? 1 : 0) != 0);
    }

    public void testContainsKeyObjectArray() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsKey null", (!data.containsKey(null) ? 1 : 0) != 0);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsKey not an Object array", (!data.containsKey(new Object()) ? 1 : 0) != 0);
        Object[] index = new Object[]{"value1", new Integer(2)};
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsKey on empty data", (!data.containsKey(index) ? 1 : 0) != 0);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(3));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsKey on index not present", (!data.containsKey(index) ? 1 : 0) != 0);
        map = new HashMap();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        compData = new CompositeDataSupport(rowType, map);
        data.put(compData);
        TabularDataSupportTestCase.assertTrue((String)"Expected containsKey", (boolean)data.containsKey(index));
        map = new HashMap();
        map.put("name1", "value1");
        map.put("name2", new Integer(3));
        compData = new CompositeDataSupport(rowType, map);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsKey on index still not present", (!data.containsKey(data.calculateIndex(compData)) ? 1 : 0) != 0);
        data.remove(index);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect removed data in containsKey", (!data.containsKey(index) ? 1 : 0) != 0);
    }

    public void testContainsValueObject() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsValue null", (!data.containsValue(null) ? 1 : 0) != 0);
        itemNames = new String[]{"name1", "name2"};
        itemDescriptions = new String[]{"desc1", "desc2"};
        itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType2 = new CompositeType("rowTypeName2", "rowDescription", itemNames, itemDescriptions, itemTypes);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData2 = new CompositeDataSupport(rowType2, map);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsValue wrong composite type", (!data.containsValue((Object)compData2) ? 1 : 0) != 0);
        map = new HashMap();
        map.put("name1", "value1");
        map.put("name2", new Integer(3));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsValue on data not present", (!data.containsValue((Object)compData) ? 1 : 0) != 0);
        map = new HashMap();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        compData = new CompositeDataSupport(rowType, map);
        data.put(compData);
        TabularDataSupportTestCase.assertTrue((String)"Expected containsValue", (boolean)data.containsValue((Object)compData));
        map = new HashMap();
        map.put("name1", "value1");
        map.put("name2", new Integer(3));
        compData = new CompositeDataSupport(rowType, map);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsValue on value still not present", (!data.containsValue((Object)compData) ? 1 : 0) != 0);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsValue still wrong composite type", (!data.containsValue((Object)compData2) ? 1 : 0) != 0);
        data.remove(data.calculateIndex(compData));
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect removed data in containsValue", (!data.containsValue((Object)compData) ? 1 : 0) != 0);
    }

    public void testContainsValueCompositeData() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsValue null", (!data.containsValue(null) ? 1 : 0) != 0);
        itemNames = new String[]{"name1", "name2"};
        itemDescriptions = new String[]{"desc1", "desc2"};
        itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType2 = new CompositeType("rowTypeName2", "rowDescription", itemNames, itemDescriptions, itemTypes);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData2 = new CompositeDataSupport(rowType2, map);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsValue wrong composite type", (!data.containsValue(compData2) ? 1 : 0) != 0);
        map = new HashMap();
        map.put("name1", "value1");
        map.put("name2", new Integer(3));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsValue on data not present", (!data.containsValue(compData) ? 1 : 0) != 0);
        map = new HashMap();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        compData = new CompositeDataSupport(rowType, map);
        data.put(compData);
        TabularDataSupportTestCase.assertTrue((String)"Expected containsValue", (boolean)data.containsValue(compData));
        map = new HashMap();
        map.put("name1", "value1");
        map.put("name2", new Integer(3));
        compData = new CompositeDataSupport(rowType, map);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsValue on value still not present", (!data.containsValue(compData) ? 1 : 0) != 0);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect containsValue still wrong composite type", (!data.containsValue(compData2) ? 1 : 0) != 0);
        data.remove(data.calculateIndex(compData));
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect removed data in containsValue", (!data.containsValue(compData) ? 1 : 0) != 0);
    }

    public void testGetObject() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        Object[] index = new Object[]{"value1", new Integer(3)};
        TabularDataSupportTestCase.assertTrue((String)"Expected null for get on data not present", (data.get((Object)index) == null ? 1 : 0) != 0);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        index = new Object[]{"value1", new Integer(2)};
        data.put(compData);
        TabularDataSupportTestCase.assertTrue((String)"Expected get to return the same value", (boolean)data.get((Object)index).equals(compData));
        index = new Object[]{"value1", new Integer(3)};
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect get on value still not present", (data.get((Object)index) == null ? 1 : 0) != 0);
        index = new Object[]{"value1", new Integer(2)};
        data.remove(index);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect removed data in get", (data.get((Object)index) == null ? 1 : 0) != 0);
    }

    public void testGetObjectArray() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        Object[] index = new Object[]{"value1", new Integer(3)};
        TabularDataSupportTestCase.assertTrue((String)"Expected null for get on data not present", (data.get(index) == null ? 1 : 0) != 0);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        index = new Object[]{"value1", new Integer(2)};
        data.put(compData);
        TabularDataSupportTestCase.assertTrue((String)"Expected get to return the same value", (boolean)((Object)data.get(index)).equals(compData));
        index = new Object[]{"value1", new Integer(3)};
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect get on value still not present", (data.get(index) == null ? 1 : 0) != 0);
        index = new Object[]{"value1", new Integer(2)};
        data.remove(index);
        TabularDataSupportTestCase.assertTrue((String)"Didn't expect removed data in get", (data.get(index) == null ? 1 : 0) != 0);
    }

    public void testPutObjectObject() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        Object[] index = new Object[]{"value1", new Integer(2)};
        data.put(index, compData);
        TabularDataSupportTestCase.assertTrue((String)"The data should be present after put", (boolean)((Object)data.get(index)).equals(compData));
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("name1", "value1");
        map2.put("name2", new Integer(3));
        CompositeDataSupport compData2 = new CompositeDataSupport(rowType, map2);
        index = new Object[]{"value1", new Integer(3)};
        data.put(index, compData2);
        TabularDataSupportTestCase.assertTrue((String)"Another data should be present after put", (boolean)((Object)data.get(index)).equals(compData2));
        index = new Object[]{"value1", new Integer(2)};
        TabularDataSupportTestCase.assertTrue((String)"The previous data should be present after put", (boolean)((Object)data.get(index)).equals(compData));
        data.remove(index);
        data.put(index, compData);
        TabularDataSupportTestCase.assertTrue((String)"Data should be present after remove/put", (boolean)((Object)data.get(index)).equals(compData));
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("name1", "value1");
        map3.put("name2", new Integer(4));
        CompositeDataSupport compData3 = new CompositeDataSupport(rowType, map3);
        index = new Object[]{"value1", new Integer(4)};
        data.put(new Object(), compData3);
        TabularDataSupportTestCase.assertTrue((String)"The key should be ignored in put", (boolean)((Object)data.get(index)).equals(compData3));
    }

    public void testPutCompositeData() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        Object[] index = new Object[]{"value1", new Integer(2)};
        data.put(compData);
        TabularDataSupportTestCase.assertTrue((String)"The data should be present after put", (boolean)((Object)data.get(index)).equals(compData));
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("name1", "value1");
        map2.put("name2", new Integer(3));
        CompositeDataSupport compData2 = new CompositeDataSupport(rowType, map2);
        index = new Object[]{"value1", new Integer(3)};
        data.put(compData2);
        TabularDataSupportTestCase.assertTrue((String)"Another data should be present after put", (boolean)((Object)data.get(index)).equals(compData2));
        index = new Object[]{"value1", new Integer(2)};
        TabularDataSupportTestCase.assertTrue((String)"The previous data should be present after put", (boolean)((Object)data.get(index)).equals(compData));
        data.remove(index);
        data.put(compData);
        TabularDataSupportTestCase.assertTrue((String)"Data should be present after remove/put", (boolean)((Object)data.get(index)).equals(compData));
    }

    public void testRemoveObject() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        Object[] index = new Object[]{"value1", new Integer(2)};
        TabularDataSupportTestCase.assertTrue((String)"Remove on data not present returns null", (data.remove((Object)index) == null ? 1 : 0) != 0);
        data.put(compData);
        TabularDataSupportTestCase.assertTrue((String)"Remove on data present returns the data", (boolean)data.remove((Object)index).equals(compData));
    }

    public void testRemoveObjectArray() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        Object[] index = new Object[]{"value1", new Integer(2)};
        TabularDataSupportTestCase.assertTrue((String)"Remove on data not present returns null", (data.remove(index) == null ? 1 : 0) != 0);
        data.put(compData);
        TabularDataSupportTestCase.assertTrue((String)"Remove on data present returns the data", (boolean)((Object)data.remove(index)).equals(compData));
    }

    public void testPutAllMap() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        data.putAll((Map<?, ?>)null);
        TabularDataSupportTestCase.assertTrue((String)"Put all null is ok", (boolean)data.isEmpty());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        HashMap<Object, CompositeDataSupport> toPut = new HashMap<Object, CompositeDataSupport>();
        toPut.put(new Object(), compData);
        data.putAll((Map<?, ?>)toPut);
        TabularDataSupportTestCase.assertTrue((String)"Put all added one", (data.size() == 1 ? 1 : 0) != 0);
        TabularDataSupportTestCase.assertTrue((String)"Put all added the correct data", (boolean)data.containsValue(compData));
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("name1", "value1");
        map2.put("name2", new Integer(3));
        CompositeDataSupport compData2 = new CompositeDataSupport(rowType, map2);
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("name1", "value1");
        map3.put("name2", new Integer(4));
        CompositeDataSupport compData3 = new CompositeDataSupport(rowType, map3);
        toPut = new HashMap();
        toPut.put(new Object(), compData2);
        toPut.put(new Object(), compData3);
        data.putAll((Map<?, ?>)toPut);
        TabularDataSupportTestCase.assertTrue((String)"Put all added two", (data.size() == 3 ? 1 : 0) != 0);
        TabularDataSupportTestCase.assertTrue((String)"Put all added the correct data", (boolean)data.containsValue(compData2));
        TabularDataSupportTestCase.assertTrue((String)"Put all added the correct data", (boolean)data.containsValue(compData3));
        TabularDataSupportTestCase.assertTrue((String)"Put all original data still present", (boolean)data.containsValue(compData));
    }

    public void testPutAllCompositeData() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        data.putAll((CompositeData[])null);
        TabularDataSupportTestCase.assertTrue((String)"Put all null is ok", (boolean)data.isEmpty());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        CompositeData[] toPut = new CompositeData[]{compData};
        data.putAll(toPut);
        TabularDataSupportTestCase.assertTrue((String)"Put all added one", (data.size() == 1 ? 1 : 0) != 0);
        TabularDataSupportTestCase.assertTrue((String)"Put all added the correct data", (boolean)data.containsValue(compData));
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("name1", "value1");
        map2.put("name2", new Integer(3));
        CompositeDataSupport compData2 = new CompositeDataSupport(rowType, map2);
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("name1", "value1");
        map3.put("name2", new Integer(4));
        CompositeDataSupport compData3 = new CompositeDataSupport(rowType, map3);
        toPut = new CompositeData[]{compData2, compData3};
        data.putAll(toPut);
        TabularDataSupportTestCase.assertTrue((String)"Put all added two", (data.size() == 3 ? 1 : 0) != 0);
        TabularDataSupportTestCase.assertTrue((String)"Put all added the correct data", (boolean)data.containsValue(compData2));
        TabularDataSupportTestCase.assertTrue((String)"Put all added the correct data", (boolean)data.containsValue(compData3));
        TabularDataSupportTestCase.assertTrue((String)"Put all original data still present", (boolean)data.containsValue(compData));
    }

    public void testClear() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        data.putAll((CompositeData[])null);
        TabularDataSupportTestCase.assertTrue((String)"Put all null is ok", (boolean)data.isEmpty());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("name1", "value1");
        map2.put("name2", new Integer(3));
        CompositeDataSupport compData2 = new CompositeDataSupport(rowType, map2);
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("name1", "value1");
        map3.put("name2", new Integer(4));
        CompositeDataSupport compData3 = new CompositeDataSupport(rowType, map3);
        HashMap<Object, CompositeDataSupport> toPut = new HashMap<Object, CompositeDataSupport>();
        toPut.put(new Object(), compData);
        toPut.put(new Object(), compData2);
        toPut.put(new Object(), compData3);
        data.putAll((Map<?, ?>)toPut);
        data.clear();
        TabularDataSupportTestCase.assertTrue((String)"Clear should clear the data", (boolean)data.isEmpty());
    }

    public void testSize() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        TabularDataSupportTestCase.assertTrue((String)"Initial size is zero", (data.size() == 0 ? 1 : 0) != 0);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        CompositeData[] toPut = new CompositeData[]{compData};
        data.putAll(toPut);
        TabularDataSupportTestCase.assertTrue((String)"Expected one element", (data.size() == 1 ? 1 : 0) != 0);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("name1", "value1");
        map2.put("name2", new Integer(3));
        CompositeDataSupport compData2 = new CompositeDataSupport(rowType, map2);
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("name1", "value1");
        map3.put("name2", new Integer(4));
        CompositeDataSupport compData3 = new CompositeDataSupport(rowType, map3);
        toPut = new CompositeData[]{compData2, compData3};
        data.putAll(toPut);
        TabularDataSupportTestCase.assertTrue((String)"Expected three elements", (data.size() == 3 ? 1 : 0) != 0);
        data.remove(new Object[]{"value1", new Integer(4)});
        TabularDataSupportTestCase.assertTrue((String)"Expected two elements", (data.size() == 2 ? 1 : 0) != 0);
        data.clear();
        TabularDataSupportTestCase.assertTrue((String)"Expected no elements", (data.size() == 0 ? 1 : 0) != 0);
    }

    public void testIsEmpty() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        TabularDataSupportTestCase.assertTrue((String)"Initially empty", (boolean)data.isEmpty());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        CompositeData[] toPut = new CompositeData[]{compData};
        data.putAll(toPut);
        TabularDataSupportTestCase.assertTrue((String)"Not empty after a put", (!data.isEmpty() ? 1 : 0) != 0);
        data.clear();
        TabularDataSupportTestCase.assertTrue((String)"Expected no elements", (boolean)data.isEmpty());
    }

    public void testKeySet() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        data.putAll((CompositeData[])null);
        TabularDataSupportTestCase.assertTrue((String)"Put all null is ok", (boolean)data.isEmpty());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("name1", "value1");
        map2.put("name2", new Integer(3));
        CompositeDataSupport compData2 = new CompositeDataSupport(rowType, map2);
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("name1", "value1");
        map3.put("name2", new Integer(4));
        CompositeDataSupport compData3 = new CompositeDataSupport(rowType, map3);
        HashMap<Object, CompositeDataSupport> toPut = new HashMap<Object, CompositeDataSupport>();
        toPut.put(new Object(), compData);
        toPut.put(new Object(), compData2);
        toPut.put(new Object(), compData3);
        data.putAll((Map<?, ?>)toPut);
        Set<Object> keySet = data.keySet();
        TabularDataSupportTestCase.assertTrue((String)"Key set should contain 3 elements", (keySet.size() == 3 ? 1 : 0) != 0);
        TabularDataSupportTestCase.assertTrue((String)"Key set should contain index [value1, 2]", (boolean)keySet.contains(Arrays.asList("value1", new Integer(2))));
        TabularDataSupportTestCase.assertTrue((String)"Key set should contain index [value1, 3]", (boolean)keySet.contains(Arrays.asList("value1", new Integer(3))));
        TabularDataSupportTestCase.assertTrue((String)"Key set should contain index [value1, 4]", (boolean)keySet.contains(Arrays.asList("value1", new Integer(4))));
    }

    public void testValues() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        data.putAll((CompositeData[])null);
        TabularDataSupportTestCase.assertTrue((String)"Put all null is ok", (boolean)data.isEmpty());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("name1", "value1");
        map2.put("name2", new Integer(3));
        CompositeDataSupport compData2 = new CompositeDataSupport(rowType, map2);
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("name1", "value1");
        map3.put("name2", new Integer(4));
        CompositeDataSupport compData3 = new CompositeDataSupport(rowType, map3);
        HashMap<Object, CompositeDataSupport> toPut = new HashMap<Object, CompositeDataSupport>();
        toPut.put(new Object(), compData);
        toPut.put(new Object(), compData2);
        toPut.put(new Object(), compData3);
        data.putAll((Map<?, ?>)toPut);
        Collection<Object> values = data.values();
        TabularDataSupportTestCase.assertTrue((String)"Values should contain 3 elements", (values.size() == 3 ? 1 : 0) != 0);
        TabularDataSupportTestCase.assertTrue((String)"Values should contain index compData", (boolean)values.contains(compData));
        TabularDataSupportTestCase.assertTrue((String)"Values should contain index compData2", (boolean)values.contains(compData2));
        TabularDataSupportTestCase.assertTrue((String)"Values should contain index compData3", (boolean)values.contains(compData3));
    }

    public void testEntrySet() throws Exception {
    }

    public void testClone() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        data.putAll((CompositeData[])null);
        TabularDataSupportTestCase.assertTrue((String)"Put all null is ok", (boolean)data.isEmpty());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("name1", "value1");
        map2.put("name2", new Integer(3));
        CompositeDataSupport compData2 = new CompositeDataSupport(rowType, map2);
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("name1", "value1");
        map3.put("name2", new Integer(4));
        CompositeDataSupport compData3 = new CompositeDataSupport(rowType, map3);
        HashMap<Object, CompositeDataSupport> toPut = new HashMap<Object, CompositeDataSupport>();
        toPut.put(new Object(), compData);
        toPut.put(new Object(), compData2);
        toPut.put(new Object(), compData3);
        data.putAll((Map<?, ?>)toPut);
        TabularDataSupport clone = (TabularDataSupport)data.clone();
        TabularDataSupportTestCase.assertTrue((String)"Clone should have the same tabular type", (boolean)data.getTabularType().equals(clone.getTabularType()));
        TabularDataSupportTestCase.assertTrue((String)"Clone should have the same number of elements", (data.size() == clone.size() ? 1 : 0) != 0);
        CompositeData compDataClone = clone.get(new Object[]{"value1", new Integer(2)});
        TabularDataSupportTestCase.assertTrue((String)"Should be a shallow clone", (compData == compDataClone ? 1 : 0) != 0);
    }

    public void testEquals() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        TabularDataSupportTestCase.assertTrue((String)"Null should not be equal", (!data.equals(null) ? 1 : 0) != 0);
        TabularDataSupportTestCase.assertTrue((String)"Only TabularData should be equal", (!data.equals(new Object()) ? 1 : 0) != 0);
        TabularDataSupportTestCase.assertTrue((String)"An instance should equal itself", (boolean)data.equals(data));
        TabularDataSupport data2 = new TabularDataSupport(tabularType);
        TabularDataSupportTestCase.assertTrue((String)"Two different instances with the same tabular type are equal", (boolean)data.equals(data2));
        TabularDataSupportTestCase.assertTrue((String)"Two different instances with the same tabular type are equal", (boolean)data2.equals(data));
        TabularType tabularType2 = new TabularType("typeName2", "description", rowType, indexNames);
        data2 = new TabularDataSupport(tabularType2);
        TabularDataSupportTestCase.assertTrue((String)"Instances with different tabular type are not equal", (!data.equals(data2) ? 1 : 0) != 0);
        TabularDataSupportTestCase.assertTrue((String)"Instances with different tabular type are not equal", (!data2.equals(data) ? 1 : 0) != 0);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("name1", "value1");
        map2.put("name2", new Integer(3));
        CompositeDataSupport compData2 = new CompositeDataSupport(rowType, map2);
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("name1", "value1");
        map3.put("name2", new Integer(4));
        CompositeDataSupport compData3 = new CompositeDataSupport(rowType, map3);
        HashMap<Object, CompositeDataSupport> toPut = new HashMap<Object, CompositeDataSupport>();
        toPut.put(new Object(), compData);
        toPut.put(new Object(), compData2);
        toPut.put(new Object(), compData3);
        data.putAll((Map<?, ?>)toPut);
        data2 = new TabularDataSupport(tabularType);
        data2.putAll((Map<?, ?>)toPut);
        TabularDataSupportTestCase.assertTrue((String)"Instances with the same composite data are equal", (boolean)data.equals(data2));
        TabularDataSupportTestCase.assertTrue((String)"Instances with the same composite data are equal", (boolean)data2.equals(data));
        toPut = new HashMap();
        toPut.put(new Object(), compData);
        toPut.put(new Object(), compData2);
        data2 = new TabularDataSupport(tabularType);
        data2.putAll((Map<?, ?>)toPut);
        TabularDataSupportTestCase.assertTrue((String)"Instances with different composite data are not equal", (!data.equals(data2) ? 1 : 0) != 0);
        TabularDataSupportTestCase.assertTrue((String)"Instances with different composite data are not equal", (!data2.equals(data) ? 1 : 0) != 0);
    }

    public void testHashCode() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        data.putAll((CompositeData[])null);
        TabularDataSupportTestCase.assertTrue((String)"Put all null is ok", (boolean)data.isEmpty());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("name1", "value1");
        map2.put("name2", new Integer(3));
        CompositeDataSupport compData2 = new CompositeDataSupport(rowType, map2);
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("name1", "value1");
        map3.put("name2", new Integer(4));
        CompositeDataSupport compData3 = new CompositeDataSupport(rowType, map3);
        HashMap<Object, CompositeDataSupport> toPut = new HashMap<Object, CompositeDataSupport>();
        toPut.put(new Object(), compData);
        toPut.put(new Object(), compData2);
        toPut.put(new Object(), compData3);
        data.putAll((Map<?, ?>)toPut);
        int myHashCode = tabularType.hashCode() + compData.hashCode() + compData2.hashCode() + compData3.hashCode();
        TabularDataSupportTestCase.assertTrue((String)"Wrong hash code generated", (myHashCode == data.hashCode() ? 1 : 0) != 0);
    }

    public void testToString() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        data.putAll((CompositeData[])null);
        TabularDataSupportTestCase.assertTrue((String)"Put all null is ok", (boolean)data.isEmpty());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("name1", "value1");
        map2.put("name2", new Integer(3));
        CompositeDataSupport compData2 = new CompositeDataSupport(rowType, map2);
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("name1", "value1");
        map3.put("name2", new Integer(4));
        CompositeDataSupport compData3 = new CompositeDataSupport(rowType, map3);
        HashMap<Object, CompositeDataSupport> toPut = new HashMap<Object, CompositeDataSupport>();
        toPut.put(new Object(), compData);
        toPut.put(new Object(), compData2);
        toPut.put(new Object(), compData3);
        data.putAll((Map<?, ?>)toPut);
        String toString = data.toString();
        TabularDataSupportTestCase.assertTrue((String)"toString() should contain the tabular type", (toString.indexOf(tabularType.toString()) != -1 ? 1 : 0) != 0);
        TabularDataSupportTestCase.assertTrue((String)"toString() should contain index=compositeData for compData", (toString.indexOf(Arrays.asList(data.calculateIndex(compData)) + "=" + compData) != -1 ? 1 : 0) != 0);
        TabularDataSupportTestCase.assertTrue((String)"toString() should contain index=compositeData for compData2", (toString.indexOf(Arrays.asList(data.calculateIndex(compData2)) + "=" + compData2) != -1 ? 1 : 0) != 0);
        TabularDataSupportTestCase.assertTrue((String)"toString() should contain index=compositeData for compData3", (toString.indexOf(Arrays.asList(data.calculateIndex(compData3)) + "=" + compData3) != -1 ? 1 : 0) != 0);
    }

    public void testSerialization() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        data.putAll((CompositeData[])null);
        TabularDataSupportTestCase.assertTrue((String)"Put all null is ok", (boolean)data.isEmpty());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("name1", "value1");
        map2.put("name2", new Integer(3));
        CompositeDataSupport compData2 = new CompositeDataSupport(rowType, map2);
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("name1", "value1");
        map3.put("name2", new Integer(4));
        CompositeDataSupport compData3 = new CompositeDataSupport(rowType, map3);
        HashMap<Object, CompositeDataSupport> toPut = new HashMap<Object, CompositeDataSupport>();
        toPut.put(new Object(), compData);
        toPut.put(new Object(), compData2);
        toPut.put(new Object(), compData3);
        data.putAll((Map<?, ?>)toPut);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(data);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object result = ois.readObject();
        TabularDataSupportTestCase.assertEquals((Object)data, (Object)result);
    }

    public void testErrors() throws Exception {
        CompositeData[] toPut;
        TabularDataSupport data;
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType rowType = new CompositeType("rowTypeName", "rowDescription", itemNames, itemDescriptions, itemTypes);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name1", "value1");
        map.put("name2", new Integer(2));
        CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
        CompositeType rowType2 = new CompositeType("rowTypeName2", "rowDescription", itemNames, itemDescriptions, itemTypes);
        CompositeDataSupport compData2 = new CompositeDataSupport(rowType2, map);
        String[] indexNames = new String[]{"name1", "name2"};
        TabularType tabularType = new TabularType("typeName", "description", rowType, indexNames);
        boolean caught = false;
        try {
            new TabularDataSupport(null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected IllegalArgumentException for null tabular type");
        }
        caught = false;
        try {
            new TabularDataSupport(null, 10, 0.5f);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected IllegalArgumentException for null tabular type");
        }
        caught = false;
        try {
            new TabularDataSupport(tabularType, -1, 0.5f);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected IllegalArgumentException for negative initial capacity");
        }
        caught = false;
        try {
            new TabularDataSupport(tabularType, 10, 0.0f);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected IllegalArgumentException for zero load factor");
        }
        caught = false;
        try {
            new TabularDataSupport(tabularType, 10, -0.5f);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected IllegalArgumentException for negative load factor");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.calculateIndex(null);
        }
        catch (NullPointerException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected NullPointerException for calculate index on null object");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.calculateIndex(compData2);
        }
        catch (InvalidOpenTypeException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected InvalidOpenTypeException for calculate index on wrong composite type");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.get((Object)null);
        }
        catch (NullPointerException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected NullPointerException for get((Object) null)");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.get(new Object());
        }
        catch (ClassCastException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected ClassCastException for get(new Object())");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.get((Object)new Object[]{"wrong"});
        }
        catch (InvalidKeyException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected InvalidKeyException for get(Object) wrong");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.get(null);
        }
        catch (NullPointerException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected NullPointerException for get((Object[]) null)");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.get(new Object[]{"wrong"});
        }
        catch (InvalidKeyException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected InvalidKeyException for get(Object[]) wrong");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.put(new Object(), (Object)null);
        }
        catch (NullPointerException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected NullPointerException for put(Object, Object) with null value");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.put(new Object(), new Object());
        }
        catch (ClassCastException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected ClassCastException for put(Object, Object) with none CompositeData");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.put(new Object(), compData2);
        }
        catch (InvalidOpenTypeException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected InvalidOpenTypeException for put(Object, Object) with wrong CompositeType");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.put(new Object(), compData);
            data.put(new Object(), compData);
        }
        catch (KeyAlreadyExistsException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected KeyAlreadyExistsException for put(Object, Object)");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.put(null);
        }
        catch (NullPointerException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected NullPointerException for put(CompositeData) with null value");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.put(compData2);
        }
        catch (InvalidOpenTypeException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected InvalidOpenTypeException for put(CompositeData) with wrong CompositeType");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.put(compData);
            data.put(compData);
        }
        catch (KeyAlreadyExistsException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected KeyAlreadyExistsException for put(CompositeData)");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.remove((Object)null);
        }
        catch (NullPointerException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected NullPointerException for remove((Object) null)");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.remove(new Object());
        }
        catch (ClassCastException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected ClassCastException for remove(new Object())");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.remove((Object)new Object[]{"wrong"});
        }
        catch (InvalidKeyException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected InvalidKeyException for remove(Object) wrong");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.remove(null);
        }
        catch (NullPointerException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected NullPointerException for remove((Object[]) null)");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            data.remove(new Object[]{"wrong"});
        }
        catch (InvalidKeyException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected InvalidKeyException for remove(Object[]) wrong");
        }
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            toPut = new HashMap();
            toPut.put(new Object(), compData);
            toPut.put(new Object(), null);
            data.putAll((Map<?, ?>)toPut);
        }
        catch (NullPointerException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected NullPointerException for putAll(Map) null");
        }
        data = new TabularDataSupport(tabularType);
        toPut = new HashMap();
        toPut.put(new Object(), compData);
        toPut.put(new Object(), null);
        try {
            data.putAll((Map<?, ?>)toPut);
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        TabularDataSupportTestCase.assertTrue((String)"Nothing should be added for NullPointerException putAll(Map)", (boolean)data.isEmpty());
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            toPut = new HashMap();
            toPut.put(new Object(), compData);
            toPut.put(new Object(), new Object());
            data.putAll((Map<?, ?>)toPut);
        }
        catch (ClassCastException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected ClassCastException for putAll(Map) non composite data");
        }
        data = new TabularDataSupport(tabularType);
        toPut = new HashMap();
        toPut.put(new Object(), compData);
        toPut.put(new Object(), new Object());
        try {
            data.putAll((Map<?, ?>)toPut);
        }
        catch (ClassCastException expected) {
            // empty catch block
        }
        TabularDataSupportTestCase.assertTrue((String)"Nothing should be added for ClassCastException putAll(Map)", (boolean)data.isEmpty());
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            toPut = new HashMap();
            toPut.put(new Object(), compData);
            toPut.put(new Object(), compData2);
            data.putAll((Map<?, ?>)toPut);
        }
        catch (InvalidOpenTypeException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected InvalidOpenTypeException for putAll(Map) wrong composite type");
        }
        data = new TabularDataSupport(tabularType);
        toPut = new HashMap();
        toPut.put(new Object(), compData);
        toPut.put(new Object(), compData2);
        try {
            data.putAll((Map<?, ?>)toPut);
        }
        catch (InvalidOpenTypeException expected) {
            // empty catch block
        }
        TabularDataSupportTestCase.assertTrue((String)"Nothing should be added for InvalidOpenTypeException putAll(Map)", (boolean)data.isEmpty());
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            toPut = new HashMap();
            toPut.put(new Object(), compData);
            toPut.put(new Object(), compData);
            data.putAll((Map<?, ?>)toPut);
        }
        catch (KeyAlreadyExistsException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected InvalidOpenTypeException for putAll(Map) with duplicate data");
        }
        data = new TabularDataSupport(tabularType);
        toPut = new HashMap();
        toPut.put(new Object(), compData);
        toPut.put(new Object(), compData);
        try {
            data.putAll((Map<?, ?>)toPut);
        }
        catch (KeyAlreadyExistsException expected) {
            // empty catch block
        }
        TabularDataSupportTestCase.assertTrue((String)"Nothing should be added for KeyAlreadyExistsException duplicates putAll(Map)", (boolean)data.isEmpty());
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            toPut = new HashMap();
            toPut.put(new Object(), compData);
            data.putAll((Map<?, ?>)toPut);
            toPut = new HashMap();
            toPut.put(new Object(), compData);
            data.putAll((Map<?, ?>)toPut);
        }
        catch (KeyAlreadyExistsException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected InvalidOpenTypeException for putAll(Map) adding a duplicate");
        }
        data = new TabularDataSupport(tabularType);
        toPut = new HashMap();
        toPut.put(new Object(), compData);
        data.putAll((Map<?, ?>)toPut);
        toPut = new HashMap();
        toPut.put(new Object(), compData);
        try {
            data.putAll((Map<?, ?>)toPut);
        }
        catch (KeyAlreadyExistsException expected) {
            // empty catch block
        }
        TabularDataSupportTestCase.assertTrue((String)"Nothing should be added for KeyAlreadyExistsException already put putAll(Map)", (data.size() == 1 ? 1 : 0) != 0);
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            toPut = new CompositeData[]{compData, null};
            data.putAll(toPut);
        }
        catch (NullPointerException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected NullPointerException for putAll(CompositeData[]) null");
        }
        data = new TabularDataSupport(tabularType);
        toPut = new CompositeData[]{compData, null};
        try {
            data.putAll(toPut);
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        TabularDataSupportTestCase.assertTrue((String)"Nothing should be added for NullPointerException putAll(CompositeData[])", (boolean)data.isEmpty());
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            toPut = new CompositeData[]{compData, compData2};
            data.putAll(toPut);
        }
        catch (InvalidOpenTypeException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected InvalidOpenTypeException for putAll(CompositeData[]) wrong composite type");
        }
        data = new TabularDataSupport(tabularType);
        toPut = new CompositeData[]{compData, compData2};
        try {
            data.putAll(toPut);
        }
        catch (InvalidOpenTypeException expected) {
            // empty catch block
        }
        TabularDataSupportTestCase.assertTrue((String)"Nothing should be added for InvalidOpenTypeException putAll(CompositeData[])", (boolean)data.isEmpty());
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            toPut = new CompositeData[]{compData, compData};
            data.putAll(toPut);
        }
        catch (KeyAlreadyExistsException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected InvalidOpenTypeException for putAll(CompositeData[]) with duplicate data");
        }
        data = new TabularDataSupport(tabularType);
        toPut = new CompositeData[]{compData, compData};
        try {
            data.putAll(toPut);
        }
        catch (KeyAlreadyExistsException expected) {
            // empty catch block
        }
        TabularDataSupportTestCase.assertTrue((String)"Nothing should be added for KeyAlreadyExistsException duplicates putAll(CompositeData[])", (boolean)data.isEmpty());
        caught = false;
        try {
            data = new TabularDataSupport(tabularType);
            toPut = new CompositeData[]{compData};
            data.putAll(toPut);
            data.putAll(toPut);
        }
        catch (KeyAlreadyExistsException e) {
            caught = true;
        }
        if (!caught) {
            TabularDataSupportTestCase.fail((String)"Expected InvalidOpenTypeException for putAll(CompositeData[]) adding a duplicate");
        }
        data = new TabularDataSupport(tabularType);
        toPut = new CompositeData[]{compData};
        data.putAll(toPut);
        try {
            data.putAll(toPut);
        }
        catch (KeyAlreadyExistsException expected) {
            // empty catch block
        }
        TabularDataSupportTestCase.assertTrue((String)"Nothing should be added for KeyAlreadyExistsException already put putAll(CompositeData[])", (data.size() == 1 ? 1 : 0) != 0);
    }
}

