/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.openmbean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import javax.management.ObjectName;
import javax.management.openmbean.SimpleType;
import junit.framework.TestCase;

public class SimpleTypeTestCase
extends TestCase {
    static ObjectName objectName;
    SimpleType[] types = new SimpleType[]{SimpleType.BIGDECIMAL, SimpleType.BIGINTEGER, SimpleType.BOOLEAN, SimpleType.BYTE, SimpleType.CHARACTER, SimpleType.DATE, SimpleType.DOUBLE, SimpleType.FLOAT, SimpleType.INTEGER, SimpleType.LONG, SimpleType.OBJECTNAME, SimpleType.SHORT, SimpleType.STRING, SimpleType.VOID};
    Class[] classes = new Class[]{BigDecimal.class, BigInteger.class, Boolean.class, Byte.class, Character.class, Date.class, Double.class, Float.class, Integer.class, Long.class, ObjectName.class, Short.class, String.class, Void.class};
    Object[] objects = new Object[]{new BigDecimal(1), BigInteger.ONE, new Boolean(false), new Byte(127), new Character('a'), new Date(System.currentTimeMillis()), new Double(1.0), new Float(1.0f), new Integer(1), new Long(1L), objectName, new Short(Short.MAX_VALUE), new String("hello"), null};

    public SimpleTypeTestCase(String s) {
        super(s);
    }

    public void testSimpleTypes() throws Exception {
        for (int i = 0; i < this.types.length; ++i) {
            String className = this.classes[i].getName();
            SimpleTypeTestCase.assertEquals((String)className, (String)this.types[i].getClassName());
            SimpleTypeTestCase.assertEquals((String)className, (String)this.types[i].getTypeName());
            SimpleTypeTestCase.assertEquals((String)className, (String)this.types[i].getDescription());
        }
    }

    public void testEquals() throws Exception {
        for (int i = 0; i < this.types.length; ++i) {
            for (int j = 0; j < this.types.length; ++j) {
                if (i == j) {
                    SimpleTypeTestCase.assertEquals((Object)this.types[i], (Object)this.types[j]);
                    continue;
                }
                SimpleTypeTestCase.assertTrue((String)("Simple Types should be different " + this.classes[i]), (this.types[i] != this.types[j] ? 1 : 0) != 0);
            }
        }
    }

    public void testIsValue() throws Exception {
        for (int i = 0; i < this.types.length; ++i) {
            for (int j = 0; j < this.types.length; ++j) {
                if (this.objects[i] == null) continue;
                if (i == j) {
                    SimpleTypeTestCase.assertTrue((String)(this.classes[i] + " should be a simple value of " + this.types[j]), (boolean)this.types[j].isValue(this.objects[i]));
                    continue;
                }
                SimpleTypeTestCase.assertTrue((String)(this.classes[i] + " should NOT be a simple value of " + this.types[j]), (!this.types[j].isValue(this.objects[i]) ? 1 : 0) != 0);
            }
            SimpleTypeTestCase.assertTrue((String)("null should NOT be a simple value of " + this.types[i]), (!this.types[i].isValue(null) ? 1 : 0) != 0);
        }
    }

    public void testHashCode() throws Exception {
        for (int i = 0; i < this.types.length; ++i) {
            SimpleTypeTestCase.assertEquals((int)this.classes[i].getName().hashCode(), (int)this.types[i].hashCode());
        }
    }

    public void testToString() throws Exception {
        for (int i = 0; i < this.types.length; ++i) {
            SimpleTypeTestCase.assertTrue((String)("Simple Type " + this.classes[i].getName() + " should contain " + SimpleType.class.getName()), (this.types[i].toString().indexOf(SimpleType.class.getName()) != -1 ? 1 : 0) != 0);
            SimpleTypeTestCase.assertTrue((String)("Simple Type " + this.classes[i].getName() + " should contain " + this.classes[i].getName()), (this.types[i].toString().indexOf(this.classes[i].getName()) != -1 ? 1 : 0) != 0);
        }
    }

    public void testSerialization() throws Exception {
        for (int i = 0; i < this.types.length; ++i) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.types[i]);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            SimpleType result = (SimpleType)ois.readObject();
            SimpleTypeTestCase.assertTrue((String)("Should resolve to same object after serialization " + this.types[i]), (this.types[i] == result ? 1 : 0) != 0);
        }
    }

    static {
        try {
            objectName = new ObjectName("test:test=test");
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }
}

