/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.client;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.jboss.ejb3.client.JndiPropertyInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.Injector;
import org.jboss.injection.InjectorFactory;
import org.jboss.injection.lang.reflect.BeanProperty;
import org.jboss.injection.lang.reflect.BeanPropertyFactory;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static void createInjectors(List<Injector> injectors, ClassLoader classLoader, InjectorFactory<?> factory, Collection<ResourceInjectionTargetMetaData> injectionTargets) {
        if (injectionTargets == null) {
            return;
        }
        for (ResourceInjectionTargetMetaData injectionTarget : injectionTargets) {
            AccessibleObject ao = Utils.findInjectionTarget(classLoader, injectionTarget);
            BeanProperty property = BeanPropertyFactory.create((AccessibleObject)ao);
            injectors.add(factory.create(property));
        }
    }

    public static Class<?> injectionTarget(String encName, ResourceInjectionMetaData ref, InjectionContainer container) {
        Class<?> injectionType = null;
        if (ref.getInjectionTargets() == null) {
            return injectionType;
        }
        ClassLoader loader = container.getClassloader();
        for (ResourceInjectionTargetMetaData injectionTarget : ref.getInjectionTargets()) {
            AccessibleObject ao = Utils.findInjectionTarget(loader, injectionTarget);
            BeanProperty prop = BeanPropertyFactory.create((AccessibleObject)ao);
            JndiPropertyInjector propInjector = new JndiPropertyInjector(prop, encName, container.getEnc());
            container.getInjectors().add(propInjector);
            Class<?> type = ao instanceof Field ? ((Field)ao).getType() : ((Method)ao).getParameterTypes()[0];
            if (injectionType == null) {
                injectionType = type;
                continue;
            }
            if (injectionType.equals(type)) continue;
            throw new IllegalStateException("Found multiple injection targets with different types");
        }
        return injectionType;
    }

    public static AccessibleObject findInjectionTarget(ClassLoader loader, ResourceInjectionTargetMetaData target) {
        Class<?> clazz = null;
        try {
            clazz = loader.loadClass(target.getInjectionTargetClass());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("<injection-target> class: " + target.getInjectionTargetClass() + " was not found in deployment");
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!target.getInjectionTargetName().equals(field.getName())) continue;
            return field;
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            if (!((Method)accessibleObject).getName().equals(target.getInjectionTargetName())) continue;
            return accessibleObject;
        }
        throw new RuntimeException("<injection-target> could not be found: " + target.getInjectionTargetClass() + "." + target.getInjectionTargetName());
    }

    public static String getEncName(Class type) {
        return "env/" + type.getName();
    }

    public static String getEncName(Method method) {
        String encName = method.getName().substring(3);
        encName = encName.length() > 1 ? encName.substring(0, 1).toLowerCase() + encName.substring(1) : encName.toLowerCase();
        encName = Utils.getEncName(method.getDeclaringClass()) + "/" + encName;
        return encName;
    }

    public static String getEncName(Field field) {
        return Utils.getEncName(field.getDeclaringClass()) + "/" + field.getName();
    }
}

