/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.sunday.unmarshalling.AllBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SequenceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.xml.sax.Attributes;

public class ChoiceBinding
extends ModelGroupBinding {
    private List choices = Collections.EMPTY_LIST;

    public ChoiceBinding(SchemaBinding schema) {
        super(schema);
    }

    public ElementBinding getArrayItem() {
        return null;
    }

    public void addParticle(ParticleBinding particle) {
        switch (this.choices.size()) {
            case 0: {
                this.choices = Collections.singletonList(particle);
                break;
            }
            case 1: {
                this.choices = new ArrayList(this.choices);
            }
            default: {
                this.choices.add(particle);
            }
        }
        super.addParticle(particle);
    }

    public Collection getParticles() {
        return Collections.unmodifiableCollection(this.choices);
    }

    public ModelGroupBinding.Cursor newCursor(ParticleBinding particle) {
        return new ModelGroupBinding.Cursor(particle){
            private int pos;
            private ElementBinding element;
            private int occurence;
            private boolean wildcardContent;
            {
                this.pos = -1;
            }

            public ParticleBinding getCurrentParticle() {
                if (this.pos < 0) {
                    throw new JBossXBRuntimeException("The cursor has not been positioned yet! startElement should be called.");
                }
                return (ParticleBinding)ChoiceBinding.this.choices.get(this.pos);
            }

            public ElementBinding getElement() {
                if (this.pos < 0) {
                    throw new JBossXBRuntimeException("The cursor has not been positioned yet! startElement should be called.");
                }
                return this.element;
            }

            public boolean isPositioned() {
                return this.pos != -1;
            }

            public void endElement(QName qName) {
                if (this.element == null || !this.element.getQName().equals(qName)) {
                    throw new JBossXBRuntimeException("Failed to process endElement for " + qName + " since the current element is " + (this.element == null ? "null" : this.element.getQName().toString()));
                }
                if (this.trace) {
                    ChoiceBinding.this.log.trace("endElement " + qName + " in " + this.getModelGroup());
                }
            }

            public int getOccurence() {
                return this.occurence;
            }

            public boolean isWildcardContent() {
                return this.wildcardContent;
            }

            protected List startElement(QName qName, Attributes atts, Set passedGroups, List groupStack, boolean required) {
                ParticleBinding particle;
                if (this.trace) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("startElement " + qName + " in " + this.getModelGroup() + ", " + ChoiceBinding.this.choices.size() + ": ");
                    for (int i = 0; i < ChoiceBinding.this.choices.size(); ++i) {
                        ParticleBinding particle2 = (ParticleBinding)ChoiceBinding.this.choices.get(i);
                        TermBinding o = particle2.getTerm();
                        if (o instanceof ElementBinding) {
                            sb.append(((ElementBinding)o).getQName());
                        } else if (o instanceof SequenceBinding) {
                            sb.append("sequence");
                        } else if (o instanceof ChoiceBinding) {
                            sb.append("choice");
                        } else if (o instanceof AllBinding) {
                            sb.append("all");
                        }
                        sb.append(" ");
                    }
                    sb.append("]");
                    ChoiceBinding.this.log.trace(sb.toString());
                }
                this.wildcardContent = false;
                int i = this.pos;
                if (this.pos >= 0 && ((particle = this.getCurrentParticle()).getMaxOccursUnbounded() || this.occurence < particle.getMinOccurs() || this.occurence < particle.getMaxOccurs())) {
                    --i;
                }
                while (i < ChoiceBinding.this.choices.size() - 1) {
                    particle = (ParticleBinding)ChoiceBinding.this.choices.get(++i);
                    TermBinding item = particle.getTerm();
                    if (item instanceof ElementBinding) {
                        ElementBinding element = (ElementBinding)item;
                        if (!qName.equals(element.getQName())) continue;
                        if (this.pos == i) {
                            ++this.occurence;
                        } else {
                            this.pos = i;
                            this.occurence = 1;
                        }
                        groupStack = this.addItem(groupStack, this);
                        this.element = element;
                        if (!this.trace) break;
                        ChoiceBinding.this.log.trace("found " + qName + " in " + this.getModelGroup());
                        break;
                    }
                    if (item instanceof ModelGroupBinding) {
                        int groupStackSize;
                        ModelGroupBinding modelGroup = (ModelGroupBinding)item;
                        if (passedGroups.contains(modelGroup)) continue;
                        switch (passedGroups.size()) {
                            case 0: {
                                passedGroups = Collections.singleton(this);
                                break;
                            }
                            case 1: {
                                passedGroups = new HashSet<1>(passedGroups);
                            }
                            default: {
                                passedGroups.add(this);
                            }
                        }
                        if ((groupStackSize = groupStack.size()) == (groupStack = modelGroup.newCursor(particle).startElement(qName, atts, passedGroups, groupStack, particle.isRequired(this.occurence))).size()) continue;
                        if (this.pos != i) {
                            this.pos = i;
                            this.occurence = 1;
                        } else {
                            ++this.occurence;
                        }
                        groupStack = this.addItem(groupStack, this);
                        this.element = null;
                        break;
                    }
                    if (!(item instanceof WildcardBinding)) continue;
                    WildcardBinding wildcard = (WildcardBinding)item;
                    this.element = wildcard.getElement(qName, atts);
                    if (this.element == null) continue;
                    if (this.pos != i) {
                        this.pos = i;
                        this.occurence = 1;
                    } else {
                        ++this.occurence;
                    }
                    groupStack = this.addItem(groupStack, this);
                    this.wildcardContent = true;
                    if (!this.trace) break;
                    ChoiceBinding.this.log.trace(qName + " is wildcard content");
                    break;
                }
                if (this.trace) {
                    if (i == ChoiceBinding.this.choices.size()) {
                        ChoiceBinding.this.log.trace(qName + " not found in " + this.getModelGroup());
                    } else {
                        ChoiceBinding.this.log.trace("leaving " + this.getModelGroup() + " i=" + i + ", pos=" + this.pos);
                    }
                }
                return groupStack;
            }

            protected ElementBinding getElement(QName qName, Attributes atts, Set passedGroups, boolean ignoreWildcards) {
                return this.getElement(ChoiceBinding.this.choices, qName, atts, passedGroups, ignoreWildcards);
            }
        };
    }

    protected boolean mayStartWith(QName qName, Set set) {
        boolean result = false;
        for (int i = 0; i < this.choices.size(); ++i) {
            ParticleBinding particle = (ParticleBinding)this.choices.get(i);
            TermBinding item = particle.getTerm();
            if (item instanceof ElementBinding) {
                ElementBinding element = (ElementBinding)item;
                if (!qName.equals(element.getQName())) continue;
                result = true;
                break;
            }
            if (item instanceof ModelGroupBinding) {
                ModelGroupBinding modelGroup = (ModelGroupBinding)item;
                if (set.contains(modelGroup)) continue;
                switch (set.size()) {
                    case 0: {
                        set = Collections.singleton(this);
                        break;
                    }
                    case 1: {
                        set = new HashSet<ChoiceBinding>(set);
                    }
                    default: {
                        set.add(this);
                    }
                }
                result = modelGroup.mayStartWith(qName, set);
                if (!result) continue;
                break;
            }
            throw new JBossXBRuntimeException("Unexpected item type in model group: " + item);
        }
        return result;
    }
}

