/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.schema;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ejb.SessionBean;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.core.jaxrpc.ParameterWrapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.ws.metadata.jaxrpcmapping.PackageMapping;
import org.jboss.ws.metadata.jaxrpcmapping.VariableMapping;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSComplexTypeDefinition;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSElementDeclaration;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModelGroup;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSParticle;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSSimpleTypeDefinition;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSTypeDefinition;
import org.jboss.ws.metadata.wsdl.xmlschema.WSSchemaUtils;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.tools.interfaces.SchemaCreatorIntf;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.SimpleTypeBindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaTypeCreator
implements SchemaCreatorIntf {
    protected Logger log = Logger.getLogger(SchemaTypeCreator.class);
    protected WSDLUtils utils = WSDLUtils.getInstance();
    protected SchemaUtils schemautils = SchemaUtils.getInstance();
    protected WSSchemaUtils sutils = null;
    protected LiteralTypeMapping typeMapping = new LiteralTypeMapping();
    private NamespaceRegistry namespaces = null;
    private JavaWsdlMapping javaWsdlMapping = new JavaWsdlMapping();
    protected String xsNS = "http://www.w3.org/2001/XMLSchema";
    private int maxPrefix = 1;
    protected JBossXSModel xsModel = null;
    protected Map<String, String> packageNamespaceMap = new HashMap<String, String>();

    public SchemaTypeCreator() {
        this.xsModel = new JBossXSModel();
        this.namespaces = this.xsModel.getNamespaceRegistry();
        this.sutils = WSSchemaUtils.getInstance(this.namespaces, null);
    }

    @Override
    public void addPackageNamespaceMapping(String pkgname, String ns) {
        if (pkgname == null) {
            throw new IllegalArgumentException("Illegal Null Argument:pkgname");
        }
        if (ns == null) {
            throw new IllegalArgumentException("Illegal Null Argument:ns");
        }
        this.packageNamespaceMap.put(pkgname, ns);
    }

    @Override
    public JBossXSTypeDefinition generateType(QName xmlType, Class javaType) {
        return this.generateType(xmlType, javaType, null);
    }

    @Override
    public JBossXSTypeDefinition generateType(QName xmlType, Class javaType, Map<String, QName> elementNames) {
        return this.getType(xmlType, javaType, elementNames);
    }

    @Override
    public QName getXMLSchemaType(Class javaType) {
        QName xmlt = this.schemautils.getToolsOverrideInTypeMapping(javaType);
        if (xmlt == null) {
            xmlt = this.typeMapping.getXMLType(javaType, false);
        }
        return xmlt;
    }

    @Override
    public JavaWsdlMapping getJavaWsdlMapping() {
        return this.javaWsdlMapping;
    }

    @Override
    public JBossXSModel getXSModel() {
        return this.xsModel;
    }

    @Override
    public HashMap getCustomNamespaceMap() {
        HashMap<String, String> map = null;
        if (this.namespaces != null) {
            Iterator iter = this.namespaces.getRegisteredPrefixes();
            while (iter != null && iter.hasNext()) {
                String prefix = (String)iter.next();
                if (!prefix.startsWith("ns")) continue;
                if (map == null) {
                    map = new HashMap<String, String>();
                }
                map.put(prefix, this.namespaces.getNamespaceURI(prefix));
            }
        }
        return map;
    }

    @Override
    public Map<String, String> getPackageNamespaceMap() {
        return this.packageNamespaceMap;
    }

    @Override
    public LiteralTypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    @Override
    public Class getJavaType(QName xmlType) {
        Class retType = this.typeMapping.getJavaType(xmlType);
        if (retType == null) {
            throw new IllegalArgumentException("Unsupported type: " + xmlType);
        }
        return retType;
    }

    @Override
    public void setXSModel(JBossXSModel xsm) {
        this.xsModel = xsm;
    }

    @Override
    public String allocatePrefix(String nsURI) {
        String prefix = this.namespaces.getPrefix(nsURI);
        return prefix == null ? this.namespaces.registerURI(nsURI, null) : prefix;
    }

    @Override
    public void setPackageNamespaceMap(Map<String, String> packageNamespaceMap) {
        this.packageNamespaceMap = packageNamespaceMap;
    }

    private JBossXSTypeDefinition checkTypeExistsInXSModel(QName xmlt) {
        JBossXSTypeDefinition ct = null;
        if (xmlt != null && this.xsModel != null) {
            ct = this.getXSTypeDefinitionIfPresent(xmlt);
        }
        return ct;
    }

    private JBossXSTypeDefinition getType(QName xmlType, Class javaType, Map<String, QName> elementNames) {
        JBossXSTypeDefinition ct = null;
        boolean registered = false;
        registered = xmlType == null ? (xmlType = this.getXMLSchemaType(javaType)) != null : this.typeMapping.isRegistered(javaType, xmlType);
        if (registered) {
            ct = this.checkTypeExistsInXSModel(xmlType);
        }
        if (ct == null && xmlType != null && "http://www.w3.org/2001/XMLSchema".equals(xmlType.getNamespaceURI()) && !javaType.isArray()) {
            ct = this.schemautils.getSchemaBasicType(xmlType.getLocalPart());
        }
        if (ct == null && Exception.class.isAssignableFrom(javaType)) {
            ct = this.getComplexTypeForJavaException(xmlType, javaType);
        }
        if (ct == null) {
            ct = this.generateNewType(xmlType, javaType, elementNames);
        }
        return ct;
    }

    private JBossXSTypeDefinition getXSTypeDefinitionIfPresent(QName qname) {
        return (JBossXSTypeDefinition)this.xsModel.getTypeDefinition(qname.getLocalPart(), qname.getNamespaceURI());
    }

    private JBossXSTypeDefinition generateNewType(QName xmlType, Class javaType, Map<String, QName> elementNames) {
        String namespace;
        String name;
        Class superclass = javaType.getSuperclass();
        JBossXSTypeDefinition baseType = null;
        List<XSParticle> particles = new ArrayList<XSParticle>();
        if (superclass != null && !this.utils.checkIgnoreClass(superclass) && (baseType = this.generateType(null, superclass)) != null) {
            this.addBaseTypeParts(baseType, particles);
        }
        if (javaType.isArray()) {
            return this.handleArray(xmlType, javaType);
        }
        if (xmlType != null) {
            name = xmlType.getLocalPart();
            namespace = xmlType.getNamespaceURI();
        } else {
            name = WSDLUtils.getJustClassName(javaType);
            namespace = this.getNamespace(javaType);
        }
        Class<?> valueType = this.getEnumerationValueType(javaType);
        if (valueType != null) {
            return this.handleJAXRPCEnumeration(name, namespace, javaType, valueType);
        }
        JBossXSComplexTypeDefinition complexType = this.sutils.createXSComplexTypeDefinition(name, baseType, particles, namespace);
        QName registerQName = new QName(namespace, name);
        this.typeMapping.register(javaType, registerQName, null, null);
        this.xsModel.addXSComplexTypeDefinition(complexType);
        particles.addAll(this.getXSParticlesForPublicFields(namespace, javaType, elementNames));
        try {
            particles.addAll(this.introspectJavaProperties(namespace, javaType, elementNames));
        }
        catch (IntrospectionException e) {
            this.log.error("Problem in introspection of the Java Type during type generation", e);
            throw new WSException(e);
        }
        if (elementNames instanceof LinkedHashMap) {
            particles = this.sortNamedOuterParticles(particles, (LinkedHashMap)elementNames);
        } else {
            Collections.sort(particles);
        }
        this.registerJavaTypeMapping(registerQName, javaType, "complexType", particles, elementNames);
        JBossXSModelGroup group = (JBossXSModelGroup)complexType.getParticle().getTerm();
        group.setParticles(particles);
        if (this.log.isDebugEnabled()) {
            this.log.debug("generateNewType: " + this.sutils.write(complexType));
        }
        return complexType;
    }

    private JBossXSTypeDefinition handleJAXRPCEnumeration(String name, String namespace, Class<?> javaType, Class<?> valueType) {
        JBossXSTypeDefinition enumType = this.generateType(null, valueType);
        JBossXSSimpleTypeDefinition simpleType = new JBossXSSimpleTypeDefinition();
        simpleType.setBaseType(enumType);
        simpleType.setName(name);
        simpleType.setNamespace(namespace);
        try {
            Method getValue = javaType.getMethod("getValue", new Class[0]);
            for (Field field : javaType.getFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(javaType)) continue;
                Object ret = getValue.invoke(field.get(null), new Object[0]);
                String item = SimpleTypeBindings.marshal(enumType.getName(), ret, new NamespaceRegistry());
                simpleType.addLexicalEnumeration(item);
            }
        }
        catch (Exception e) {
            throw new WSException("JAX-RPC Enumeration type did not conform to expectations");
        }
        this.xsModel.addXSTypeDefinition(simpleType);
        this.registerJavaTypeMapping(new QName(namespace, name), javaType, "simpleType", new ArrayList<XSParticle>(), null);
        return simpleType;
    }

    private Class<?> getEnumerationValueType(Class javaType) {
        try {
            javaType.getConstructor(new Class[0]);
            return null;
        }
        catch (NoSuchMethodException e) {
            for (Method method : javaType.getMethods()) {
                if (!Modifier.isStatic(method.getModifiers()) || !method.getName().equals("fromValue") || method.getParameterTypes().length != 1) continue;
                return method.getParameterTypes()[0];
            }
            return null;
        }
    }

    private List<XSParticle> sortNamedOuterParticles(List<XSParticle> particles, LinkedHashMap<String, QName> elementNames) {
        LinkedHashMap<String, XSParticle> index = new LinkedHashMap<String, XSParticle>();
        ArrayList<XSParticle> newList = new ArrayList<XSParticle>();
        for (XSParticle particle : particles) {
            XSTerm term = particle.getTerm();
            if (term instanceof XSElementDeclaration) {
                index.put(((XSElementDeclaration)term).getName(), particle);
                continue;
            }
            newList.add(particle);
        }
        for (QName name : elementNames.values()) {
            XSParticle found = (XSParticle)index.get(name.getLocalPart());
            if (found == null) continue;
            index.remove(name.getLocalPart());
            newList.add(found);
        }
        for (XSParticle particle : index.values()) {
            newList.add(particle);
        }
        return newList;
    }

    private void registerJavaTypeMapping(QName registerQName, Class javaType, String scope, List<XSParticle> particles, Map<String, QName> elementNames) {
        QName qname = new QName(registerQName.getNamespaceURI(), registerQName.getLocalPart(), "typeNS");
        String packageName = this.javaWsdlMapping.getPackageNameForNamespaceURI(qname.getNamespaceURI());
        if (packageName == null && javaType.getPackage() != null) {
            PackageMapping packageMapping = new PackageMapping(this.javaWsdlMapping);
            packageMapping.setNamespaceURI(qname.getNamespaceURI());
            packageMapping.setPackageType(javaType.getPackage().getName());
            this.javaWsdlMapping.addPackageMapping(packageMapping);
        }
        JavaXmlTypeMapping javaXmlTypeMapping = new JavaXmlTypeMapping(this.javaWsdlMapping);
        javaXmlTypeMapping.setJavaType(javaType.getName());
        javaXmlTypeMapping.setQNameScope(scope);
        javaXmlTypeMapping.setRootTypeQName(qname);
        HashMap<String, String> reversedNames = null;
        if (elementNames != null) {
            reversedNames = new HashMap<String, String>();
            for (String variable : elementNames.keySet()) {
                reversedNames.put(elementNames.get(variable).getLocalPart(), variable);
            }
        }
        this.addVariableMappings(javaType, javaXmlTypeMapping, particles, reversedNames);
        this.javaWsdlMapping.addJavaXmlTypeMappings(javaXmlTypeMapping);
    }

    private void addVariableMappings(Class javaType, JavaXmlTypeMapping javaXmlTypeMapping, List<XSParticle> particles, Map<String, String> reversedNames) {
        for (XSParticle particle : particles) {
            String name;
            XSTerm term = particle.getTerm();
            if (term.getType() == 7) {
                XSModelGroup group = (XSModelGroup)term;
                XSObjectList list2 = group.getParticles();
                ArrayList<XSParticle> baseParticles = new ArrayList<XSParticle>();
                for (int i = 0; i < list2.getLength(); ++i) {
                    baseParticles.add((XSParticle)list2.item(i));
                }
                this.addVariableMappings(javaType, javaXmlTypeMapping, baseParticles, null);
                continue;
            }
            String variableName = name = term.getName();
            if (reversedNames != null && reversedNames.get(name) != null) {
                variableName = reversedNames.get(name);
            }
            VariableMapping mapping = new VariableMapping(javaXmlTypeMapping);
            mapping.setJavaVariableName(variableName);
            mapping.setXmlElementName(name);
            mapping.setDataMember(this.utils.doesPublicFieldExist(javaType, variableName));
            if (this.isAlreadyMapped(javaXmlTypeMapping, mapping)) continue;
            javaXmlTypeMapping.addVariableMapping(mapping);
        }
    }

    private boolean isAlreadyMapped(JavaXmlTypeMapping jxtm, VariableMapping vm) {
        String javaVariableName = vm.getJavaVariableName();
        String attributeName = vm.getXmlAttributeName();
        String elementName = vm.getXmlElementName();
        for (VariableMapping current : jxtm.getVariableMappings()) {
            boolean matched = this.checkStringEquality(javaVariableName, current.getJavaVariableName());
            if (matched) {
                matched = this.checkStringEquality(attributeName, current.getXmlAttributeName());
            }
            if (matched) {
                matched = this.checkStringEquality(elementName, current.getXmlElementName());
            }
            if (!matched) continue;
            return true;
        }
        return false;
    }

    private List<XSParticle> getXSParticlesForPublicFields(String typeNamespace, Class javaType, Map<String, QName> elementNames) {
        ArrayList<XSParticle> particles = new ArrayList<XSParticle>();
        for (Field field : this.utils.getPublicFields(javaType)) {
            if (Collection.class.isAssignableFrom(field.getType())) {
                this.log.warn("JAX-RPC does not allow collection types skipping field: " + javaType.getName() + "." + field.getName());
                continue;
            }
            JBossXSParticle particle = this.createFieldParticle(typeNamespace, field.getName(), field.getType(), elementNames);
            particles.add(particle);
        }
        return particles;
    }

    private JBossXSTypeDefinition handleArray(QName xmlType, Class javaType) {
        String namespace;
        String name;
        JBossXSTypeDefinition xst;
        Class<?> componentType = javaType.getComponentType();
        boolean isComponentArray = componentType.isArray();
        JBossXSTypeDefinition jBossXSTypeDefinition = xst = isComponentArray ? this.handleArray(null, componentType) : this.generateType(null, componentType);
        if (xmlType != null) {
            name = xmlType.getLocalPart();
            namespace = xmlType.getNamespaceURI();
        } else if (!isComponentArray) {
            name = WSDLUtils.getJustClassName(componentType.getName()) + ".Array";
            namespace = this.getNamespace(componentType);
        } else {
            name = xst.getName() + ".Array";
            namespace = xst.getNamespace();
        }
        JBossXSParticle xsp = new JBossXSParticle();
        xsp.setTerm((XSTerm)this.sutils.createXSElementDeclaration("value", xst, !componentType.isPrimitive()));
        xsp.setMaxOccurs(-1);
        ArrayList<XSParticle> particles = new ArrayList<XSParticle>();
        particles.add(xsp);
        JBossXSComplexTypeDefinition complex = this.sutils.createXSComplexTypeDefinition(name, null, particles, namespace);
        this.xsModel.addXSComplexTypeDefinition(complex);
        this.typeMapping.register(javaType, new QName(namespace, name), null, null);
        return complex;
    }

    private List<XSParticle> introspectJavaProperties(String typeNamespace, Class javaType, Map<String, QName> elementNames) throws IntrospectionException {
        ArrayList<XSParticle> xsparts = new ArrayList<XSParticle>();
        Class superClass = javaType.getSuperclass();
        BeanInfo beanInfo = Introspector.getBeanInfo(javaType, superClass);
        PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
        int len = props != null ? props.length : 0;
        for (int i = 0; i < len && !SessionBean.class.isAssignableFrom(javaType); ++i) {
            PropertyDescriptor prop = props[i];
            String fieldname = prop.getName();
            Class<?> fieldType = prop.getPropertyType();
            if (prop instanceof IndexedPropertyDescriptor && fieldType == null) {
                this.log.warn("Indexed Properties without non-indexed accessors are not supported skipping: " + javaType.getName() + "." + fieldname);
                continue;
            }
            if (fieldType.equals(ParameterWrapping.WrapperType.class)) continue;
            if (Collection.class.isAssignableFrom(fieldType)) {
                this.log.warn("JAX-RPC does not allow collection types skipping: " + javaType.getName() + "." + fieldname);
                continue;
            }
            if (this.utils.doesPublicFieldExist(javaType, fieldname)) {
                throw new WSException("Class " + javaType.getName() + " has a public field & property :" + fieldname);
            }
            JBossXSParticle particle = this.createFieldParticle(typeNamespace, fieldname, fieldType, elementNames);
            xsparts.add(particle);
        }
        return xsparts;
    }

    private JBossXSParticle createFieldParticle(String typeNamespace, String fieldName, Class fieldType, Map<String, QName> elementNames) {
        JBossXSElementDeclaration xsel;
        QName name;
        boolean isArray;
        boolean bl = isArray = fieldType.isArray() && fieldType != byte[].class;
        if (isArray) {
            fieldType = fieldType.getComponentType();
        }
        JBossXSTypeDefinition xst = isArray && fieldType.isArray() ? this.handleArray(null, fieldType) : this.generateType(null, fieldType);
        String elementNamespace = null;
        if (elementNames != null && (name = elementNames.get(fieldName)) != null) {
            fieldName = name.getLocalPart();
            elementNamespace = name.getNamespaceURI();
            if (typeNamespace.equals(elementNamespace)) {
                elementNamespace = null;
            }
        }
        if (elementNamespace == null || elementNamespace.length() == 0) {
            xsel = this.sutils.createXSElementDeclaration(fieldName, xst, !fieldType.isPrimitive());
        } else {
            xsel = this.sutils.createGlobalXSElementDeclaration(fieldName, xst, elementNamespace);
            this.xsModel.addXSElementDeclaration(xsel);
        }
        JBossXSParticle particle = this.sutils.createXSParticle(typeNamespace, isArray, (XSTerm)xsel);
        return particle;
    }

    private void addBaseTypeParts(XSTypeDefinition baseType, List xsparts) {
        if (baseType == null) {
            throw new IllegalArgumentException("Illegal Null Argument:baseType");
        }
        if (15 == baseType.getTypeCategory()) {
            XSParticle part;
            XSTerm term;
            XSTypeDefinition btype = baseType.getBaseType();
            if (btype != null) {
                this.addBaseTypeParts(btype, xsparts);
            }
            if ((term = (part = ((XSComplexTypeDefinition)baseType).getParticle()).getTerm()) instanceof XSModelGroup) {
                JBossXSParticle p = new JBossXSParticle();
                p.setTerm(term);
                xsparts.add(p);
            }
        }
    }

    private String getNamespace(Class javaType) {
        if (javaType.isPrimitive()) {
            return "http://www.jboss.org/jbossws/primitives";
        }
        Package javaPackage = javaType.getPackage();
        if (javaPackage == null) {
            throw new WSException("Cannot determine namespace, Class had no package");
        }
        String packageName = javaPackage.getName();
        String ns = this.packageNamespaceMap.get(packageName);
        if (ns == null) {
            ns = WSDLUtils.getTypeNamespace(packageName);
        }
        this.allocatePrefix(ns);
        return ns;
    }

    private JBossXSComplexTypeDefinition getComplexTypeForJavaException(QName xmlType, Class javaType) {
        boolean noarg;
        String name;
        String namespace;
        if (!Exception.class.isAssignableFrom(javaType)) {
            throw new IllegalArgumentException("Type is not an excpetion");
        }
        if (RuntimeException.class.isAssignableFrom(javaType)) {
            throw new IllegalArgumentException("JAX-RPC violation, the following exception extends RuntimeException: " + javaType.getName());
        }
        if (xmlType != null) {
            namespace = xmlType.getNamespaceURI();
            name = xmlType.getLocalPart();
        } else {
            namespace = this.getNamespace(javaType);
            name = WSDLUtils.getJustClassName(javaType);
        }
        ArrayList<XSParticle> particles = new ArrayList<XSParticle>(0);
        ArrayList<Class> types = new ArrayList<Class>(0);
        JBossXSComplexTypeDefinition complexType = new JBossXSComplexTypeDefinition();
        complexType.setName(name);
        complexType.setNamespace(namespace);
        this.xsModel.addXSComplexTypeDefinition(complexType);
        this.xsModel.addXSElementDeclaration(this.sutils.createGlobalXSElementDeclaration(name, complexType, namespace));
        this.typeMapping.register(javaType, new QName(namespace, name), null, null);
        this.registerJavaTypeMapping(new QName(namespace, name), javaType, "complexType", particles, null);
        Class superClass = javaType.getSuperclass();
        if (!Exception.class.equals(superClass) || Throwable.class.equals(superClass)) {
            JBossXSTypeDefinition baseType = this.generateType(null, superClass);
            complexType.setBaseType(baseType);
        }
        this.generateExceptionParticles(namespace, javaType, types, particles);
        boolean found = this.hasConstructor(javaType, types);
        boolean bl = noarg = found && types.size() == 0;
        if (!found || noarg) {
            ArrayList<Class> newTypes = new ArrayList<Class>(types);
            newTypes.add(0, String.class);
            found = this.hasConstructor(javaType, newTypes);
            if (found) {
                this.insertBaseParticle(particles, "message", String.class, namespace);
            } else if (!noarg) {
                throw new IllegalArgumentException("Could not locate a constructor with the following types: " + javaType + ' ' + types);
            }
        }
        complexType.setParticle(this.createGroupParticle(namespace, particles));
        return complexType;
    }

    private void insertBaseParticle(List<XSParticle> particles, String name, Class type, String targetNS) {
        if (particles.size() == 0) {
            particles.add(this.getXSParticle(name, type, targetNS));
            return;
        }
        XSParticle particle = particles.get(0);
        XSTerm term = particle.getTerm();
        if (term.getType() == 7) {
            JBossXSModelGroup group = (JBossXSModelGroup)term;
            XSObjectList list2 = group.getParticles();
            ArrayList<XSParticle> baseParticles = new ArrayList<XSParticle>();
            for (int i = 0; i < list2.getLength(); ++i) {
                baseParticles.add((XSParticle)list2.item(i));
            }
            this.insertBaseParticle(baseParticles, name, type, targetNS);
            if (baseParticles.size() > list2.getLength()) {
                group.setParticles(baseParticles);
            }
        } else {
            particles.add(0, this.getXSParticle(name, type, targetNS));
        }
    }

    private boolean hasConstructor(Class javaType, List<Class> types) {
        boolean found = true;
        try {
            javaType.getConstructor(types.toArray(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            found = false;
        }
        return found;
    }

    private void generateExceptionParticles(String typeNamespace, Class javaType, List<Class> types, List<XSParticle> particles) {
        if (Exception.class.equals((Object)javaType)) {
            return;
        }
        Class superClass = javaType.getSuperclass();
        if (!Exception.class.equals(superClass)) {
            ArrayList<XSParticle> superParticles = new ArrayList<XSParticle>(0);
            this.generateExceptionParticles(typeNamespace, superClass, types, superParticles);
            particles.add(this.createGroupParticle(typeNamespace, superParticles));
        }
        TreeMap sortedGetters = new TreeMap();
        for (Method method : javaType.getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
            String name = method.getName();
            Class<?> returnType = method.getReturnType();
            if (!name.startsWith("get") || returnType == Void.TYPE) continue;
            name = Introspector.decapitalize(name.substring(3));
            sortedGetters.put(name, returnType);
        }
        for (String name : sortedGetters.keySet()) {
            Class type = (Class)sortedGetters.get(name);
            types.add(type);
            JBossXSParticle particle = this.createFieldParticle(typeNamespace, name, type, null);
            particles.add(particle);
        }
    }

    private JBossXSParticle createGroupParticle(String targetNS, List<XSParticle> memberParticles) {
        JBossXSParticle groupParticle = new JBossXSParticle(null, targetNS);
        JBossXSModelGroup group = new JBossXSModelGroup();
        group.setParticles(memberParticles, false);
        groupParticle.setTerm((XSTerm)group);
        return groupParticle;
    }

    private JBossXSParticle getXSParticle(String name, Class fieldType, String targetNS) {
        JBossXSTypeDefinition xstype = null;
        boolean isArray = fieldType.isArray();
        if (isArray) {
            fieldType = fieldType.getComponentType();
        }
        xstype = this.generateType(null, fieldType);
        boolean isNillable = !fieldType.isPrimitive();
        JBossXSElementDeclaration xsel = this.sutils.createXSElementDeclaration(name, xstype, isNillable);
        return this.sutils.createXSParticle(targetNS, isArray, (XSTerm)xsel);
    }

    private boolean checkStringEquality(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null && str2 != null) {
            return false;
        }
        if (str1 != null && str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }
}

