/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.authorization;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.security.authorization.AuthorizationContext;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.AuthorizationModule;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.ResourceType;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.authorization.modules.DelegatingAuthorizationModule;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.plugins.authorization.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossAuthorizationContext
extends AuthorizationContext {
    private static Logger log = Logger.getLogger(JBossAuthorizationContext.class);
    private boolean trace = log.isTraceEnabled();
    private ApplicationPolicy applicationPolicy = null;

    public JBossAuthorizationContext(String name, Subject subject, CallbackHandler handler) {
        this.securityDomainName = name;
        this.authenticatedSubject = subject;
        this.callbackHandler = handler;
    }

    public void setApplicationPolicy(ApplicationPolicy aPolicy) {
        if (aPolicy == null) {
            throw new IllegalArgumentException("Application Policy is null:domain=" + this.securityDomainName);
        }
        AuthorizationInfo authzInfo = aPolicy.getAuthorizationInfo();
        if (authzInfo == null) {
            throw new IllegalArgumentException("Application Policy has no AuthorizationInfo");
        }
        if (!authzInfo.getName().equals(this.securityDomainName)) {
            throw new IllegalArgumentException("Application Policy ->AuthorizationInfo:" + authzInfo.getName() + " does not match required domain name=" + this.securityDomainName);
        }
        this.applicationPolicy = aPolicy;
    }

    @Override
    public int authorize(final Resource resource) throws AuthorizationException {
        try {
            this.initializeModules(resource);
        }
        catch (PrivilegedActionException e1) {
            throw new RuntimeException(e1);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws AuthorizationException {
                    int result = JBossAuthorizationContext.this.invokeAuthorize(resource);
                    if (result == 1) {
                        JBossAuthorizationContext.this.invokeCommit();
                    }
                    if (result == -1) {
                        JBossAuthorizationContext.this.invokeAbort();
                        throw new AuthorizationException("Denied");
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception exc = e.getException();
            if (this.trace) {
                log.trace("Error in authorize:", exc);
            }
            this.invokeAbort();
            throw (AuthorizationException)exc;
        }
        return 1;
    }

    private void initializeModules(Resource resource) throws PrivilegedActionException {
        AuthorizationInfo authzInfo = this.getAuthorizationInfo(this.securityDomainName, resource);
        if (authzInfo == null) {
            throw new IllegalStateException("Authorization Info is null");
        }
        AuthorizationModuleEntry[] entries = authzInfo.getAuthorizationModuleEntry();
        int len = entries != null ? entries.length : 0;
        for (int i = 0; i < len; ++i) {
            AuthorizationModuleEntry entry = entries[i];
            ControlFlag flag = entry.getControlFlag();
            if (flag == null) {
                if (this.trace) {
                    log.trace("Null Control flag for entry:" + entry + ". Defaults to REQUIRED!");
                }
                flag = ControlFlag.REQUIRED;
            } else if (this.trace) {
                log.trace("Control flag for entry:" + entry + "is:[" + flag + "]");
            }
            this.controlFlags.add(flag);
            this.modules.add(this.instantiateModule(entry.getPolicyModuleName(), entry.getOptions()));
        }
    }

    private int invokeAuthorize(Resource resource) throws AuthorizationException {
        boolean encounteredRequiredError = false;
        boolean encounteredOptionalError = false;
        AuthorizationException moduleException = null;
        int overallDecision = -1;
        int length = this.modules.size();
        for (int i = 0; i < length; ++i) {
            int decision;
            ControlFlag flag;
            AuthorizationModule module;
            block14: {
                module = (AuthorizationModule)this.modules.get(i);
                flag = (ControlFlag)this.controlFlags.get(i);
                decision = -1;
                try {
                    decision = module.authorize(resource);
                }
                catch (Exception ae) {
                    decision = -1;
                    if (moduleException != null) break block14;
                    moduleException = new AuthorizationException(ae.getMessage());
                }
            }
            if (decision == 1) {
                overallDecision = 1;
                if (flag != ControlFlag.SUFFICIENT || encounteredRequiredError) continue;
                return 1;
            }
            if (flag == ControlFlag.REQUISITE) {
                if (this.trace) {
                    log.trace("REQUISITE failed for " + module);
                }
                if (moduleException == null) {
                    moduleException = new AuthorizationException("Authorization failed");
                } else {
                    throw moduleException;
                }
            }
            if (flag == ControlFlag.REQUIRED) {
                if (this.trace) {
                    log.trace("REQUIRED failed for " + module);
                }
                if (!encounteredRequiredError) {
                    encounteredRequiredError = true;
                }
            }
            if (flag != ControlFlag.OPTIONAL) continue;
            encounteredOptionalError = true;
        }
        String msg = this.getAdditionalErrorMessage(moduleException);
        if (encounteredRequiredError) {
            throw new AuthorizationException("Authorization Failed:" + msg);
        }
        if (overallDecision == -1 && encounteredOptionalError) {
            throw new AuthorizationException("Authorization Failed:" + msg);
        }
        if (overallDecision == -1) {
            throw new AuthorizationException("Authorization Failed:No modules active.");
        }
        return 1;
    }

    private void invokeCommit() throws AuthorizationException {
        int length = this.modules.size();
        for (int i = 0; i < length; ++i) {
            AuthorizationModule module = (AuthorizationModule)this.modules.get(i);
            boolean bool = module.commit();
            if (bool) continue;
            throw new AuthorizationException("commit on modules failed");
        }
    }

    private void invokeAbort() throws AuthorizationException {
        int length = this.modules.size();
        for (int i = 0; i < length; ++i) {
            AuthorizationModule module = (AuthorizationModule)this.modules.get(i);
            boolean bool = module.abort();
            if (bool) continue;
            throw new AuthorizationException("abort on modules failed");
        }
    }

    private AuthorizationModule instantiateModule(String name, Map<String, Object> map) throws PrivilegedActionException {
        AuthorizationModule am = null;
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        try {
            Class<?> clazz = tcl.loadClass(name);
            am = (AuthorizationModule)clazz.newInstance();
        }
        catch (Exception e) {
            log.debug("Error instantiating AuthorizationModule:", e);
        }
        if (am == null) {
            throw new IllegalStateException("AuthorizationModule has not been instantiated");
        }
        am.initialize(this.authenticatedSubject, this.callbackHandler, this.sharedState, map);
        return am;
    }

    private AuthorizationInfo getAuthorizationInfo(String domainName, Resource resource) {
        ResourceType layer = resource.getLayer();
        if (this.applicationPolicy != null) {
            return this.applicationPolicy.getAuthorizationInfo();
        }
        ApplicationPolicy aPolicy = SecurityConfiguration.getApplicationPolicy(domainName);
        if (aPolicy == null) {
            if (this.trace) {
                log.trace("Application Policy not obtained for domain=" + domainName + ". Trying to obtain the App policy for the default domain of the layer:");
            }
            if (layer == ResourceType.EJB) {
                aPolicy = SecurityConfiguration.getApplicationPolicy("jboss-ejb-policy");
            } else if (layer == ResourceType.WEB) {
                aPolicy = SecurityConfiguration.getApplicationPolicy("jboss-web-policy");
            }
        }
        if (aPolicy == null) {
            throw new IllegalStateException("Application Policy is null for domain:" + domainName);
        }
        AuthorizationInfo ai = aPolicy.getAuthorizationInfo();
        if (ai == null) {
            return this.getAuthorizationInfo(layer);
        }
        return aPolicy.getAuthorizationInfo();
    }

    private AuthorizationInfo getAuthorizationInfo(ResourceType layer) {
        AuthorizationInfo ai = null;
        if (layer == ResourceType.EJB) {
            ai = SecurityConfiguration.getApplicationPolicy("jboss-ejb-policy").getAuthorizationInfo();
        } else if (layer == ResourceType.WEB) {
            ai = SecurityConfiguration.getApplicationPolicy("jboss-web-policy").getAuthorizationInfo();
        } else {
            if (log.isTraceEnabled()) {
                log.trace("AuthorizationInfo not found. Providing default authorization info");
            }
            ai = new AuthorizationInfo("other");
            ai.add(new AuthorizationModuleEntry(DelegatingAuthorizationModule.class.getName()));
        }
        return ai;
    }

    private String getAdditionalErrorMessage(Exception e) {
        StringBuilder msg = new StringBuilder(" ");
        if (e != null) {
            msg.append(e.getLocalizedMessage());
        }
        return msg.toString();
    }
}

