/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.resource.connectionmanager.CachedConnectionManagerMBean;
import org.jboss.resource.connectionmanager.ConnectionCacheListener;
import org.jboss.resource.connectionmanager.ConnectionListener;
import org.jboss.resource.connectionmanager.ConnectionRecord;
import org.jboss.resource.connectionmanager.TransactionSynchronizer;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.TxUtils;
import org.jboss.tm.usertx.client.ServerVMClientUserTransaction;
import org.jboss.util.Strings;

public class CachedConnectionManager
extends ServiceMBeanSupport
implements ServerVMClientUserTransaction.UserTransactionStartedListener,
CachedConnectionManagerMBean {
    private boolean specCompliant;
    protected boolean trace;
    private boolean debug;
    protected boolean error;
    private ObjectName transactionManagerServiceName;
    private TransactionManager tm;
    private final ThreadLocal currentObjects = new ThreadLocal();
    private final Map objectToConnectionManagerMap = new HashMap();
    private Map connectionStackTraces = new WeakHashMap();

    public CachedConnectionManager() {
        this.trace = this.log.isTraceEnabled();
    }

    public boolean isSpecCompliant() {
        return this.specCompliant;
    }

    public void setSpecCompliant(boolean specCompliant) {
        if (specCompliant) {
            this.log.warn("THE SpecCompliant ATTRIBUTE IS MISNAMED SEE http://jira.jboss.com/jira/browse/JBAS-1662");
        }
        this.specCompliant = specCompliant;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean value) {
        this.debug = value;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean value) {
        this.error = value;
    }

    public ObjectName getTransactionManagerServiceName() {
        return this.transactionManagerServiceName;
    }

    public void setTransactionManagerServiceName(ObjectName transactionManagerServiceName) {
        this.transactionManagerServiceName = transactionManagerServiceName;
    }

    public CachedConnectionManager getInstance() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInUseConnections() {
        Map map = this.connectionStackTraces;
        synchronized (map) {
            return this.connectionStackTraces.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map listInUseConnections() {
        Map map = this.connectionStackTraces;
        synchronized (map) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (Map.Entry entry : this.connectionStackTraces.entrySet()) {
                Throwable stackTrace = (Throwable)entry.getValue();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos);
                stackTrace.printStackTrace(ps);
                result.put(entry.getKey().toString(), baos.toString());
            }
            return result;
        }
    }

    protected void startService() throws Exception {
        this.tm = (TransactionManager)this.getServer().getAttribute(this.transactionManagerServiceName, "TransactionManager");
        TransactionSynchronizer.setTransactionManager(this.tm);
        ServerVMClientUserTransaction.getSingleton().registerTxStartedListener(this);
        EnterpriseContext.setUserTransactionStartedListener(this);
    }

    protected void stopService() throws Exception {
        ServerVMClientUserTransaction.getSingleton().unregisterTxStartedListener(this);
        EnterpriseContext.setUserTransactionStartedListener(null);
    }

    public void pushMetaAwareObject(Object rawKey, Set unsharableResources) throws ResourceException {
        LinkedList<KeyConnectionAssociation> stack = (LinkedList<KeyConnectionAssociation>)this.currentObjects.get();
        if (stack == null) {
            if (this.trace) {
                this.log.trace("new stack for key: " + Strings.defaultToString(rawKey));
            }
            stack = new LinkedList<KeyConnectionAssociation>();
            this.currentObjects.set(stack);
        } else if (this.trace) {
            this.log.trace("old stack for key: " + Strings.defaultToString(rawKey));
        }
        KeyConnectionAssociation key = new KeyConnectionAssociation(rawKey);
        if (this.specCompliant && !stack.contains(key)) {
            this.reconnect(key, unsharableResources);
        }
        stack.addLast(key);
    }

    public void popMetaAwareObject(Set unsharableResources) throws ResourceException {
        LinkedList stack = (LinkedList)this.currentObjects.get();
        KeyConnectionAssociation oldKey = (KeyConnectionAssociation)stack.removeLast();
        if (this.trace) {
            this.log.trace("popped object: " + Strings.defaultToString(oldKey));
        }
        if (this.specCompliant) {
            if (!stack.contains(oldKey)) {
                this.disconnect(oldKey, unsharableResources);
            }
        } else if (this.debug && this.closeAll(oldKey.getCMToConnectionsMap()) && this.error) {
            throw new ResourceException("Some connections were not closed, see the log for the allocation stacktraces");
        }
    }

    KeyConnectionAssociation peekMetaAwareObject() {
        LinkedList stack = (LinkedList)this.currentObjects.get();
        if (stack == null) {
            return null;
        }
        if (!stack.isEmpty()) {
            return (KeyConnectionAssociation)stack.getLast();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerConnection(ConnectionCacheListener cm, ConnectionListener cl, Object connection, ConnectionRequestInfo cri) {
        if (this.debug) {
            Map map = this.connectionStackTraces;
            synchronized (map) {
                this.connectionStackTraces.put(connection, new Throwable("STACKTRACE"));
            }
        }
        KeyConnectionAssociation key = this.peekMetaAwareObject();
        if (this.trace) {
            this.log.trace("registering connection from " + cm + ", connection : " + connection + ", key: " + key);
        }
        if (key == null) {
            return;
        }
        ConnectionRecord cr = new ConnectionRecord(cl, connection, cri);
        Map cmToConnectionsMap = key.getCMToConnectionsMap();
        ArrayList<ConnectionRecord> conns = (ArrayList<ConnectionRecord>)cmToConnectionsMap.get(cm);
        if (conns == null) {
            conns = new ArrayList<ConnectionRecord>();
            cmToConnectionsMap.put(cm, conns);
        }
        conns.add(cr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterConnection(ConnectionCacheListener cm, Object c) {
        if (this.debug) {
            CloseConnectionSynchronization cas = this.getCloseConnectionSynchronization(false);
            if (cas != null) {
                cas.remove(c);
            }
            Map map = this.connectionStackTraces;
            synchronized (map) {
                this.connectionStackTraces.remove(c);
            }
        }
        KeyConnectionAssociation key = this.peekMetaAwareObject();
        if (this.trace) {
            this.log.trace("unregistering connection from " + cm + ", object: " + c + ", key: " + key);
        }
        if (key == null) {
            return;
        }
        Map cmToConnectionsMap = key.getCMToConnectionsMap();
        Collection conns = (Collection)cmToConnectionsMap.get(cm);
        if (conns == null) {
            return;
        }
        Iterator i = conns.iterator();
        while (i.hasNext()) {
            if (((ConnectionRecord)i.next()).connection != c) continue;
            i.remove();
            return;
        }
        throw new IllegalStateException("Trying to return an unknown connection2! " + c);
    }

    public void userTransactionStarted() throws SystemException {
        KeyConnectionAssociation key = this.peekMetaAwareObject();
        if (this.trace) {
            this.log.trace("user tx started, key: " + key);
        }
        if (key == null) {
            return;
        }
        Map cmToConnectionsMap = key.getCMToConnectionsMap();
        for (ConnectionCacheListener cm : cmToConnectionsMap.keySet()) {
            Collection conns = (Collection)cmToConnectionsMap.get(cm);
            cm.transactionStarted(conns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(KeyConnectionAssociation key, Set unsharableResources) throws ResourceException {
        Map cmToConnectionsMap = null;
        Map map = this.objectToConnectionManagerMap;
        synchronized (map) {
            cmToConnectionsMap = (Map)this.objectToConnectionManagerMap.get(key);
            if (cmToConnectionsMap == null) {
                return;
            }
        }
        key.setCMToConnectionsMap(cmToConnectionsMap);
        for (ConnectionCacheListener cm : cmToConnectionsMap.keySet()) {
            Collection conns = (Collection)cmToConnectionsMap.get(cm);
            cm.reconnect(conns, unsharableResources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(KeyConnectionAssociation key, Set unsharableResources) throws ResourceException {
        Map cmToConnectionsMap = key.getCMToConnectionsMap();
        if (!cmToConnectionsMap.isEmpty()) {
            Map map = this.objectToConnectionManagerMap;
            synchronized (map) {
                this.objectToConnectionManagerMap.put(key, cmToConnectionsMap);
            }
            for (ConnectionCacheListener cm : cmToConnectionsMap.keySet()) {
                Collection conns = (Collection)cmToConnectionsMap.get(cm);
                cm.disconnect(conns, unsharableResources);
            }
        }
    }

    private boolean closeAll(Map cmToConnectionsMap) {
        if (!this.debug) {
            return false;
        }
        boolean unclosed = false;
        Collection connections = cmToConnectionsMap.values();
        if (connections.size() != 0) {
            for (Collection conns : connections) {
                Iterator j = conns.iterator();
                while (j.hasNext()) {
                    Object c = ((ConnectionRecord)j.next()).connection;
                    CloseConnectionSynchronization cas = this.getCloseConnectionSynchronization(true);
                    if (cas == null) {
                        unclosed = true;
                        this.closeConnection(c);
                        continue;
                    }
                    cas.add(c);
                }
            }
        }
        return unclosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterConnectionCacheListener(ConnectionCacheListener cm) {
        if (this.trace) {
            this.log.trace("unregisterConnectionCacheListener: " + cm);
        }
        Map map = this.objectToConnectionManagerMap;
        synchronized (map) {
            for (Map cmToConnectionsMap : this.objectToConnectionManagerMap.values()) {
                if (cmToConnectionsMap == null) continue;
                cmToConnectionsMap.remove(cm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Object c) {
        try {
            Throwable e;
            Map map = this.connectionStackTraces;
            synchronized (map) {
                e = (Throwable)this.connectionStackTraces.remove(c);
            }
            Method m = c.getClass().getMethod("close", new Class[0]);
            try {
                if (e != null) {
                    this.log.info("Closing a connection for you.  Please close them yourself: " + c, e);
                } else {
                    this.log.info("Closing a connection for you.  Please close them yourself: " + c);
                }
                m.invoke(c, new Object[0]);
            }
            catch (Throwable t) {
                this.log.info("Throwable trying to close a connection for you, please close it yourself", t);
            }
        }
        catch (NoSuchMethodException nsme) {
            this.log.info("Could not find a close method on alleged connection objects.  Please close your own connections.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseConnectionSynchronization getCloseConnectionSynchronization(boolean createIfNotFound) {
        block6: {
            CloseConnectionSynchronization closeConnectionSynchronization;
            Transaction tx = this.tm.getTransaction();
            if (tx == null) break block6;
            TransactionSynchronizer.lock(tx);
            try {
                CloseConnectionSynchronization cas = (CloseConnectionSynchronization)TransactionSynchronizer.getCCMSynchronization(tx);
                if (cas == null && createIfNotFound && TxUtils.isActive(tx)) {
                    cas = new CloseConnectionSynchronization();
                    TransactionSynchronizer.registerCCMSynchronization(tx, cas);
                }
                closeConnectionSynchronization = cas;
            }
            catch (Throwable throwable) {
                try {
                    TransactionSynchronizer.unlock(tx);
                    throw throwable;
                }
                catch (Throwable t) {
                    this.log.debug("Unable to synchronize with transaction", t);
                }
            }
            TransactionSynchronizer.unlock(tx);
            return closeConnectionSynchronization;
        }
        return null;
    }

    private class CloseConnectionSynchronization
    implements Synchronization {
        HashSet connections = new HashSet();
        boolean closing = false;

        public synchronized void add(Object c) {
            if (this.closing) {
                return;
            }
            this.connections.add(c);
        }

        public synchronized void remove(Object c) {
            if (this.closing) {
                return;
            }
            this.connections.remove(c);
        }

        public void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            CloseConnectionSynchronization closeConnectionSynchronization = this;
            synchronized (closeConnectionSynchronization) {
                this.closing = true;
            }
            Iterator i = this.connections.iterator();
            while (i.hasNext()) {
                CachedConnectionManager.this.closeConnection(i.next());
            }
            this.connections.clear();
        }
    }

    private static final class KeyConnectionAssociation {
        private final Object o;
        private Map cmToConnectionsMap;

        KeyConnectionAssociation(Object o) {
            this.o = o;
        }

        public boolean equals(Object other) {
            return other instanceof KeyConnectionAssociation && this.o == ((KeyConnectionAssociation)other).o;
        }

        public String toString() {
            return Strings.defaultToString(this.o);
        }

        public int hashCode() {
            return System.identityHashCode(this.o);
        }

        public void setCMToConnectionsMap(Map cmToConnectionsMap) {
            this.cmToConnectionsMap = cmToConnectionsMap;
        }

        public Map getCMToConnectionsMap() {
            if (this.cmToConnectionsMap == null) {
                this.cmToConnectionsMap = new HashMap();
            }
            return this.cmToConnectionsMap;
        }
    }
}

