/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.loading;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.loading.ClassBytes;
import org.jboss.remoting.loading.ClassUtil;

public class ClassByteClassLoader
extends ClassLoader {
    private static final Logger log = Logger.getLogger(ClassByteClassLoader.class);
    private final Map loadedClasses = Collections.synchronizedMap(new HashMap());
    private final Map loadedResources = Collections.synchronizedMap(new HashMap());
    private final ReferenceQueue queue = new ReferenceQueue();
    private Client loaderClient = null;

    public ClassByteClassLoader() {
    }

    public ClassByteClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void setClientInvoker(Client loaderClient) {
        this.loaderClient = loaderClient;
    }

    public void destroy() {
        if (this.loaderClient != null && this.loaderClient.isConnected()) {
            this.loaderClient.disconnect();
        }
    }

    private void clean(MyRef myref) {
        this.loadedClasses.remove(myref.key);
        File f = (File)this.loadedResources.remove(myref.key);
        if (f != null) {
            f.delete();
        }
        myref.clear();
        myref = null;
    }

    private void performMaintenance() {
        int count = 0;
        Reference ref = null;
        while ((ref = this.queue.poll()) != null) {
            ++count;
            MyRef myref = (MyRef)ref;
            this.clean(myref);
        }
        if (count > 0 && log.isTraceEnabled()) {
            log.trace("ClassByteClassLoader reclaimed " + count + " objects");
        }
    }

    public String toString() {
        return "ClassByteClassLoader [" + this.loadedClasses + "]";
    }

    protected void finalize() throws Throwable {
        this.performMaintenance();
        Iterator iter = this.loadedResources.values().iterator();
        while (iter.hasNext()) {
            ((File)iter.next()).delete();
        }
        this.loadedResources.clear();
        this.loadedClasses.clear();
        super.finalize();
    }

    public Class loadClass(String className, ClassBytes[] bytes) throws ClassNotFoundException, IOException {
        Class<?> cl;
        this.performMaintenance();
        if (log.isTraceEnabled()) {
            log.trace("loadClass: " + className + ", bytes: " + bytes);
        }
        if (bytes != null) {
            for (int c = 0; c < bytes.length; ++c) {
                this.addClass(bytes[c]);
            }
        }
        if ((cl = this.lookupCachedClass(className)) != null) {
            return cl;
        }
        cl = this.findLoadedClass(className);
        if (cl != null) {
            return cl;
        }
        cl = Class.forName(className, false, ClassLoader.getSystemClassLoader());
        if (cl != null) {
            return cl;
        }
        cl = Class.forName(className, false, this.getParent());
        if (cl != null) {
            return cl;
        }
        cl = this.loadFromNetwork(className);
        if (cl != null) {
            return cl;
        }
        throw new ClassNotFoundException("Could not load class " + className);
    }

    /*
     * Loose catch block
     */
    private void addClassResource(String name, byte[] buf) throws IOException {
        block13: {
            File file;
            OutputStream out;
            block11: {
                this.performMaintenance();
                out = null;
                file = null;
                file = File.createTempFile("cbc", ".class");
                file.deleteOnExit();
                if (log.isTraceEnabled()) {
                    log.trace("adding resource at: " + name + " to file: " + file);
                }
                out = new FileOutputStream(file);
                out.write(buf);
                out.flush();
                Object var7_5 = null;
                if (out == null) break block11;
                try {
                    out.close();
                }
                catch (Exception ig) {
                    // empty catch block
                }
                out = null;
            }
            if (file != null) {
                this.loadedResources.put(name, file);
            }
            break block13;
            {
                catch (IOException ex) {
                    file = null;
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception ig) {
                        // empty catch block
                    }
                    out = null;
                }
                if (file != null) {
                    this.loadedResources.put(name, file);
                }
                throw throwable;
            }
        }
    }

    public InputStream getResourceAsStream(String name) {
        this.performMaintenance();
        String denormalized = name.replace('/', '.').substring(0, name.length() - 6);
        File file = (File)this.loadedResources.get(denormalized);
        if (log.isTraceEnabled()) {
            log.trace("getResourceAsStream =>" + denormalized + " = " + file);
        }
        if (file != null && file.exists()) {
            try {
                return new BufferedInputStream(new FileInputStream(file));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return super.getResourceAsStream(name);
    }

    public Class addClass(ClassBytes classBytes) throws IOException {
        this.performMaintenance();
        Class<?> cl = null;
        String name = classBytes.getClassName();
        if (!this.loadedClasses.containsKey(name)) {
            String cn;
            byte[] buf = classBytes.getClassBytes();
            boolean array = ClassUtil.isArrayClass(name);
            String string = cn = array ? ClassUtil.getArrayClassPart(name) : name;
            if (log.isTraceEnabled()) {
                log.trace("  add class: " + name + ", array?" + array + ", using as: " + cn);
            }
            cl = this.defineClass(cn, buf, 0, buf.length);
            this.resolveClass(cl);
            this.addClassResource(cn, buf);
            this.loadedClasses.put(cn, new MyRef(cn, cl));
        }
        return cl;
    }

    private Class lookupCachedClass(String cn) {
        Class cl = null;
        MyRef ref = (MyRef)this.loadedClasses.get(cn);
        if (ref != null && (cl = (Class)ref.get()) == null) {
            this.clean(ref);
        }
        return cl;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class cl;
        String cn;
        this.performMaintenance();
        boolean array = ClassUtil.isArrayClass(name);
        String string = cn = array ? ClassUtil.getArrayClassPart(name) : name;
        if (log.isTraceEnabled()) {
            log.trace("++ loadClass: " + name + ", array?" + array + ", normalized: [" + cn + "]");
        }
        if ((cl = this.lookupCachedClass(cn)) == null) {
            cl = this.findLoadedClass(cn);
        }
        if (cl != null) {
            if (array) {
                Object obj = Array.newInstance(cl, 1);
                return obj.getClass();
            }
            return cl;
        }
        cl = this.loadFromNetwork(cn);
        if (cl != null) {
            if (log.isTraceEnabled()) {
                log.trace("Loaded " + cn + " can class is " + cl);
            }
            return cl;
        }
        if (log.isTraceEnabled()) {
            log.trace("++ findClass: " + name + " not found, throwing ClassNotFoundException");
        }
        throw new ClassNotFoundException(name);
    }

    private Class loadFromNetwork(String className) {
        Class loadedClass;
        block8: {
            loadedClass = null;
            if (this.loaderClient != null) {
                String marshallerMethodName = "load_class";
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put("classname", className);
                try {
                    Object obj;
                    if (!this.loaderClient.isConnected()) {
                        this.loaderClient.connect();
                    }
                    if ((obj = this.loaderClient.invoke(marshallerMethodName, metadata)) != null) {
                        if (obj instanceof ClassBytes) {
                            ClassBytes classBytes = (ClassBytes)obj;
                            String name = classBytes.getClassName();
                            loadedClass = this.addClass(classBytes);
                        } else {
                            log.error("Can not load remote class bytes.  Returned object (" + obj + ") is not ClassBytes.");
                        }
                        break block8;
                    }
                    log.error("Can not load remote class bytes.");
                }
                catch (Throwable throwable) {
                    log.error("Error loading remote class.", throwable);
                }
            } else {
                log.trace("Remoting Client for ClassByteClassLoader is null.  Can not load class remotely.");
            }
        }
        return loadedClass;
    }

    private final class MyRef
    extends WeakReference {
        private final String key;

        MyRef(String key, Object obj) {
            super(obj);
            this.key = key;
        }
    }
}

