/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.remoting.util.StoppableTimerTask;
import org.jboss.remoting.util.TimerUtil;

public class ConnectionValidator
extends TimerTask
implements StoppableTimerTask {
    private static final Logger log = Logger.getLogger(ConnectionValidator.class.getName());
    public static final String VALIDATOR_PING_PERIOD = "validatorPingPeriod";
    public static final long DEFAULT_PING_PERIOD = 2000L;
    public static final String VALIDATOR_PING_TIMEOUT = "validatorPingTimeout";
    public static final String DEFAULT_PING_TIMEOUT = "1000";
    public static final String DEFAULT_NUMBER_OF_PING_RETRIES = "1";
    public static final String DEFAULT_NUMBER_OF_CONNECTION_RETRIES = "1";
    private static boolean trace = log.isTraceEnabled();
    private Client client;
    private long pingPeriod;
    private Map metadata;
    private InvokerLocator locator;
    private Map configMap;
    private List listeners;
    private ClientInvoker clientInvoker;
    private Object lock = new Object();
    private volatile boolean stopped;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkConnection(InvokerLocator locator, Map config) throws Throwable {
        boolean pingWorked = false;
        Map configMap = ConnectionValidator.createPingConfig(config, null);
        ClientInvoker innerClientInvoker = null;
        try {
            innerClientInvoker = InvokerRegistry.createClientInvoker(locator, configMap);
            if (!innerClientInvoker.isConnected()) {
                if (trace) {
                    log.trace("inner client invoker not connected, connecting ...");
                }
                innerClientInvoker.connect();
            }
            pingWorked = ConnectionValidator.doCheckConnection(innerClientInvoker);
        }
        catch (Throwable throwable) {
            log.debug("ConnectionValidator to connect to server " + innerClientInvoker.getLocator().getProtocol() + "://" + innerClientInvoker.getLocator().getHost() + ":" + innerClientInvoker.getLocator().getPort(), throwable);
        }
        finally {
            if (innerClientInvoker != null) {
                InvokerRegistry.destroyClientInvoker(locator, configMap);
            }
        }
        return pingWorked;
    }

    private static boolean doCheckConnection(ClientInvoker clientInvoker) throws Throwable {
        boolean pingWorked = false;
        try {
            InvocationRequest ir = new InvocationRequest(null, "self", "$PING$", null, null, null);
            if (trace) {
                log.trace("pinging, sending " + ir + " over " + clientInvoker);
            }
            clientInvoker.invoke(ir);
            if (trace) {
                log.trace("ConnectionValidator got successful ping using " + clientInvoker);
            }
            pingWorked = true;
        }
        catch (Throwable t) {
            log.debug("ConnectionValidator failed to ping via " + clientInvoker, t);
        }
        return pingWorked;
    }

    private static Map createPingConfig(Map config, Map metadata) {
        Object o;
        HashMap<String, String> localConfig = new HashMap<String, String>();
        localConfig.put("connection_checker", "true");
        if (config != null) {
            o = config.get(VALIDATOR_PING_TIMEOUT);
            log.trace("config timeout: " + o);
            if (o != null) {
                localConfig.put("timeout", (String)o);
            }
            if ((o = config.get("NumberOfCallRetries")) != null) {
                localConfig.put("NumberOfCallRetries", (String)o);
            }
            if ((o = config.get("NumberOfRetries")) != null) {
                localConfig.put("NumberOfRetries", (String)o);
            }
        }
        if (metadata != null) {
            metadata.remove("timeout");
            localConfig.putAll(metadata);
            o = metadata.get(VALIDATOR_PING_TIMEOUT);
            if (o != null) {
                localConfig.put("timeout", (String)o);
            }
        }
        if (localConfig.get("timeout") == null) {
            localConfig.put("timeout", DEFAULT_PING_TIMEOUT);
        }
        if (localConfig.get("NumberOfCallRetries") == null) {
            localConfig.put("NumberOfCallRetries", "1");
        }
        if (localConfig.get("NumberOfRetries") == null) {
            localConfig.put("NumberOfRetries", "1");
        }
        return localConfig;
    }

    public ConnectionValidator(Client client) {
        this(client, 2000L);
    }

    public ConnectionValidator(Client client, long pingPeriod) {
        this.client = client;
        this.pingPeriod = pingPeriod;
        this.listeners = new ArrayList();
        this.stopped = false;
        log.debug(this + " created");
    }

    public ConnectionValidator(Client client, Map metadata) {
        Object o;
        this.client = client;
        this.pingPeriod = 2000L;
        this.listeners = new ArrayList();
        this.stopped = false;
        Map config = client.getConfiguration();
        if (config != null && (o = config.get(VALIDATOR_PING_PERIOD)) != null) {
            if (o instanceof String) {
                try {
                    this.pingPeriod = Long.parseLong((String)o);
                }
                catch (Exception e) {
                    log.warn(this + " could not convert " + VALIDATOR_PING_PERIOD + " value of " + o + " to a long value");
                }
            } else {
                log.warn(this + " could not convert " + VALIDATOR_PING_PERIOD + " value of " + o + " to a long value: must be a String");
            }
        }
        if (metadata != null) {
            this.metadata = new HashMap(metadata);
            o = metadata.get(VALIDATOR_PING_PERIOD);
            if (o != null) {
                if (o instanceof String) {
                    try {
                        this.pingPeriod = Long.parseLong((String)o);
                    }
                    catch (Exception e) {
                        log.warn(this + " could not convert " + VALIDATOR_PING_PERIOD + " value of " + o + " to a long value");
                    }
                } else {
                    log.warn(this + " could not convert " + VALIDATOR_PING_PERIOD + " value of " + o + " to a long value: must be a String");
                }
            }
        }
        log.debug(this + " created");
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.stopped) {
                try {
                    boolean isValid;
                    if (trace) {
                        log.trace(this + " pinging ...");
                    }
                    if (!(isValid = ConnectionValidator.doCheckConnection(this.clientInvoker))) {
                        log.debug(this + "'s connections is invalid");
                        this.notifyListeners(new Exception("Could not connect to server!"));
                    }
                }
                catch (Throwable thr) {
                    log.debug(this + " got throwable while pinging", thr);
                    this.notifyListeners(thr);
                }
            }
        }
    }

    public boolean cancel() {
        return this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener listener) {
        if (listener != null) {
            List list2 = this.listeners;
            synchronized (list2) {
                if (this.listeners.size() == 0) {
                    this.start();
                }
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConnectionListener(ConnectionListener listener) {
        boolean isRemoved = false;
        if (listener != null) {
            List list2 = this.listeners;
            synchronized (list2) {
                isRemoved = this.listeners.remove(listener);
                if (this.listeners.size() == 0) {
                    this.stop();
                }
            }
        }
        return isRemoved;
    }

    public long getPingPeriod() {
        if (this.stopped) {
            return -1L;
        }
        return this.pingPeriod;
    }

    public String toString() {
        return "ConnectionValidator[" + this.clientInvoker + ", pingPeriod=" + this.pingPeriod + " ms]";
    }

    private void start() {
        this.configMap = ConnectionValidator.createPingConfig(this.client.getConfiguration(), this.metadata);
        log.debug(this + " timeout: " + this.configMap.get("timeout"));
        log.debug(this + " ping retries: " + this.configMap.get("NumberOfCallRetries"));
        log.debug(this + " connection retries: " + this.configMap.get("NumberOfRetries"));
        this.locator = this.client.getInvoker().getLocator();
        try {
            this.clientInvoker = InvokerRegistry.createClientInvoker(this.locator, this.configMap);
        }
        catch (Exception e) {
            log.error("Unable to create client invoker for locator: " + this.locator);
            throw new RuntimeException("Unable to create client invoker for locator: " + this.locator, e);
        }
        if (!this.clientInvoker.isConnected()) {
            if (trace) {
                log.trace("inner client invoker not connected, connecting ...");
            }
            this.clientInvoker.connect();
        }
        TimerUtil.schedule(this, this.pingPeriod);
        this.stopped = false;
        log.debug(this + " started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doStop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.listeners.isEmpty()) {
                this.listeners.clear();
            }
            this.stopped = true;
        }
        if (this.clientInvoker != null) {
            InvokerRegistry.destroyClientInvoker(this.locator, this.configMap);
        }
        TimerUtil.unschedule(this);
        boolean result = super.cancel();
        log.debug(this + " stopped, returning " + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(Throwable thr) {
        final Throwable t = thr;
        List list2 = this.listeners;
        synchronized (list2) {
            ListIterator itr = this.listeners.listIterator();
            while (itr.hasNext()) {
                final ConnectionListener listener = (ConnectionListener)itr.next();
                new Thread(){

                    public void run() {
                        listener.handleConnectionException(t, ConnectionValidator.this.client);
                    }
                }.start();
            }
        }
        this.stop();
        this.listeners.clear();
    }
}

