/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanPermission;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanTrustPermission;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.modelmbean.ModelMBeanConstants;
import org.jboss.mx.modelmbean.RequiredModelMBeanInstantiator;
import org.jboss.mx.notification.MBeanServerListenerRegistry;
import org.jboss.mx.server.ExceptionHandler;
import org.jboss.mx.server.MBeanInvoker;
import org.jboss.mx.server.ObjectInputStreamWithClassLoader;
import org.jboss.mx.server.ServerConstants;
import org.jboss.mx.server.TCLAction;
import org.jboss.mx.server.registry.MBeanEntry;
import org.jboss.mx.server.registry.MBeanRegistry;
import org.jboss.mx.service.ServiceConstants;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.PropertyAccess;
import org.jboss.util.NestedRuntimeException;

public class MBeanServerImpl
implements MBeanServer,
ServerConstants,
ServiceConstants,
ModelMBeanConstants {
    private static final Object[] NOPARAMS = new Object[0];
    private static final String[] NOSIG = new String[0];
    protected MBeanServer outer = null;
    protected MBeanRegistry registry = null;
    private MBeanServerListenerRegistry listeners = new MBeanServerListenerRegistry();
    private ClassLoaderRepository classLoaderRepository;
    private static Logger log = Logger.getLogger(MBeanServerImpl.class);

    public MBeanServerImpl(String defaultDomain, MBeanServer outer, MBeanServerDelegate delegate) {
        this.outer = outer == null ? this : outer;
        this.classLoaderRepository = this.getClassLoaderRepository();
        this.registry = this.createRegistry(defaultDomain);
        try {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("JMImplementation", "JMImplementation");
            this.registry.registerMBean(delegate, new ObjectName("JMImplementation:type=MBeanServerDelegate"), valueMap);
            ModelMBean rmm = RequiredModelMBeanInstantiator.instantiate();
            rmm.setModelMBeanInfo(this.getRegistryManagementInterface());
            rmm.setManagedResource(this.registry, "ObjectReference");
            this.registry.registerMBean(rmm, new ObjectName("JMImplementation:type=MBeanRegistry"), valueMap);
            ObjectName loaderName = new ObjectName("JMImplementation:service=LoaderRepository,name=Default");
            this.registry.registerMBean(this.classLoaderRepository, loaderName, valueMap);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create MBeanServer", e);
        }
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.instantiate(className, (ClassLoader)null, NOPARAMS, NOSIG);
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return this.instantiate(className, (ClassLoader)null, params, signature);
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.instantiate(className, loaderName, NOPARAMS, NOSIG);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        ClassLoader cl = null;
        try {
            if (loaderName != null) {
                cl = (ClassLoader)this.registry.get(loaderName).getResourceInstance();
            }
        }
        catch (ClassCastException e) {
            throw new ReflectionException(e, loaderName + " is not a class loader.");
        }
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return this.instantiate(className, cl, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            Object mbean = this.instantiate(className);
            return this.registerMBean(mbean, name, (ClassLoader)null);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (ReflectionException refex) {
            if (refex.getCause() instanceof InstantiationException) {
                throw new NotCompliantMBeanException("Cannot instanciate MBean: " + className);
            }
            throw refex;
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            Object mbean = this.instantiate(className, params, signature);
            return this.registerMBean(mbean, name, (ClassLoader)null);
        }
        catch (ReflectionException refex) {
            return this.handleExceptionOnCreate(refex, className);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            Object mbean = this.instantiate(className, loaderName);
            return this.registerMBean(mbean, name, loaderName);
        }
        catch (ReflectionException refex) {
            return this.handleExceptionOnCreate(refex, className);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            Object mbean = this.instantiate(className, loaderName, params, signature);
            return this.registerMBean(mbean, name, loaderName);
        }
        catch (ReflectionException refex) {
            return this.handleExceptionOnCreate(refex, className);
        }
    }

    private ObjectInstance handleExceptionOnCreate(ReflectionException refex, String className) throws NotCompliantMBeanException, ReflectionException {
        if (refex.getCause() instanceof InstantiationException) {
            throw new NotCompliantMBeanException("Cannot instanciate MBean: " + className);
        }
        throw refex;
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.registerMBean(object, name, (ClassLoader)null);
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        MBeanEntry entry = this.registry.get(name);
        Object mbean = entry.getResourceInstance();
        name = entry.getObjectName();
        this.checkMBeanPermission(entry.getResourceClassName(), null, name, "unregisterMBean");
        try {
            final Object[] args = new Object[]{name};
            final String[] sig = new String[]{ObjectName.class.getName()};
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return MBeanServerImpl.this.invoke(new ObjectName("JMImplementation:type=MBeanRegistry"), "unregisterMBean", args, sig);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        catch (Throwable t2) {
            Exception t2;
            Throwable result = JMXExceptionDecoder.decodeToJMXException(t2);
            if (result instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)result;
            }
            if (result instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)result;
            }
            if (result instanceof JMRuntimeException) {
                throw (JMRuntimeException)result;
            }
            if (result instanceof MBeanException) {
                MBeanException e = (MBeanException)result;
                t2 = e.getTargetException();
                if (t2 instanceof InstanceNotFoundException) {
                    throw (InstanceNotFoundException)t2;
                }
                if (t2 instanceof MBeanRegistrationException) {
                    throw (MBeanRegistrationException)t2;
                }
            }
            if (result instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)result);
            }
            if (result instanceof Error) {
                throw new RuntimeErrorException((Error)result);
            }
            throw new MBeanRegistrationException(new InvocationTargetException(t2), "Cannot unregister MBean");
        }
        if (mbean instanceof NotificationBroadcaster) {
            this.listeners.remove(name);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        ObjectInstance oi = this.registry.getObjectInstance(name);
        this.checkMBeanPermission(oi.getClassName(), null, name, "getObjectInstance");
        return oi;
    }

    public Set queryMBeans(ObjectName name, QueryExp query) {
        this.checkMBeanPermission(null, null, null, "queryMBeans");
        HashSet<ObjectInstance> result = new HashSet<ObjectInstance>();
        if (query != null) {
            query.setMBeanServer(this.outer);
        }
        SecurityManager sm = System.getSecurityManager();
        List entries = this.registry.findEntries(name);
        for (MBeanEntry entry : entries) {
            ObjectName objectName = entry.getObjectName();
            if (sm != null) {
                try {
                    this.checkMBeanPermission(entry.getResourceClassName(), null, objectName, "queryMBeans");
                }
                catch (SecurityException e) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Excluded mbean due to security: " + objectName);
                    continue;
                }
            }
            if (!this.queryMBean(objectName, query)) continue;
            try {
                ObjectInstance instance = this.registry.getObjectInstance(objectName);
                result.add(instance);
            }
            catch (InstanceNotFoundException ignored) {}
        }
        return result;
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        this.checkMBeanPermission(null, null, null, "queryNames");
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        if (query != null) {
            query.setMBeanServer(this.outer);
        }
        SecurityManager sm = System.getSecurityManager();
        List entries = this.registry.findEntries(name);
        for (MBeanEntry entry : entries) {
            ObjectName objectName = entry.getObjectName();
            if (sm != null) {
                try {
                    this.checkMBeanPermission(entry.getResourceClassName(), null, objectName, "queryNames");
                }
                catch (SecurityException e) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Excluded mbean due to security: " + objectName);
                    continue;
                }
            }
            if (!this.queryMBean(objectName, query)) continue;
            result.add(objectName);
        }
        return result;
    }

    public boolean isRegistered(ObjectName name) {
        return this.registry.contains(name);
    }

    public Integer getMBeanCount() {
        return new Integer(this.registry.getSize());
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        MBeanEntry entry = this.registry.get(name);
        this.checkMBeanPermission(entry.getResourceClassName(), attribute, name, "getAttribute");
        MBeanInvoker mbean = entry.getInvoker();
        return mbean.getAttribute(attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        MBeanEntry entry = this.registry.get(name);
        String className = entry.getResourceClassName();
        this.checkMBeanPermission(className, null, name, "getAttribute");
        MBeanInvoker mbean = entry.getInvoker();
        AttributeList list2 = mbean.getAttributes(attributes);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            Iterator iter = list2.iterator();
            while (iter.hasNext()) {
                Attribute attr = (Attribute)iter.next();
                String aname = attr.getName();
                try {
                    this.checkMBeanPermission(className, aname, name, "getAttribute");
                }
                catch (SecurityException e) {
                    if (log.isTraceEnabled()) {
                        log.trace("Excluded attribute due to security: " + aname);
                    }
                    iter.remove();
                }
            }
        }
        return list2;
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        MBeanEntry entry = this.registry.get(name);
        String attributeName = null;
        if (attribute != null) {
            attributeName = attribute.getName();
        }
        this.checkMBeanPermission(entry.getResourceClassName(), attributeName, name, "setAttribute");
        MBeanInvoker mbean = entry.getInvoker();
        mbean.setAttribute(attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        MBeanEntry entry = this.registry.get(name);
        String className = entry.getResourceClassName();
        this.checkMBeanPermission(className, null, name, "setAttribute");
        MBeanInvoker mbean = entry.getInvoker();
        AttributeList list2 = mbean.setAttributes(attributes);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            Iterator iter = list2.iterator();
            while (iter.hasNext()) {
                Attribute attr = (Attribute)iter.next();
                String aname = attr.getName();
                try {
                    this.checkMBeanPermission(className, aname, name, "setAttribute");
                }
                catch (SecurityException e) {
                    if (log.isTraceEnabled()) {
                        log.trace("Excluded attribute due to security: " + aname);
                    }
                    iter.remove();
                }
            }
        }
        return list2;
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        MBeanEntry entry = this.registry.get(name);
        this.checkMBeanPermission(entry.getResourceClassName(), operationName, name, "invoke");
        MBeanInvoker mbean = entry.getInvoker();
        return mbean.invoke(operationName, params, signature);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        MBeanEntry entry = this.registry.get(name);
        this.checkMBeanPermission(entry.getResourceClassName(), null, name, "getMBeanInfo");
        try {
            MBeanInvoker invoker = entry.getInvoker();
            return invoker.getMBeanInfo();
        }
        catch (Exception e) {
            JMException result = ExceptionHandler.handleException(e);
            if (result instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)result;
            }
            if (result instanceof IntrospectionException) {
                throw (IntrospectionException)result;
            }
            if (result instanceof ReflectionException) {
                throw (ReflectionException)result;
            }
            throw new RuntimeException("Cannot obtain MBeanInfo " + name, result);
        }
    }

    public String getDefaultDomain() {
        return this.registry.getDefaultDomain();
    }

    public String[] getDomains() {
        this.checkMBeanPermission(null, null, null, "getDomains");
        String[] domains = this.registry.getDomains();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ArrayList<String> tmp = new ArrayList<String>();
            int length = domains != null ? domains.length : 0;
            for (int n = 0; n < length; ++n) {
                String domain = domains[n];
                try {
                    ObjectName name = new ObjectName(domain, "x", "x");
                    this.checkMBeanPermission(null, null, name, "getDomains");
                    tmp.add(domain);
                    continue;
                }
                catch (MalformedObjectNameException e) {
                    continue;
                }
                catch (SecurityException e) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Excluded domain due to security: " + domain);
                }
            }
            domains = new String[tmp.size()];
            tmp.toArray(domains);
        }
        return domains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        MBeanEntry entry = this.registry.get(name);
        if (!NotificationBroadcaster.class.isInstance(entry.getResourceInstance())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + name + " exists but does not implement the NotificationBroadcaster interface."));
        }
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Cannot add null listener"));
        }
        this.checkMBeanPermission(entry.getResourceClassName(), null, name, "addNotificationListener");
        ClassLoader newTCL = entry.getClassLoader();
        MBeanInvoker broadcaster = entry.getInvoker();
        ClassLoader oldTCL = TCLAction.UTIL.getContextClassLoader();
        boolean setCl = newTCL != oldTCL && newTCL != null;
        try {
            if (setCl) {
                TCLAction.UTIL.setContextClassLoader(newTCL);
            }
            this.listeners.add(entry.getObjectName(), broadcaster, listener, filter, handback);
        }
        finally {
            if (setCl) {
                TCLAction.UTIL.setContextClassLoader(oldTCL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        MBeanEntry entry = this.registry.get(name);
        if (!NotificationBroadcaster.class.isInstance(entry.getResourceInstance())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + name + " exists but does not implement the NotificationBroadcaster interface."));
        }
        MBeanEntry listenerEntry = this.registry.get(listener);
        if (!NotificationListener.class.isInstance(listenerEntry.getResourceInstance())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + listener + " exists but does not implement the NotificationListener interface."));
        }
        this.checkMBeanPermission(entry.getResourceClassName(), null, name, "addNotificationListener");
        ClassLoader newTCL = entry.getClassLoader();
        MBeanInvoker broadcaster = entry.getInvoker();
        ClassLoader oldTCL = TCLAction.UTIL.getContextClassLoader();
        boolean setCl = newTCL != oldTCL && newTCL != null;
        try {
            if (setCl) {
                TCLAction.UTIL.setContextClassLoader(newTCL);
            }
            this.listeners.add(entry.getObjectName(), broadcaster, (NotificationListener)this.registry.get(listener).getResourceInstance(), filter, handback);
        }
        finally {
            if (setCl) {
                TCLAction.UTIL.setContextClassLoader(oldTCL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        MBeanEntry entry = this.registry.get(name);
        if (!NotificationBroadcaster.class.isInstance(entry.getResourceInstance())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + name + " exists but does not implement the NotificationBroadcaster interface."));
        }
        this.checkMBeanPermission(entry.getResourceClassName(), null, name, "removeNotificationListener");
        ClassLoader newTCL = entry.getClassLoader();
        ClassLoader oldTCL = TCLAction.UTIL.getContextClassLoader();
        boolean setCl = newTCL != oldTCL && newTCL != null;
        try {
            if (setCl) {
                TCLAction.UTIL.setContextClassLoader(newTCL);
            }
            this.listeners.remove(entry.getObjectName(), listener);
        }
        finally {
            if (setCl) {
                TCLAction.UTIL.setContextClassLoader(oldTCL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        MBeanEntry entry = this.registry.get(name);
        if (!NotificationBroadcaster.class.isInstance(entry.getResourceInstance())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + name + " exists but does not implement the NotificationBroadcaster interface."));
        }
        MBeanEntry listenerEntry = this.registry.get(listener);
        if (!NotificationListener.class.isInstance(listenerEntry.getResourceInstance())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + listener + " exists but does not implement the NotificationListener interface."));
        }
        this.checkMBeanPermission(entry.getResourceClassName(), null, name, "removeNotificationListener");
        ClassLoader newTCL = entry.getClassLoader();
        ClassLoader oldTCL = TCLAction.UTIL.getContextClassLoader();
        boolean setCl = newTCL != oldTCL && newTCL != null;
        try {
            if (setCl) {
                TCLAction.UTIL.setContextClassLoader(newTCL);
            }
            this.listeners.remove(entry.getObjectName(), (NotificationListener)this.registry.get(listener).getResourceInstance());
        }
        finally {
            if (setCl) {
                TCLAction.UTIL.setContextClassLoader(oldTCL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        MBeanEntry entry = this.registry.get(name);
        if (!NotificationBroadcaster.class.isInstance(entry.getResourceInstance())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + name + " exists but does not implement the NotificationBroadcaster interface."));
        }
        this.checkMBeanPermission(entry.getResourceClassName(), null, name, "removeNotificationListener");
        ClassLoader newTCL = entry.getClassLoader();
        ClassLoader oldTCL = TCLAction.UTIL.getContextClassLoader();
        boolean setCl = newTCL != oldTCL && newTCL != null;
        try {
            if (setCl) {
                TCLAction.UTIL.setContextClassLoader(newTCL);
            }
            this.listeners.remove(entry.getObjectName(), listener, filter, handback);
        }
        finally {
            if (setCl) {
                TCLAction.UTIL.setContextClassLoader(oldTCL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        MBeanEntry entry = this.registry.get(name);
        if (!NotificationBroadcaster.class.isInstance(entry.getResourceInstance())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + name + " exists but does not implement the NotificationBroadcaster interface."));
        }
        MBeanEntry listenerEntry = this.registry.get(listener);
        if (!NotificationListener.class.isInstance(listenerEntry.getResourceInstance())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + listener + " exists but does not implement the NotificationListener interface."));
        }
        this.checkMBeanPermission(entry.getResourceClassName(), null, name, "removeNotificationListener");
        ClassLoader newTCL = entry.getClassLoader();
        ClassLoader oldTCL = TCLAction.UTIL.getContextClassLoader();
        boolean setCl = newTCL != oldTCL && newTCL != null;
        try {
            if (setCl) {
                TCLAction.UTIL.setContextClassLoader(newTCL);
            }
            this.listeners.remove(entry.getObjectName(), (NotificationListener)this.registry.get(listener).getResourceInstance(), filter, handback);
        }
        finally {
            if (setCl) {
                TCLAction.UTIL.setContextClassLoader(oldTCL);
            }
        }
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        MBeanEntry entry = this.registry.get(name);
        String mbeanClassName = entry.getResourceClassName();
        this.checkMBeanPermission(mbeanClassName, null, name, "isInstanceOf");
        if (className.equals(mbeanClassName)) {
            return true;
        }
        Class<?> mbeanClass = null;
        Class<?> testClass = null;
        ClassLoader cl = this.getClassLoaderFor(name);
        try {
            mbeanClass = cl.loadClass(mbeanClassName);
            testClass = cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return testClass.isAssignableFrom(mbeanClass);
    }

    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        try {
            ClassLoader cl = this.getClassLoaderFor(name);
            return new ObjectInputStreamWithClassLoader(new ByteArrayInputStream(data), cl);
        }
        catch (IOException e) {
            throw new OperationsException("I/O exception deserializing: " + e.getMessage());
        }
    }

    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        try {
            Class<?> c = this.getClassLoaderRepository().loadClass(className);
            ClassLoader cl = c.getClassLoader();
            return new ObjectInputStreamWithClassLoader(new ByteArrayInputStream(data), cl);
        }
        catch (IOException e) {
            throw new OperationsException("I/O exception deserializing: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e, "Class not found from default repository: " + className);
        }
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        try {
            ClassLoader cl = this.getClassLoader(loaderName);
            return new ObjectInputStreamWithClassLoader(new ByteArrayInputStream(data), cl);
        }
        catch (IOException e) {
            throw new OperationsException("I/O exception deserializing: " + e.getMessage());
        }
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws InstanceNotFoundException {
        MBeanEntry entry = this.registry.get(name);
        this.checkMBeanPermission(entry.getResourceClassName(), null, name, "getClassLoaderFor");
        ClassLoader cl = entry.getClassLoader();
        if (cl == null) {
            cl = entry.getResourceInstance().getClass().getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    public ClassLoader getClassLoader(ObjectName name) throws InstanceNotFoundException {
        Object loader = null;
        if (name == null) {
            this.checkMBeanPermission(null, null, name, "getClassLoader");
            loader = this.getClass().getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
        } else {
            MBeanEntry entry = this.registry.get(name);
            this.checkMBeanPermission(entry.getResourceClassName(), null, name, "getClassLoader");
            loader = entry.getResourceInstance();
        }
        if (!(loader instanceof ClassLoader)) {
            throw new InstanceNotFoundException("Not a classloader " + name);
        }
        return (ClassLoader)loader;
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        this.checkMBeanPermission(null, null, null, "getClassLoaderRepository");
        if (this.classLoaderRepository == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String className = PropertyAccess.getProperty("jbossmx.loader.repository.class", "org.jboss.mx.loading.UnifiedLoaderRepository3");
            PropertyAccess.setProperty("jbossmx.loader.repository.class", className);
            try {
                Class<?> repository = cl.loadClass(className);
                this.classLoaderRepository = (LoaderRepository)repository.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new Error("Cannot instantiate loader repository class: " + className);
            }
            catch (ClassCastException e) {
                throw new Error("Loader repository is not an instance of LoaderRepository: " + className);
            }
            catch (Exception e) {
                throw new Error("Error creating loader repository: " + e);
            }
        }
        return this.classLoaderRepository;
    }

    public void releaseServer() {
        this.registry.releaseRegistry();
        this.listeners.removeAll();
        this.listeners = null;
        this.registry = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object instantiate(String className, ClassLoader cl, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        if (className == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null className"));
        }
        if (className.equals("")) {
            throw new ReflectionException(new ClassNotFoundException("empty class name"));
        }
        if (params == null) {
            params = NOPARAMS;
        }
        if (signature == null) {
            signature = NOSIG;
        }
        this.checkMBeanPermission(className, null, null, "instantiate");
        ClassLoader oldTCL = TCLAction.UTIL.getContextClassLoader();
        boolean setCl = false;
        try {
            Class<?> clazz = null;
            if (cl != null) {
                if (cl != oldTCL) {
                    setCl = true;
                    TCLAction.UTIL.setContextClassLoader(cl);
                }
                clazz = cl.loadClass(className);
            } else {
                clazz = this.classLoaderRepository.loadClass(className);
            }
            Class[] sign = new Class[signature.length];
            for (int i = 0; i < signature.length; ++i) {
                if (LoaderRepository.getNativeClassForName(signature[i]) == null) {
                    try {
                        if (cl != null) {
                            sign[i] = cl.loadClass(signature[i]);
                            continue;
                        }
                        sign[i] = this.classLoaderRepository.loadClass(signature[i]);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new ReflectionException(e, "Constructor parameter class not found: " + signature[i]);
                    }
                }
                sign[i] = LoaderRepository.getNativeClassForName(signature[i]);
            }
            Constructor<?> constructor = clazz.getConstructor(sign);
            Object obj = constructor.newInstance(params);
            return obj;
        }
        catch (Throwable t) {
            this.handleInstantiateExceptions(t, className);
            log.error("Unhandled exception instantiating class: " + className, t);
            Object var8_10 = null;
            return var8_10;
        }
        finally {
            if (setCl) {
                TCLAction.UTIL.setContextClassLoader(oldTCL);
            }
        }
    }

    protected void handleInstantiateExceptions(Throwable t, String className) throws ReflectionException, MBeanException {
        if (t instanceof ReflectionException) {
            throw (ReflectionException)t;
        }
        if (t instanceof ClassNotFoundException) {
            throw new ReflectionException((Exception)t, "Class not found: " + className);
        }
        if (t instanceof InstantiationException) {
            throw new ReflectionException((Exception)t, "Cannot instantiate: " + className);
        }
        if (t instanceof IllegalAccessException) {
            throw new ReflectionException((Exception)t, "Illegal access to constructor: " + className);
        }
        if (t instanceof NoSuchMethodException) {
            throw new ReflectionException((Exception)t, "Cannot find such a public constructor: " + className);
        }
        if (t instanceof SecurityException) {
            throw new ReflectionException((Exception)t, "Can't access constructor for " + className);
        }
        if (t instanceof InvocationTargetException) {
            Throwable root = ((InvocationTargetException)t).getTargetException();
            if (root instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)root, className + " constructor has thrown an exception: " + root.toString());
            }
            if (root instanceof Error) {
                throw new RuntimeErrorException((Error)root, className + " constructor has thrown an error: " + root.toString());
            }
            if (root instanceof Exception) {
                throw new MBeanException((Exception)root, className + " constructor has thrown an exception: " + root.toString());
            }
            throw new Error("Something went wrong with handling the exception from " + className + " default constructor.");
        }
        if (t instanceof ExceptionInInitializerError) {
            Throwable root = ((ExceptionInInitializerError)t).getException();
            if (root instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)root, "Exception in class " + className + " static initializer: " + root.toString());
            }
            throw new Error("ERROR: it turns out the root cause is not always a runtime exception!");
        }
        if (t instanceof IllegalArgumentException) {
            throw new Error("Error in the server: mismatch between expected constructor arguments and supplied arguments.");
        }
        if (t instanceof Error) {
            throw new RuntimeErrorException((Error)t, "instantiating " + className + " failed: " + t.toString());
        }
    }

    protected ObjectInstance registerMBean(Object mbean, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ClassLoader cl = null;
        if (loaderName == null) {
            cl = this.getClass().getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
        } else {
            try {
                cl = (ClassLoader)this.registry.get(loaderName).getResourceInstance();
            }
            catch (ClassCastException e) {
                throw new ReflectionException(e, loaderName + " is not a class loader.");
            }
        }
        return this.registerMBean(mbean, name, cl);
    }

    protected ObjectInstance registerMBean(Object object, ObjectName name, ClassLoader cl) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        MBeanTrustPermission p;
        ProtectionDomain pd;
        final Class<?> objectClass = object.getClass();
        String className = objectClass.getName();
        this.checkMBeanPermission(className, null, name, "registerMBean");
        if (System.getSecurityManager() != null && (pd = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return objectClass.getProtectionDomain();
            }
        })) != null && !pd.implies(p = new MBeanTrustPermission("register"))) {
            String msg = "MBeanTrustPermission(register) not implied by protection domain of mbean class: " + className + ", pd: " + pd;
            throw new SecurityException(msg);
        }
        HashMap<String, ClassLoader> valueMap = null;
        if (cl != null) {
            valueMap = new HashMap<String, ClassLoader>();
            valueMap.put("org.jboss.mx.classloader", cl);
        }
        try {
            final Object[] args = new Object[]{object, name, valueMap};
            final String[] sig = new String[]{Object.class.getName(), ObjectName.class.getName(), Map.class.getName()};
            try {
                ObjectInstance oi = (ObjectInstance)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return MBeanServerImpl.this.invoke(new ObjectName("JMImplementation:type=MBeanRegistry"), "registerMBean", args, sig);
                    }
                });
                return oi;
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        catch (Throwable t2) {
            Exception t2;
            Throwable result = JMXExceptionDecoder.decodeToJMXException(t2);
            if (result instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)result;
            }
            if (result instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)result;
            }
            if (result instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)result;
            }
            if (result instanceof JMRuntimeException) {
                throw (JMRuntimeException)result;
            }
            if (result instanceof MBeanException) {
                MBeanException e = (MBeanException)result;
                t2 = e.getTargetException();
                if (t2 instanceof InstanceAlreadyExistsException) {
                    throw (InstanceAlreadyExistsException)t2;
                }
                if (t2 instanceof MBeanRegistrationException) {
                    throw (MBeanRegistrationException)t2;
                }
                if (t2 instanceof NotCompliantMBeanException) {
                    throw (NotCompliantMBeanException)t2;
                }
            }
            if (result instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)result);
            }
            if (result instanceof Error) {
                throw new RuntimeErrorException((Error)result);
            }
            throw new MBeanRegistrationException(new InvocationTargetException(t2), "Cannot register MBean");
        }
    }

    protected boolean queryMBean(ObjectName objectName, QueryExp queryExp) {
        if (queryExp == null) {
            return true;
        }
        try {
            return queryExp.apply(objectName);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected MBeanRegistry createRegistry(String defaultDomain) {
        String registryClass = PropertyAccess.getProperty("jbossmx.mbean.registry.class", "org.jboss.mx.server.registry.BasicMBeanRegistry");
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = cl.loadClass(registryClass);
            Constructor<?> constructor = clazz.getConstructor(MBeanServer.class, String.class, ClassLoaderRepository.class);
            return (MBeanRegistry)constructor.newInstance(this.outer, defaultDomain, this.classLoaderRepository);
        }
        catch (ClassNotFoundException e) {
            throw new NestedRuntimeException("The MBean registry implementation class " + registryClass + " was not found: ", e);
        }
        catch (NoSuchMethodException e) {
            throw new NestedRuntimeException("The MBean registry implementation class " + registryClass + " must contain a default <init>(MBeanServer srvr, String domain) " + " constructor.", e);
        }
        catch (InstantiationException e) {
            throw new NestedRuntimeException("Cannot instantiate class " + registryClass + ": ", e);
        }
        catch (IllegalAccessException e) {
            throw new NestedRuntimeException("Unable to create the MBean registry instance. Illegal access to class " + registryClass + " constructor: ", e);
        }
        catch (InvocationTargetException e) {
            throw new NestedRuntimeException("Unable to create the MBean registry instance. Class " + registryClass + " has raised an exception in constructor: ", e.getTargetException());
        }
    }

    private ModelMBeanInfo getRegistryManagementInterface() {
        boolean READABLE = true;
        boolean WRITABLE = true;
        boolean BOOLEAN = true;
        DescriptorSupport descDefaultDomain = new DescriptorSupport();
        descDefaultDomain.setField("name", "DefaultDomain");
        descDefaultDomain.setField("descriptorType", "attribute");
        descDefaultDomain.setField("displayName", "Default Domain");
        descDefaultDomain.setField("default", this.getDefaultDomain());
        descDefaultDomain.setField("currencyTimeLimit", "-1");
        ModelMBeanAttributeInfo defaultDomainInfo = new ModelMBeanAttributeInfo("DefaultDomain", String.class.getName(), "The domain to use when an object name has no domain", true, false, false, descDefaultDomain);
        DescriptorSupport descSize = new DescriptorSupport();
        descSize.setField("name", "Size");
        descSize.setField("descriptorType", "attribute");
        descSize.setField("displayName", "Size");
        descSize.setField("getMethod", "getSize");
        ModelMBeanAttributeInfo sizeInfo = new ModelMBeanAttributeInfo("Size", Integer.TYPE.getName(), "The number of MBeans registered in the MBean Server", true, false, false, descSize);
        DescriptorSupport descRegisterMBean = new DescriptorSupport();
        descRegisterMBean.setField("name", "registerMBean");
        descRegisterMBean.setField("descriptorType", "operation");
        descRegisterMBean.setField("role", "operation");
        MBeanParameterInfo[] registerMBeanParms = new MBeanParameterInfo[]{new MBeanParameterInfo("Resource", Object.class.getName(), "A compliant MBean to be registered in the MBean Server"), new MBeanParameterInfo("ObjectName", ObjectName.class.getName(), "The object name of the MBean"), new MBeanParameterInfo("ValueMap", Map.class.getName(), "Values associated with the registration")};
        ModelMBeanOperationInfo registerMBeanInfo = new ModelMBeanOperationInfo("registerMBean", "Adds an MBean in the MBeanServer", registerMBeanParms, ObjectInstance.class.getName(), 2, descRegisterMBean);
        DescriptorSupport descUnregisterMBean = new DescriptorSupport();
        descUnregisterMBean.setField("name", "unregisterMBean");
        descUnregisterMBean.setField("descriptorType", "operation");
        descUnregisterMBean.setField("role", "operation");
        MBeanParameterInfo[] unregisterMBeanParms = new MBeanParameterInfo[]{new MBeanParameterInfo("ObjectName", ObjectName.class.getName(), "The object name of the MBean to remove")};
        ModelMBeanOperationInfo unregisterMBeanInfo = new ModelMBeanOperationInfo("unregisterMBean", "Removes an MBean from the MBeanServer", unregisterMBeanParms, Void.TYPE.getName(), 1, descUnregisterMBean);
        DescriptorSupport descGetSize = new DescriptorSupport();
        descGetSize.setField("name", "getSize");
        descGetSize.setField("descriptorType", "operation");
        descGetSize.setField("role", "getter");
        MBeanParameterInfo[] getSizeParms = new MBeanParameterInfo[]{};
        ModelMBeanOperationInfo getSizeInfo = new ModelMBeanOperationInfo("getSize", "Gets the number of MBeans registered", getSizeParms, Integer.TYPE.getName(), 0, descGetSize);
        DescriptorSupport descGet = new DescriptorSupport();
        descGet.setField("name", "get");
        descGet.setField("descriptorType", "operation");
        descGet.setField("role", "operation");
        MBeanParameterInfo[] getParam = new MBeanParameterInfo[]{new MBeanParameterInfo("ObjectName", ObjectName.class.getName(), "object name to find")};
        ModelMBeanOperationInfo getInfo = new ModelMBeanOperationInfo("get", "Gets the MBeanEntry for a given ObjectName", getParam, MBeanEntry.class.getName(), 0, descGet);
        DescriptorSupport descGetValue = new DescriptorSupport();
        descGetValue.setField("name", "getValue");
        descGetValue.setField("descriptorType", "operation");
        descGetValue.setField("role", "operation");
        MBeanParameterInfo[] getValueParms = new MBeanParameterInfo[]{new MBeanParameterInfo("ObjectName", ObjectName.class.getName(), "The object name of the registered MBean"), new MBeanParameterInfo("Key", String.class.getName(), "The key to the value stored")};
        ModelMBeanOperationInfo getValueInfo = new ModelMBeanOperationInfo("getValue", "Get a value stored in the MBean's registration", getValueParms, Object.class.getName(), 0, descGetValue);
        DescriptorSupport descMBean = new DescriptorSupport();
        descMBean.setField("name", RequiredModelMBeanInstantiator.getClassName());
        descMBean.setField("descriptorType", "MBean");
        descMBean.setField("displayName", "MBeanServer Registry");
        ModelMBeanAttributeInfo[] attrInfo = new ModelMBeanAttributeInfo[]{defaultDomainInfo, sizeInfo};
        ModelMBeanConstructorInfo[] ctorInfo = null;
        ModelMBeanOperationInfo[] opInfo = new ModelMBeanOperationInfo[]{registerMBeanInfo, unregisterMBeanInfo, getSizeInfo, getValueInfo, getInfo};
        ModelMBeanNotificationInfo[] notifyInfo = null;
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(RequiredModelMBeanInstantiator.getClassName(), "Managed Bean Registry", attrInfo, ctorInfo, opInfo, notifyInfo, (Descriptor)descMBean);
        return info;
    }

    private void checkMBeanPermission(String className, String member, ObjectName objectName, String action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            MBeanPermission p = new MBeanPermission(className, member, objectName, action);
            sm.checkPermission(p);
        }
    }

    public String toString() {
        return super.toString() + "[ defaultDomain='" + this.getDefaultDomain() + "' ]";
    }
}

