/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.jmx;

import java.util.Set;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.jboss.jms.server.JMSConditionFactory;
import org.jboss.jms.server.ServerPeer;
import org.jboss.jms.server.selector.SelectorFactory;
import org.jboss.messaging.core.contract.ChannelFactory;
import org.jboss.messaging.core.contract.ClusterNotifier;
import org.jboss.messaging.core.contract.MessageStore;
import org.jboss.messaging.core.contract.MessagingComponent;
import org.jboss.messaging.core.contract.PersistenceManager;
import org.jboss.messaging.core.impl.IDManager;
import org.jboss.messaging.core.impl.jchannelfactory.MultiplexerChannelFactory;
import org.jboss.messaging.core.impl.jchannelfactory.XMLChannelFactory;
import org.jboss.messaging.core.impl.postoffice.MessagingPostOffice;
import org.jboss.messaging.core.impl.tx.TransactionRepository;
import org.jboss.messaging.core.jmx.JDBCServiceSupport;
import org.jboss.messaging.util.ExceptionUtil;
import org.jboss.messaging.util.JMXAccessor;
import org.w3c.dom.Element;

public class MessagingPostOfficeService
extends JDBCServiceSupport {
    private boolean started;
    private Element controlChannelConfig;
    private Element dataChannelConfig;
    private ObjectName channelFactoryName;
    private String controlChannelName;
    private String dataChannelName;
    private String channelPartitionName;
    private ObjectName serverPeerObjectName;
    private String officeName;
    private long stateTimeout = 5000L;
    private long castTimeout = 5000L;
    private String groupName;
    private boolean clustered;
    private int maxConcurrentReplications = 25;
    private MessagingPostOffice postOffice;

    public MessagingComponent getInstance() {
        return this.postOffice;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object object) throws IllegalArgumentException {
        this.postOffice.addNotificationListener(listener, filter, object);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.postOffice.removeNotificationListener(listener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.postOffice.getNotificationInfo();
    }

    public synchronized ObjectName getServerPeer() {
        return this.serverPeerObjectName;
    }

    public synchronized void setServerPeer(ObjectName on) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.serverPeerObjectName = on;
    }

    public synchronized String getPostOfficeName() {
        return this.officeName;
    }

    public synchronized void setPostOfficeName(String name) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.officeName = name;
    }

    public ObjectName getChannelFactoryName() {
        return this.channelFactoryName;
    }

    public void setChannelFactoryName(ObjectName channelFactoryName) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.channelFactoryName = channelFactoryName;
    }

    public String getControlChannelName() {
        return this.controlChannelName;
    }

    public void setControlChannelName(String controlChannelName) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.controlChannelName = controlChannelName;
    }

    public String getDataChannelName() {
        return this.dataChannelName;
    }

    public void setDataChannelName(String dataChannelName) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.dataChannelName = dataChannelName;
    }

    public String getChannelPartitionName() {
        return this.channelPartitionName;
    }

    public void setChannelPartitionName(String channelPartitionName) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.channelPartitionName = channelPartitionName;
    }

    public void setControlChannelConfig(Element config) throws Exception {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.controlChannelConfig = config;
    }

    public Element getControlChannelConfig() {
        return this.controlChannelConfig;
    }

    public void setDataChannelConfig(Element config) throws Exception {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.dataChannelConfig = config;
    }

    public Element getDataChannelConfig() {
        return this.dataChannelConfig;
    }

    public void setStateTimeout(long timeout) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.stateTimeout = timeout;
    }

    public long getStateTimeout() {
        return this.stateTimeout;
    }

    public void setCastTimeout(long timeout) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.castTimeout = timeout;
    }

    public long getCastTimeout() {
        return this.castTimeout;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean clustered) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.clustered = clustered;
    }

    public int getMaxConcurrentReplications() {
        return this.maxConcurrentReplications;
    }

    public void setMaxConcurrentReplications(int number) {
        this.maxConcurrentReplications = number;
    }

    public String listBindings() {
        return this.postOffice.printBindingInformation();
    }

    public Set getNodeIDView() {
        return this.postOffice.nodeIDView();
    }

    protected synchronized void startService() throws Exception {
        if (this.started) {
            throw new IllegalStateException("Service is already started");
        }
        super.startService();
        try {
            TransactionManager tm = this.getTransactionManagerReference();
            ServerPeer serverPeer = (ServerPeer)JMXAccessor.getJMXAttributeOverSecurity(this.server, this.serverPeerObjectName, "Instance");
            MessageStore ms = serverPeer.getMessageStore();
            PersistenceManager pm = serverPeer.getPersistenceManagerInstance();
            TransactionRepository tr = serverPeer.getTxRepository();
            IDManager idManager = serverPeer.getChannelIDManager();
            int nodeId = serverPeer.getServerPeerID();
            ClusterNotifier clusterNotifier = serverPeer.getClusterNotifier();
            JMSConditionFactory cf = new JMSConditionFactory();
            SelectorFactory ff = new SelectorFactory();
            if (this.clustered) {
                ChannelFactory jChannelFactory = null;
                if (this.channelFactoryName != null) {
                    MBeanInfo info = null;
                    try {
                        info = this.server.getMBeanInfo(this.channelFactoryName);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (info != null) {
                        this.log.debug(this + " uses MultiplexerJChannelFactory");
                        jChannelFactory = new MultiplexerChannelFactory(this.server, this.channelFactoryName, this.channelPartitionName, this.controlChannelName, this.dataChannelName);
                    } else {
                        this.log.debug(this + " uses XMLJChannelFactory");
                        jChannelFactory = new XMLChannelFactory(this.controlChannelConfig, this.dataChannelConfig);
                    }
                } else {
                    this.log.debug(this + " uses XMLJChannelFactory");
                    jChannelFactory = new XMLChannelFactory(this.controlChannelConfig, this.dataChannelConfig);
                }
                this.postOffice = new MessagingPostOffice(this.ds, tm, this.sqlProperties, this.createTablesOnStartup, nodeId, this.officeName, ms, pm, tr, ff, cf, idManager, clusterNotifier, this.groupName, jChannelFactory, this.stateTimeout, this.castTimeout, serverPeer.isSupportsFailover(), this.maxConcurrentReplications);
            } else {
                this.postOffice = new MessagingPostOffice(this.ds, tm, this.sqlProperties, this.createTablesOnStartup, nodeId, this.officeName, ms, pm, tr, ff, cf, idManager, clusterNotifier);
            }
            this.postOffice.start();
            this.started = true;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
        }
    }

    protected void stopService() throws Exception {
        if (!this.started) {
            throw new IllegalStateException("Service is not started");
        }
        super.stopService();
        try {
            this.postOffice.stop();
            this.postOffice = null;
            this.started = false;
            this.log.debug(this + " stopped");
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
        }
    }
}

