/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.message;

import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Message;
import org.jboss.messaging.core.contract.MessageReference;

public class SimpleMessageReference
implements MessageReference {
    private static final Logger log = Logger.getLogger(SimpleMessageReference.class);
    private boolean trace = log.isTraceEnabled();
    private long pagingOrder = -1L;
    private int deliveryCount;
    private long scheduledDeliveryTime;
    private Message message;

    public SimpleMessageReference() {
        if (this.trace) {
            log.trace("Creating using default constructor");
        }
    }

    public SimpleMessageReference(SimpleMessageReference other) {
        this.pagingOrder = other.pagingOrder;
        this.deliveryCount = other.deliveryCount;
        this.scheduledDeliveryTime = other.scheduledDeliveryTime;
        this.message = other.message;
    }

    protected SimpleMessageReference(Message message) {
        this.message = message;
    }

    public MessageReference copy() {
        return new SimpleMessageReference(this);
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    public void setDeliveryCount(int deliveryCount) {
        this.deliveryCount = deliveryCount;
    }

    public long getScheduledDeliveryTime() {
        return this.scheduledDeliveryTime;
    }

    public void setScheduledDeliveryTime(long scheduledDeliveryTime) {
        this.scheduledDeliveryTime = scheduledDeliveryTime;
    }

    public Message getMessage() {
        return this.message;
    }

    public long getPagingOrder() {
        return this.pagingOrder;
    }

    public void setPagingOrder(long order) {
        this.pagingOrder = order;
    }

    public String toString() {
        return "Reference[" + this.getMessage().getMessageID() + "]:" + (this.getMessage().isReliable() ? "RELIABLE" : "NON-RELIABLE");
    }
}

