/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.lazy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.lazy.AbstractLazyInitializer;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.registry.KernelBus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKLazyInitializer
extends AbstractLazyInitializer {
    @Override
    public Object initializeProxy(Kernel kernel, String bean, boolean exposeClass, Set<String> interfaces) throws Throwable {
        if (exposeClass) {
            throw new IllegalArgumentException("Cannot expose class via JDK LazyInitializer.");
        }
        if (interfaces == null || interfaces.isEmpty()) {
            throw new IllegalArgumentException("Null interfaces.");
        }
        KernelControllerContext context = this.getKernelControllerContext(kernel, bean);
        BeanInfo beanInfo = context.getBeanInfo();
        if (beanInfo == null) {
            throw new IllegalArgumentException("Cannot proxy factory beans.");
        }
        LazyHandler lazyHandler = new LazyHandler(bean, kernel.getBus(), beanInfo.getClassInfo().getType());
        ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), JDKLazyInitializer.getClasses(kernel.getConfigurator(), interfaces, cl), (InvocationHandler)lazyHandler);
    }

    public class LazyHandler
    extends AbstractLazyInitializer.AbstractInvokeHandler
    implements InvocationHandler {
        public LazyHandler(String bean, KernelBus bus, Class proxyClass) {
            super(bean, bus, proxyClass);
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.executeInvoke(proxy, method, args);
        }
    }
}

