/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.beans.metadata.api.annotations.Factory;
import org.jboss.beans.metadata.api.annotations.Value;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.kernel.plugins.annotations.AbstractAdaptersAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.Annotation2ValueMetaDataAdapter;
import org.jboss.kernel.plugins.annotations.ValueUtil;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.ClassInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFactoryAnnotationPlugin
extends AbstractAdaptersAnnotationPlugin<ClassInfo, Factory> {
    protected ClassFactoryAnnotationPlugin(Annotation2ValueMetaDataAdapter ... adapters) {
        super(Factory.class, adapters);
    }

    @Override
    protected boolean isElementTypeSupported(ElementType type) {
        return ElementType.TYPE == type;
    }

    @Override
    protected boolean isMetaDataAlreadyPresent(ClassInfo info, Factory annotation, BeanMetaData beanMetaData) {
        return beanMetaData.getConstructor() != null;
    }

    @Override
    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(ClassInfo info, Factory annotation, KernelControllerContext context) throws Throwable {
        AbstractBeanMetaData bean = (AbstractBeanMetaData)context.getBeanMetaData();
        AbstractConstructorMetaData constructor = new AbstractConstructorMetaData();
        if (ClassFactoryAnnotationPlugin.isAttributePresent(annotation.factoryClass())) {
            constructor.setFactoryClass(annotation.factoryClass());
        } else {
            constructor.setFactory(ValueUtil.createValueMetaData(annotation.factory()));
        }
        constructor.setFactoryMethod(annotation.factoryMethod());
        if (annotation.parameters().length > 0) {
            ArrayList<ParameterMetaData> parameters = new ArrayList<ParameterMetaData>();
            for (Value parameter : annotation.parameters()) {
                AbstractParameterMetaData apmd = new AbstractParameterMetaData(ValueUtil.createValueMetaData(parameter));
                if (ClassFactoryAnnotationPlugin.isAttributePresent(parameter.type())) {
                    apmd.setType(parameter.type());
                }
                parameters.add(apmd);
            }
            constructor.setParameters(parameters);
        }
        bean.setConstructor(constructor);
        return Collections.singletonList(constructor);
    }
}

