/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.recovery;

import com.arjuna.ats.jta.recovery.XAResourceRecovery;
import java.util.StringTokenizer;
import javax.transaction.xa.XAResource;
import org.jboss.jms.server.recovery.MessagingXAResourceWrapper;
import org.jboss.logging.Logger;

public class MessagingXAResourceRecovery
implements XAResourceRecovery {
    private boolean trace = log.isTraceEnabled();
    private static final Logger log = Logger.getLogger(MessagingXAResourceRecovery.class);
    private String providerAdaptorName;
    private boolean hasMore;
    private String username;
    private String password;
    private MessagingXAResourceWrapper res;

    public MessagingXAResourceRecovery() {
        if (this.trace) {
            log.trace("Constructing BridgeXAResourceRecovery");
        }
    }

    public boolean initialise(String config) {
        StringTokenizer tok;
        if (log.isTraceEnabled()) {
            log.trace(this + " intialise: " + config);
        }
        if (!(tok = new StringTokenizer(config, ",")).hasMoreTokens()) {
            throw new IllegalArgumentException("Must specify provider adaptor name in config");
        }
        this.providerAdaptorName = tok.nextToken();
        if (tok.hasMoreTokens()) {
            this.username = tok.nextToken();
            if (!tok.hasMoreTokens()) {
                throw new IllegalArgumentException("If username is specified, password must be specified too");
            }
            this.password = tok.nextToken();
        }
        this.res = new MessagingXAResourceWrapper(this.providerAdaptorName, this.username, this.password);
        if (log.isTraceEnabled()) {
            log.trace(this + " initialised");
        }
        return true;
    }

    public boolean hasMoreResources() {
        if (log.isTraceEnabled()) {
            log.trace(this + " hasMoreResources");
        }
        this.hasMore = !this.hasMore;
        return this.hasMore;
    }

    public XAResource getXAResource() {
        if (log.isTraceEnabled()) {
            log.trace(this + " getXAResource");
        }
        return this.res;
    }

    protected void finalize() {
        this.res.close();
    }
}

