/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.message;

import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import org.jboss.jms.message.MessageIdGenerator;
import org.jboss.logging.Logger;

public class MessageIdGeneratorFactory {
    private static final Logger log = Logger.getLogger(MessageIdGeneratorFactory.class);
    public static MessageIdGeneratorFactory instance = new MessageIdGeneratorFactory();
    private static final int BLOCK_SIZE = 512;
    private Map holders = new HashMap();

    private MessageIdGeneratorFactory() {
    }

    public synchronized boolean containsMessageIdGenerator(int serverId) {
        return this.holders.containsKey(new Integer(serverId));
    }

    public synchronized MessageIdGenerator checkOutGenerator(int serverId) throws JMSException {
        Integer in = new Integer(serverId);
        Holder h = (Holder)this.holders.get(in);
        if (h == null) {
            h = new Holder(new MessageIdGenerator(512));
            this.holders.put(in, h);
        } else {
            ++h.refCount;
        }
        log.trace("checked out MessageIdGenerator for " + serverId + ", reference count is " + h.refCount);
        return h.generator;
    }

    public synchronized void checkInGenerator(int serverId) {
        Integer in = new Integer(serverId);
        Holder h = (Holder)this.holders.get(in);
        if (h == null) {
            throw new IllegalArgumentException("Cannot find generator for serverid:" + serverId);
        }
        --h.refCount;
        if (h.refCount == 0) {
            this.holders.remove(in);
            log.trace("checked in and removed MessageIdGenerator for " + serverId);
        } else {
            log.trace("checked in MessageIdGenerator for " + serverId + ", reference count is " + h.refCount);
        }
    }

    public synchronized void clear() {
        this.holders.clear();
        log.trace("cleared MessageIdGeneratorFactory");
    }

    private class Holder {
        MessageIdGenerator generator;
        int refCount = 1;

        private Holder(MessageIdGenerator gen) {
            this.generator = gen;
        }
    }
}

