/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.message;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.jboss.jms.message.JBossBytesMessage;
import org.jboss.jms.message.MessageProxy;

public class BytesMessageProxy
extends MessageProxy
implements BytesMessage {
    private static final long serialVersionUID = -9121097962625801946L;

    public BytesMessageProxy(long deliveryId, JBossBytesMessage message, int deliveryCount) {
        super(deliveryId, message, deliveryCount);
    }

    public BytesMessageProxy(JBossBytesMessage message) {
        super(message);
    }

    public long getBodyLength() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((BytesMessage)((Object)this.message)).getBodyLength();
    }

    public boolean readBoolean() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((BytesMessage)((Object)this.message)).readBoolean();
    }

    public byte readByte() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((BytesMessage)((Object)this.message)).readByte();
    }

    public int readUnsignedByte() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((BytesMessage)((Object)this.message)).readUnsignedByte();
    }

    public short readShort() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((BytesMessage)((Object)this.message)).readShort();
    }

    public int readUnsignedShort() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((BytesMessage)((Object)this.message)).readUnsignedShort();
    }

    public char readChar() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((BytesMessage)((Object)this.message)).readChar();
    }

    public int readInt() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((BytesMessage)((Object)this.message)).readInt();
    }

    public long readLong() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((BytesMessage)((Object)this.message)).readLong();
    }

    public float readFloat() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((BytesMessage)((Object)this.message)).readFloat();
    }

    public double readDouble() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((BytesMessage)((Object)this.message)).readDouble();
    }

    public String readUTF() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((BytesMessage)((Object)this.message)).readUTF();
    }

    public int readBytes(byte[] value) throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((BytesMessage)((Object)this.message)).readBytes(value);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((BytesMessage)((Object)this.message)).readBytes(value, length);
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        this.bodyChange();
        ((BytesMessage)((Object)this.message)).writeBoolean(value);
    }

    public void writeByte(byte value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        this.bodyChange();
        ((BytesMessage)((Object)this.message)).writeByte(value);
    }

    public void writeShort(short value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        this.bodyChange();
        ((BytesMessage)((Object)this.message)).writeShort(value);
    }

    public void writeChar(char value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        this.bodyChange();
        ((BytesMessage)((Object)this.message)).writeChar(value);
    }

    public void writeInt(int value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        this.bodyChange();
        ((BytesMessage)((Object)this.message)).writeInt(value);
    }

    public void writeLong(long value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        this.bodyChange();
        ((BytesMessage)((Object)this.message)).writeLong(value);
    }

    public void writeFloat(float value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        this.bodyChange();
        ((BytesMessage)((Object)this.message)).writeFloat(value);
    }

    public void writeDouble(double value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        this.bodyChange();
        ((BytesMessage)((Object)this.message)).writeDouble(value);
    }

    public void writeUTF(String value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        this.bodyChange();
        ((BytesMessage)((Object)this.message)).writeUTF(value);
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        this.bodyChange();
        ((BytesMessage)((Object)this.message)).writeBytes(value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        this.bodyChange();
        ((BytesMessage)((Object)this.message)).writeBytes(value, offset, length);
    }

    public void writeObject(Object value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("the message body is read-only");
        }
        this.bodyChange();
        ((BytesMessage)((Object)this.message)).writeObject(value);
    }

    public void reset() throws JMSException {
        ((BytesMessage)((Object)this.message)).reset();
        this.bodyReadOnly = true;
    }
}

