/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import org.jboss.jms.client.FailoverListener;
import org.jboss.jms.client.JBossSession;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.jms.delegate.ConnectionDelegate;
import org.jboss.jms.delegate.SessionDelegate;

public class JBossConnection
implements Connection,
QueueConnection,
TopicConnection,
XAConnection,
XAQueueConnection,
XATopicConnection,
Serializable {
    private static final long serialVersionUID = -3715868654823177898L;
    static final int TYPE_GENERIC_CONNECTION = 0;
    static final int TYPE_QUEUE_CONNECTION = 1;
    static final int TYPE_TOPIC_CONNECTION = 2;
    protected ConnectionDelegate delegate;
    private int connectionType;

    public JBossConnection(ConnectionDelegate delegate, int connectionType) {
        this.delegate = delegate;
        this.connectionType = connectionType;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createSessionInternal(transacted, acknowledgeMode, false, 0);
    }

    public String getClientID() throws JMSException {
        return this.delegate.getClientID();
    }

    public void setClientID(String clientID) throws JMSException {
        this.delegate.setClientID(clientID);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.delegate.getConnectionMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.delegate.getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.delegate.setExceptionListener(listener);
    }

    public void start() throws JMSException {
        this.delegate.start();
    }

    public void stop() throws JMSException {
        this.delegate.stop();
    }

    public void close() throws JMSException {
        this.delegate.closing(-1L);
        this.delegate.close();
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.delegate.createConnectionConsumer(destination, null, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.connectionType == 1) {
            String msg = "Cannot create a durable connection consumer on a QueueConnection";
            throw new IllegalStateException(msg);
        }
        return this.delegate.createConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createSessionInternal(transacted, acknowledgeMode, false, 1);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.delegate.createConnectionConsumer(queue, null, messageSelector, sessionPool, maxMessages);
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createSessionInternal(transacted, acknowledgeMode, false, 2);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.delegate.createConnectionConsumer(topic, null, messageSelector, sessionPool, maxMessages);
    }

    public XASession createXASession() throws JMSException {
        return this.createSessionInternal(true, 0, true, 0);
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        return this.createSessionInternal(true, 0, true, 1);
    }

    public XATopicSession createXATopicSession() throws JMSException {
        return this.createSessionInternal(true, 0, true, 2);
    }

    public String getRemotingClientSessionID() {
        ConnectionState state = (ConnectionState)((ClientConnectionDelegate)this.delegate).getState();
        return state.getRemotingConnection().getRemotingClient().getSessionId();
    }

    public ConnectionDelegate getDelegate() {
        return this.delegate;
    }

    public int getServerID() {
        return ((ConnectionState)((DelegateSupport)((Object)this.delegate)).getState()).getServerID();
    }

    public void registerFailoverListener(FailoverListener listener) {
        this.delegate.registerFailoverListener(listener);
    }

    public synchronized boolean unregisterFailoverListener(FailoverListener listener) {
        return this.delegate.unregisterFailoverListener(listener);
    }

    public String toString() {
        return "JBossConnection->" + this.delegate;
    }

    protected JBossSession createSessionInternal(boolean transacted, int acknowledgeMode, boolean isXA, int type) throws JMSException {
        if (transacted) {
            acknowledgeMode = 0;
        }
        SessionDelegate sessionDelegate = this.delegate.createSessionDelegate(transacted, acknowledgeMode, isXA);
        return new JBossSession(sessionDelegate, type);
    }
}

