/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.StandardQueryCache;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.config.Option;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.ejb3.entity.SecondLevelCacheUtil;

public class JBCCache
implements Cache {
    private static final Log log = LogFactory.getLog(JBCCache.class);
    private static final String ITEM = "item";
    private org.jboss.cache.Cache cache;
    private final String regionName;
    private final Fqn regionFqn;
    private final TransactionManager transactionManager;
    private boolean localWritesOnly;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JBCCache(org.jboss.cache.Cache cache, String regionName, String regionPrefix, TransactionManager transactionManager) throws CacheException {
        this.cache = cache;
        this.regionName = regionName;
        this.regionFqn = Fqn.fromString((String)SecondLevelCacheUtil.createRegionFqn(regionName, regionPrefix));
        this.transactionManager = transactionManager;
        if (cache.getConfiguration().isUseRegionBasedMarshalling()) {
            this.localWritesOnly = StandardQueryCache.class.getName().equals(regionName);
            boolean fetchState = cache.getConfiguration().isFetchInMemoryState();
            try {
                if (this.localWritesOnly) {
                    cache.getConfiguration().setFetchInMemoryState(false);
                }
                this.activateCacheRegion(this.regionFqn.toString());
            }
            finally {
                if (this.localWritesOnly) {
                    cache.getConfiguration().setFetchInMemoryState(fetchState);
                }
            }
        } else {
            log.debug((Object)"TreeCache is not configured for region based marshalling");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) throws CacheException {
        Transaction tx = this.suspend();
        try {
            Object object = this.read(key);
            return object;
        }
        finally {
            this.resume(tx);
        }
    }

    public Object read(Object key) throws CacheException {
        try {
            return this.cache.get(new Fqn(this.regionFqn, new Object[]{key}), (Object)ITEM);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void update(Object key, Object value) throws CacheException {
        try {
            if (this.localWritesOnly) {
                Option option = new Option();
                option.setCacheModeLocal(true);
                this.cache.getInvocationContext().setOptionOverrides(option);
                this.cache.put(new Fqn(this.regionFqn, new Object[]{key}), (Object)ITEM, value);
            } else {
                this.cache.put(new Fqn(this.regionFqn, new Object[]{key}), (Object)ITEM, value);
            }
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void put(Object key, Object value) throws CacheException {
        Transaction tx = this.suspend();
        try {
            if (this.localWritesOnly) {
                Option option = new Option();
                option.setCacheModeLocal(true);
                this.cache.getInvocationContext().setOptionOverrides(option);
                this.cache.putForExternalRead(new Fqn(this.regionFqn, new Object[]{key}), (Object)ITEM, value);
            } else {
                this.cache.putForExternalRead(new Fqn(this.regionFqn, new Object[]{key}), (Object)ITEM, value);
            }
        }
        catch (TimeoutException te) {
            log.debug((Object)"ignoring write lock acquisition failure");
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
        finally {
            this.resume(tx);
        }
    }

    private void resume(Transaction tx) {
        try {
            if (tx != null) {
                this.transactionManager.resume(tx);
            }
        }
        catch (Exception e) {
            throw new CacheException("Could not resume transaction", (Throwable)e);
        }
    }

    private Transaction suspend() {
        Transaction tx = null;
        try {
            if (this.transactionManager != null) {
                tx = this.transactionManager.suspend();
            }
        }
        catch (SystemException se) {
            throw new CacheException("Could not suspend transaction", (Throwable)se);
        }
        return tx;
    }

    public void remove(Object key) throws CacheException {
        try {
            if (this.localWritesOnly) {
                Option option = new Option();
                option.setCacheModeLocal(true);
                this.cache.getInvocationContext().setOptionOverrides(option);
                this.cache.removeNode(new Fqn(this.regionFqn, new Object[]{key}));
            } else {
                this.cache.removeNode(new Fqn(this.regionFqn, new Object[]{key}));
            }
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void clear() throws CacheException {
        try {
            this.cache.removeNode(this.regionFqn);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void destroy() throws CacheException {
        try {
            InvocationContext ctx = this.cache.getInvocationContext();
            Option opt = new Option();
            opt.setCacheModeLocal(true);
            ctx.setOptionOverrides(opt);
            this.cache.removeNode(this.regionFqn);
            if (this.cache.getConfiguration().isUseRegionBasedMarshalling() && !SecondLevelCacheUtil.isSharedClassLoaderRegion(this.regionName)) {
                this.inactivateCacheRegion();
            }
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void lock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache" + this.regionName);
    }

    public void unlock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        try {
            Set children = this.getChildrenNames();
            return children == null ? 0L : (long)children.size();
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public long getElementCountOnDisk() {
        return 0L;
    }

    public Map toMap() {
        try {
            HashMap result = new HashMap();
            Set childrenNames = this.getChildrenNames();
            if (childrenNames != null) {
                for (Object key : childrenNames) {
                    result.put(key, this.cache.get(new Fqn(this.regionFqn, new Object[]{key}), (Object)ITEM));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    private Set getChildrenNames() {
        try {
            Node base = this.cache.getRoot().getChild(this.regionFqn);
            return base == null ? null : base.getChildrenNames();
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public String toString() {
        return "JBCCache(" + this.regionName + ')';
    }

    private void activateCacheRegion(String regionName) throws CacheException {
        Region region = this.cache.getRegion(this.regionFqn, true);
        if (!region.isActive()) {
            try {
                if (!SecondLevelCacheUtil.isSharedClassLoaderRegion(regionName)) {
                    region.registerContextClassLoader(Thread.currentThread().getContextClassLoader());
                }
                region.activate();
            }
            catch (Exception e) {
                throw SecondLevelCacheUtil.convertToHibernateException(e);
            }
        }
    }

    private void inactivateCacheRegion() throws CacheException {
        Region region = this.cache.getRegion(this.regionFqn, false);
        if (region != null && region.isActive()) {
            try {
                region.deactivate();
                region.unregisterContextClassLoader();
            }
            catch (Exception e) {
                throw SecondLevelCacheUtil.convertToHibernateException(e);
            }
        }
    }
}

