/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.management.MBeanServer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.ClassPathEntry;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.ejb3.KernelAbstraction;
import org.jboss.ejb3.MCKernelAbstraction;
import org.jboss.ejb3.clientmodule.ClientENCInjectionContainer;
import org.jboss.kernel.Kernel;
import org.jboss.metadata.client.jboss.JBossClientMetaData;
import org.jboss.naming.Util;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3ClientDeployer
extends AbstractSimpleVFSRealDeployer<JBossClientMetaData> {
    private Kernel kernel;
    private MBeanServer server;
    private boolean linkDeploymentJndiName = true;

    public Ejb3ClientDeployer() {
        super(JBossClientMetaData.class);
        this.setOutput(ClientENCInjectionContainer.class);
    }

    public boolean isLinkDeploymentJndiName() {
        return this.linkDeploymentJndiName;
    }

    public void setLinkDeploymentJndiName(boolean linkDeploymentJndiName) {
        this.linkDeploymentJndiName = linkDeploymentJndiName;
    }

    @Override
    public void deploy(VFSDeploymentUnit unit, JBossClientMetaData metaData) throws DeploymentException {
        this.log.debug("deploy " + unit.getName());
        String appClientName = this.getJndiName(metaData);
        String deploymentClientName = null;
        if (appClientName == null) {
            appClientName = this.getDeploymentJndiName(unit);
        } else if (this.linkDeploymentJndiName) {
            deploymentClientName = this.getDeploymentJndiName(unit);
        }
        try {
            InitialContext iniCtx = InitialContextFactory.getInitialContext();
            Context encCtx = Util.createSubcontext((Context)iniCtx, appClientName);
            this.log.debug("Creating client ENC binding under: " + appClientName);
            if (deploymentClientName != null && !deploymentClientName.equals(appClientName)) {
                Util.createLinkRef(iniCtx, deploymentClientName, appClientName);
            }
            encCtx.bind("classPathEntries", this.getClassPathEntries(unit));
            encCtx.bind("metaData", (Object)metaData);
            String mainClassName = this.getMainClassName(unit, true);
            Class<?> mainClass = this.loadClass(unit, mainClassName);
            ClientENCInjectionContainer container = new ClientENCInjectionContainer(unit, metaData, mainClass, appClientName, unit.getClassLoader(), encCtx);
            unit.addAttachment(ClientENCInjectionContainer.class, container);
            this.getKernelAbstraction().install(container.getObjectName().getCanonicalName(), container.getDependencyPolicy(), container);
        }
        catch (Exception e) {
            this.log.error("Could not deploy " + unit.getName(), e);
            this.undeploy(unit, metaData);
            throw new DeploymentException("Could not deploy " + unit.getName(), e);
        }
    }

    private List<ClassPathEntry> getClassPathEntries(VFSDeploymentUnit unit) {
        StructureMetaData smd = unit.getTopLevel().getAttachment(StructureMetaData.class);
        if (smd == null) {
            return null;
        }
        return smd.getContext("").getClassPath();
    }

    private String getJndiName(JBossClientMetaData dd) {
        String jndiName = dd.getJndiName();
        return jndiName;
    }

    private String getDeploymentJndiName(DeploymentUnit unit) {
        String jndiName;
        String shortName = unit.getSimpleName();
        if (shortName.endsWith(".jar/")) {
            jndiName = shortName.substring(0, shortName.length() - 5);
        } else if (shortName.endsWith(".jar")) {
            jndiName = shortName.substring(0, shortName.length() - 4);
        } else {
            throw new IllegalStateException("Expected either '.jar' or '.jar/' at the end of " + shortName);
        }
        return jndiName;
    }

    private KernelAbstraction getKernelAbstraction() {
        return new MCKernelAbstraction(this.kernel, this.server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMainClassName(VFSDeploymentUnit unit, boolean fail) throws Exception {
        VirtualFile file = unit.getMetaDataFile("MANIFEST.MF");
        this.log.trace("parsing " + file);
        String mainClassName = "org.jboss.client.AppClientMain";
        if (file != null) {
            try {
                Manifest mf = VFSUtils.readManifest(file);
                Attributes attrs = mf.getMainAttributes();
                String className = attrs.getValue(Attributes.Name.MAIN_CLASS);
                if (className != null) {
                    mainClassName = className;
                }
            }
            finally {
                file.close();
            }
        }
        return mainClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClass(DeploymentUnit unit, String className) throws ClassNotFoundException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(unit.getClassLoader());
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            return clazz;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public void setMbeanServer(MBeanServer server) {
        this.server = server;
    }

    @Override
    public void undeploy(VFSDeploymentUnit unit, JBossClientMetaData metaData) {
        this.log.debug("undeploy " + unit.getName());
        ClientENCInjectionContainer container = unit.getAttachment(ClientENCInjectionContainer.class);
        if (container != null) {
            this.getKernelAbstraction().uninstall(container.getObjectName().getCanonicalName());
        }
        String appClientName = this.getJndiName(metaData);
        String deploymentClientName = null;
        if (appClientName == null) {
            appClientName = this.getDeploymentJndiName(unit);
        } else if (this.linkDeploymentJndiName) {
            deploymentClientName = this.getDeploymentJndiName(unit);
        }
        this.log.debug("Removing client ENC from: " + appClientName);
        try {
            InitialContext iniCtx = InitialContextFactory.getInitialContext();
            Util.unbind((Context)iniCtx, appClientName);
            if (deploymentClientName != null && !deploymentClientName.equals(appClientName)) {
                Util.removeLinkRef(deploymentClientName);
            }
        }
        catch (NameNotFoundException e) {
            this.log.debug("Could not find client ENC");
        }
        catch (NamingException e) {
            this.log.error("Failed to remove client ENC", e);
        }
    }
}

