/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.impl;

import java.util.HashMap;
import java.util.Map;
import javax.ejb.NoSuchEJBException;
import org.jboss.ejb3.cache.Cache;
import org.jboss.ejb3.cache.Identifiable;
import org.jboss.ejb3.cache.StatefulObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryStateCache<T extends Identifiable>
implements Cache<T> {
    private StatefulObjectFactory<T> factory;
    private Map<Object, Entry> cache;

    public EntryStateCache(StatefulObjectFactory<T> factory) {
        assert (factory != null) : "factory is null";
        this.factory = factory;
        this.cache = new HashMap<Object, Entry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T create(Class<?>[] initTypes, Object[] initValues) {
        Identifiable obj = (Identifiable)this.factory.create(initTypes, initValues);
        Entry entry = new Entry(this, obj);
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            this.cache.put(obj.getId(), entry);
        }
        return (T)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(Object key) throws NoSuchEJBException {
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            Entry entry = this.cache.get(key);
            if (entry == null) {
                throw new NoSuchEJBException(String.valueOf(key));
            }
            if (entry.state != State.READY) {
                throw new IllegalStateException("entry " + entry + " is not ready");
            }
            entry.state = State.IN_USE;
            entry.lastUsed = System.currentTimeMillis();
            return entry.obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T peek(Object key) throws NoSuchEJBException {
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            Entry entry = this.cache.get(key);
            if (entry == null) {
                throw new NoSuchEJBException(String.valueOf(key));
            }
            return entry.obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(T obj) {
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            Entry entry = this.cache.get(obj.getId());
            if (entry.state != State.IN_USE) {
                throw new IllegalStateException("entry " + entry + " is not in use");
            }
            entry.state = State.READY;
            entry.lastUsed = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Object key) {
        Entry entry;
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            entry = this.cache.remove(key);
            if (entry.state != State.READY) {
                throw new IllegalStateException("entry " + entry + " is not ready");
            }
        }
        if (entry != null) {
            this.factory.destroy(entry.obj);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        long lastUsed;
        T obj;
        State state;
        final /* synthetic */ EntryStateCache this$0;

        Entry(T obj) {
            this.this$0 = var1_1;
            assert (obj != null) : "obj is null";
            this.lastUsed = System.currentTimeMillis();
            this.obj = obj;
            this.state = State.IN_USE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        READY,
        IN_USE;

    }
}

