/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache;

import java.util.HashMap;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.cache.StatefulCache;
import org.jboss.ejb3.pool.Pool;
import org.jboss.ejb3.stateful.StatefulBeanContext;

public class NoPassivationCache
implements StatefulCache {
    private Pool pool;
    private HashMap<Object, StatefulBeanContext> cacheMap;
    private int createCount = 0;
    private int removeCount = 0;

    public void initialize(Container container) throws Exception {
        this.pool = container.getPool();
        this.cacheMap = new HashMap();
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HashMap<Object, StatefulBeanContext> hashMap = this.cacheMap;
        synchronized (hashMap) {
            this.cacheMap.clear();
        }
    }

    public StatefulBeanContext create() {
        return this.create((Class[])null, (Object[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulBeanContext create(Class[] initTypes, Object[] initValues) {
        StatefulBeanContext ctx = null;
        try {
            ctx = (StatefulBeanContext)this.pool.get(initTypes, initValues);
            ++this.createCount;
            HashMap<Object, StatefulBeanContext> hashMap = this.cacheMap;
            synchronized (hashMap) {
                this.cacheMap.put(ctx.getId(), ctx);
            }
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return ctx;
    }

    public StatefulBeanContext get(Object key) throws EJBException {
        return this.get(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulBeanContext get(Object key, boolean markInUse) throws EJBException {
        StatefulBeanContext entry = null;
        HashMap<Object, StatefulBeanContext> hashMap = this.cacheMap;
        synchronized (hashMap) {
            entry = this.cacheMap.get(key);
        }
        if (entry == null) {
            throw new NoSuchEJBException("Could not find Stateful bean: " + key);
        }
        if (markInUse) {
            if (entry.isRemoved()) {
                throw new NoSuchEJBException("Could not find stateful bean: " + key + " (bean was marked as removed");
            }
            entry.setInUse(true);
            entry.lastUsed = System.currentTimeMillis();
        }
        return entry;
    }

    public StatefulBeanContext peek(Object key) throws NoSuchEJBException {
        return this.get(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(StatefulBeanContext ctx) {
        StatefulBeanContext statefulBeanContext = ctx;
        synchronized (statefulBeanContext) {
            ctx.setInUse(false);
            ctx.lastUsed = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object key) {
        StatefulBeanContext ctx = null;
        HashMap<Object, StatefulBeanContext> hashMap = this.cacheMap;
        synchronized (hashMap) {
            ctx = this.cacheMap.remove(key);
        }
        if (ctx != null) {
            this.pool.remove(ctx);
            ++this.removeCount;
        }
    }

    public int getCacheSize() {
        return this.cacheMap.size();
    }

    public int getTotalSize() {
        return this.cacheMap.size();
    }

    public int getCreateCount() {
        return this.createCount;
    }

    public int getPassivatedCount() {
        return 0;
    }

    public int getRemoveCount() {
        return this.removeCount;
    }

    public int getAvailableCount() {
        return -1;
    }

    public int getMaxSize() {
        return -1;
    }

    public int getCurrentSize() {
        return this.cacheMap.size();
    }
}

