/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2.schema;

import javax.transaction.Transaction;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.Cache;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.PartitionedTableCacheMBean;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.TableCache;
import org.jboss.system.ServiceMBeanSupport;

public class PartitionedTableCache
extends ServiceMBeanSupport
implements Cache,
PartitionedTableCacheMBean {
    private Cache.Listener listener = Cache.Listener.NOOP;
    private final int minCapacity;
    private final int minPartitionCapacity;
    private int maxCapacity;
    private int maxPartitionCapacity;
    private final TableCache[] partitions;
    private Overager overager;

    public PartitionedTableCache(int minCapacity, int maxCapacity, int partitionsTotal) {
        this.minCapacity = minCapacity;
        this.maxCapacity = maxCapacity;
        this.minPartitionCapacity = minCapacity / partitionsTotal + 1;
        this.maxPartitionCapacity = maxCapacity / partitionsTotal + 1;
        this.partitions = new TableCache[partitionsTotal];
        for (int i = 0; i < this.partitions.length; ++i) {
            this.partitions[i] = new TableCache(i, this.minPartitionCapacity, this.maxPartitionCapacity);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("min-capacity=" + minCapacity + ", max-capacity=" + maxCapacity + ", partitions=" + partitionsTotal);
        }
    }

    public void stopService() {
        if (this.overager != null) {
            this.overager.stop();
        }
    }

    public void initOverager(long period, long maxAge, String threadName) {
        long periodMs = period * 1000L;
        long maxAgeMs = maxAge * 1000L;
        this.overager = new Overager(maxAgeMs, periodMs);
        new Thread((Runnable)this.overager, threadName).start();
    }

    public void registerListener(Cache.Listener listener) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("registered listener for " + this.getServiceName());
        }
        this.listener = listener;
        for (int i = 0; i < this.partitions.length; ++i) {
            this.partitions[i].registerListener(listener);
        }
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.partitions.length; ++i) {
            size += this.partitions[i].size();
        }
        return size;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.maxPartitionCapacity = maxCapacity / this.partitions.length + 1;
        for (int i = 0; i < this.partitions.length; ++i) {
            this.partitions[i].setMaxCapacity(this.maxPartitionCapacity);
        }
    }

    public int getMinCapacity() {
        return this.minCapacity;
    }

    public int getPartitionsTotal() {
        return this.partitions.length;
    }

    public int getMinPartitionCapacity() {
        return this.minPartitionCapacity;
    }

    public int getMaxPartitionCapacity() {
        return this.maxPartitionCapacity;
    }

    public void lock() {
    }

    public void lock(Object key) {
        int partitionIndex = this.getPartitionIndex(key);
        this.partitions[partitionIndex].lock(key);
    }

    public void unlock() {
    }

    public void unlock(Object key) {
        int partitionIndex = this.getPartitionIndex(key);
        this.partitions[partitionIndex].unlock(key);
    }

    public Object[] getFields(Object pk) {
        int i = this.getPartitionIndex(pk);
        return this.partitions[i].getFields(pk);
    }

    public Object[] getRelations(Object pk) {
        int i = this.getPartitionIndex(pk);
        return this.partitions[i].getRelations(pk);
    }

    public void put(Transaction tx, Object pk, Object[] fields, Object[] relations) {
        int i = this.getPartitionIndex(pk);
        this.partitions[i].put(tx, pk, fields, relations);
    }

    public void remove(Transaction tx, Object pk) {
        int i = this.getPartitionIndex(pk);
        this.partitions[i].remove(tx, pk);
    }

    public boolean contains(Transaction tx, Object pk) {
        int i = this.getPartitionIndex(pk);
        return this.partitions[i].contains(tx, pk);
    }

    public void lockForUpdate(Transaction tx, Object pk) throws Exception {
        int i = this.getPartitionIndex(pk);
        this.partitions[i].lockForUpdate(tx, pk);
    }

    public void releaseLock(Transaction tx, Object pk) throws Exception {
        int i = this.getPartitionIndex(pk);
        this.partitions[i].releaseLock(tx, pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        for (int i = 0; i < this.partitions.length; ++i) {
            Object var4_3;
            TableCache partition = this.partitions[i];
            partition.lock();
            try {
                partition.flush();
                var4_3 = null;
                partition.unlock();
                continue;
            }
            catch (Throwable throwable) {
                var4_3 = null;
                partition.unlock();
                throw throwable;
            }
        }
    }

    private int getPartitionIndex(Object key) {
        int hash = key.hashCode();
        if (hash < 0) {
            hash = hash == Integer.MIN_VALUE ? Integer.MAX_VALUE : -hash;
        }
        return hash % this.partitions.length;
    }

    private class Overager
    implements Runnable {
        private final long maxAgeMs;
        private final long periodMs;
        private boolean run = true;

        public Overager(long maxAgeMs, long periodMs) {
            this.maxAgeMs = maxAgeMs;
            this.periodMs = periodMs;
        }

        public void stop() {
            this.run = false;
        }

        public void run() {
            while (this.run) {
                long lastUpdated = System.currentTimeMillis() - this.maxAgeMs;
                for (int i = 0; i < PartitionedTableCache.this.partitions.length; ++i) {
                    PartitionedTableCache.this.partitions[i].ageOut(lastUpdated);
                }
                try {
                    Thread.sleep(this.periodMs);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

