/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.util.Date;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.GetTCLAction;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCMappingMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public final class JDBCAuditMetaData {
    private final JDBCCMPFieldMetaData createdPrincipalField;
    private final JDBCCMPFieldMetaData createdTimeField;
    private final JDBCCMPFieldMetaData updatedPrincipalField;
    private final JDBCCMPFieldMetaData updatedTimeField;
    private final Logger log;

    public JDBCAuditMetaData(JDBCEntityMetaData entityMetaData, Element element) throws DeploymentException {
        this.log = Logger.getLogger(entityMetaData.getName());
        Element workElement = MetaData.getOptionalChild(element, "created-by");
        if (workElement != null) {
            this.createdPrincipalField = JDBCAuditMetaData.constructAuditField(entityMetaData, workElement, "audit_created_by");
            this.log.debug("created-by: " + this.createdPrincipalField);
        } else {
            this.createdPrincipalField = null;
        }
        workElement = MetaData.getOptionalChild(element, "created-time");
        if (workElement != null) {
            this.createdTimeField = JDBCAuditMetaData.constructAuditField(entityMetaData, workElement, "audit_created_time");
            this.log.debug("created-time: " + this.createdTimeField);
        } else {
            this.createdTimeField = null;
        }
        workElement = MetaData.getOptionalChild(element, "updated-by");
        if (workElement != null) {
            this.updatedPrincipalField = JDBCAuditMetaData.constructAuditField(entityMetaData, workElement, "audit_updated_by");
            this.log.debug("updated-by: " + this.updatedPrincipalField);
        } else {
            this.updatedPrincipalField = null;
        }
        workElement = MetaData.getOptionalChild(element, "updated-time");
        if (workElement != null) {
            this.updatedTimeField = JDBCAuditMetaData.constructAuditField(entityMetaData, workElement, "audit_updated_time");
            this.log.debug("updated-time: " + this.updatedTimeField);
        } else {
            this.updatedTimeField = null;
        }
    }

    public JDBCCMPFieldMetaData getCreatedPrincipalField() {
        return this.createdPrincipalField;
    }

    public JDBCCMPFieldMetaData getCreatedTimeField() {
        return this.createdTimeField;
    }

    public JDBCCMPFieldMetaData getUpdatedPrincipalField() {
        return this.updatedPrincipalField;
    }

    public JDBCCMPFieldMetaData getUpdatedTimeField() {
        return this.updatedTimeField;
    }

    private static JDBCCMPFieldMetaData constructAuditField(JDBCEntityMetaData entity, Element element, String defaultName) throws DeploymentException {
        String sqlType;
        int jdbcType;
        Class<Object> fieldType;
        String fieldTypeStr;
        String columnName;
        String fieldName = MetaData.getOptionalChildContent(element, "field-name");
        if (fieldName == null || fieldName.trim().length() < 1) {
            fieldName = defaultName;
        }
        if ((columnName = MetaData.getOptionalChildContent(element, "column-name")) == null || columnName.trim().length() < 1) {
            columnName = defaultName;
        }
        if ((fieldTypeStr = MetaData.getOptionalChildContent(element, "field-type")) != null) {
            try {
                fieldType = GetTCLAction.getContextClassLoader().loadClass(fieldTypeStr);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load field type for audit field " + fieldName + ": " + fieldTypeStr);
            }
        } else {
            fieldType = defaultName.endsWith("by") ? String.class : Date.class;
        }
        String jdbcTypeName = MetaData.getOptionalChildContent(element, "jdbc-type");
        if (jdbcTypeName != null) {
            jdbcType = JDBCMappingMetaData.getJdbcTypeFromName(jdbcTypeName);
            sqlType = MetaData.getUniqueChildContent(element, "sql-type");
        } else {
            jdbcType = Integer.MIN_VALUE;
            sqlType = null;
        }
        JDBCCMPFieldMetaData result = entity.getCMPFieldByName(fieldName);
        if (result == null) {
            result = new JDBCCMPFieldMetaData(entity, fieldName, fieldType, columnName, jdbcType, sqlType);
        }
        return result;
    }
}

