/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCActivateEntityCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCCreateBeanClassInstanceCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCCreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCDeclaredSQLQuery;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCDeleteRelationsCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCDestroyCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCDynamicQLQuery;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCEJBQLQuery;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCFindAllQuery;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCFindByPrimaryKeyQuery;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCFindByQuery;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCFindEntitiesCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCFindEntityCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCInitCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCInitEntityCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCInsertRelationsCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCIsModifiedCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCJBossQLQuery;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCLoadEntityCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCLoadRelationCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCPassivateEntityCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCPostCreateEntityCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCQueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCRemoveEntityCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStartCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStopCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreEntityCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.logging.Logger;

public class JDBCCommandFactory {
    private final Logger log;
    private final JDBCStoreManager manager;

    public JDBCCommandFactory(JDBCStoreManager manager) throws Exception {
        this.manager = manager;
        this.log = Logger.getLogger(this.getClass().getName() + "." + manager.getContainer().getBeanMetaData().getEjbName());
    }

    public JDBCQueryCommand createFindByPrimaryKeyQuery(JDBCQueryMetaData q) throws DeploymentException {
        return new JDBCFindByPrimaryKeyQuery(this.manager, q);
    }

    public JDBCQueryCommand createFindAllQuery(JDBCQueryMetaData q) throws DeploymentException {
        return new JDBCFindAllQuery(this.manager, q);
    }

    public JDBCQueryCommand createDeclaredSQLQuery(JDBCQueryMetaData q) throws DeploymentException {
        return new JDBCDeclaredSQLQuery(this.manager, q);
    }

    public JDBCQueryCommand createEJBQLQuery(JDBCQueryMetaData q) throws DeploymentException {
        return new JDBCEJBQLQuery(this.manager, q);
    }

    public JDBCQueryCommand createDynamicQLQuery(JDBCQueryMetaData q) throws DeploymentException {
        return new JDBCDynamicQLQuery(this.manager, q);
    }

    public JDBCQueryCommand createJBossQLQuery(JDBCQueryMetaData q) throws DeploymentException {
        return new JDBCJBossQLQuery(this.manager, q);
    }

    public JDBCQueryCommand createFindByQuery(JDBCQueryMetaData q) throws DeploymentException {
        return new JDBCFindByQuery(this.manager, q);
    }

    public JDBCLoadRelationCommand createLoadRelationCommand() {
        return new JDBCLoadRelationCommand(this.manager);
    }

    public JDBCDeleteRelationsCommand createDeleteRelationsCommand() {
        return new JDBCDeleteRelationsCommand(this.manager);
    }

    public JDBCInsertRelationsCommand createInsertRelationsCommand() {
        return new JDBCInsertRelationsCommand(this.manager);
    }

    public JDBCInitCommand createInitCommand() {
        return new JDBCInitCommand(this.manager);
    }

    public JDBCStartCommand createStartCommand() {
        return new JDBCStartCommand(this.manager);
    }

    public JDBCStopCommand createStopCommand() {
        return new JDBCStopCommand(this.manager);
    }

    public JDBCDestroyCommand createDestroyCommand() {
        return new JDBCDestroyCommand(this.manager);
    }

    public JDBCCreateBeanClassInstanceCommand createCreateBeanClassInstanceCommand() throws Exception {
        return new JDBCCreateBeanClassInstanceCommand(this.manager);
    }

    public JDBCInitEntityCommand createInitEntityCommand() {
        return new JDBCInitEntityCommand(this.manager);
    }

    public JDBCFindEntityCommand createFindEntityCommand() {
        return new JDBCFindEntityCommand(this.manager);
    }

    public JDBCFindEntitiesCommand createFindEntitiesCommand() {
        return new JDBCFindEntitiesCommand(this.manager);
    }

    public JDBCCreateCommand createCreateEntityCommand() throws DeploymentException {
        JDBCCreateCommand cec;
        try {
            cec = (JDBCCreateCommand)this.manager.getMetaData().getEntityCommand().getCommandClass().newInstance();
            cec.init(this.manager);
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DeploymentException("Couldn't create entity command: ", e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("entity-command: " + this.manager.getMetaData().getEntityCommand());
        }
        return cec;
    }

    public JDBCPostCreateEntityCommand createPostCreateEntityCommand() {
        return new JDBCPostCreateEntityCommand(this.manager);
    }

    public JDBCRemoveEntityCommand createRemoveEntityCommand() throws DeploymentException {
        return new JDBCRemoveEntityCommand(this.manager);
    }

    public JDBCLoadEntityCommand createLoadEntityCommand() throws DeploymentException {
        return new JDBCLoadEntityCommand(this.manager);
    }

    public JDBCIsModifiedCommand createIsModifiedCommand() {
        return new JDBCIsModifiedCommand(this.manager);
    }

    public JDBCStoreEntityCommand createStoreEntityCommand() {
        return new JDBCStoreEntityCommand(this.manager);
    }

    public JDBCActivateEntityCommand createActivateEntityCommand() {
        return new JDBCActivateEntityCommand(this.manager);
    }

    public JDBCPassivateEntityCommand createPassivateEntityCommand() {
        return new JDBCPassivateEntityCommand(this.manager);
    }
}

