/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.logging.Logger;
import org.jboss.metadata.client.jboss.JBossClientMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossEntityBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBLocalReferencesMetaData;
import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceMetaDataResolverDeployer
extends AbstractRealDeployer {
    private static Logger log = Logger.getLogger(ReferenceMetaDataResolverDeployer.class);
    private boolean failOnUnresolvedRefs;
    private ConcurrentHashMap<String, String> mappedNameMap = new ConcurrentHashMap();

    public ReferenceMetaDataResolverDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        HashSet<String> inputs = new HashSet<String>();
        inputs.add(JBossClientMetaData.class.getName());
        inputs.add(JBossMetaData.class.getName());
        inputs.add(JBossWebMetaData.class.getName());
        super.setInputs(inputs);
    }

    @Override
    public boolean isParentFirst() {
        return false;
    }

    @Override
    public void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        List<String> unresolvedPaths;
        JBossMetaData ejbMetaData = unit.getAttachment(JBossMetaData.class);
        JBossWebMetaData webMetaData = unit.getAttachment(JBossWebMetaData.class);
        JBossClientMetaData clientMetaData = unit.getAttachment(JBossClientMetaData.class);
        if (ejbMetaData == null && webMetaData == null && clientMetaData == null) {
            return;
        }
        this.dump(unit);
        if (ejbMetaData != null) {
            JBossEnterpriseBeansMetaData beans = ejbMetaData.getEnterpriseBeans();
            this.mapEjbs(unit.getRelativePath(), beans);
            List<String> unresolvedPaths2 = this.resolve(unit, beans);
            if (unresolvedPaths2 != null && unresolvedPaths2.size() > 0) {
                log.warn("Unresolved references exist in JBossMetaData: " + unresolvedPaths2);
            }
        }
        if (webMetaData != null && (unresolvedPaths = this.resolve(unit, webMetaData.getJndiEnvironmentRefsGroup())) != null && unresolvedPaths.size() > 0) {
            log.warn("Unresolved references exist in JBossWebMetaData: " + unresolvedPaths);
        }
        if (clientMetaData != null && (unresolvedPaths = this.resolve(unit, clientMetaData.getJndiEnvironmentRefsGroup())) != null && unresolvedPaths.size() > 0) {
            log.warn("Unresolved references exist in JBossClientMetaData: " + unresolvedPaths);
        }
    }

    protected void mapEjbs(String vfsPath, JBossEnterpriseBeansMetaData beans) {
        if (beans == null || beans.size() == 0) {
            return;
        }
        for (JBossEnterpriseBeanMetaData bean : beans) {
            BusinessRemotesMetaData remotes;
            String ejbPath = vfsPath + "/" + bean.getEjbName();
            String mappedName = bean.getMappedName();
            if (mappedName != null) {
                this.mappedNameMap.put(ejbPath, mappedName);
            }
            if (!(bean instanceof JBossSessionBeanMetaData)) continue;
            JBossSessionBeanMetaData sbean = (JBossSessionBeanMetaData)bean;
            BusinessLocalsMetaData locals = sbean.getBusinessLocals();
            if (locals != null) {
                for (String local : locals) {
                }
            }
            if ((remotes = sbean.getBusinessRemotes()) == null) continue;
            for (String remote : remotes) {
            }
        }
    }

    protected List<String> resolve(DeploymentUnit unit, Environment env) {
        if (env == null) {
            return null;
        }
        ArrayList<String> unresolvedRefs = new ArrayList<String>();
        AnnotatedEJBReferencesMetaData annotatedRefs = env.getAnnotatedEjbReferences();
        EJBLocalReferencesMetaData localRefs = env.getEjbLocalReferences();
        this.resolveEjbLocalRefs(unit, localRefs, unresolvedRefs);
        EJBReferencesMetaData ejbRefs = env.getEjbReferences();
        this.resolveEjbRefs(unit, ejbRefs, unresolvedRefs);
        return unresolvedRefs;
    }

    protected List<String> resolve(DeploymentUnit unit, JBossEnterpriseBeansMetaData beans) {
        ArrayList<String> unresolvedRefs = new ArrayList<String>();
        if (beans == null || beans.size() == 0) {
            return unresolvedRefs;
        }
        for (JBossEnterpriseBeanMetaData bean : beans) {
            EJBLocalReferencesMetaData localRefs = bean.getEjbLocalReferences();
            this.resolveEjbLocalRefs(unit, localRefs, unresolvedRefs);
            EJBReferencesMetaData ejbRefs = bean.getEjbReferences();
            this.resolveEjbRefs(unit, ejbRefs, unresolvedRefs);
        }
        return unresolvedRefs;
    }

    protected void resolveEjbLocalRefs(DeploymentUnit unit, EJBLocalReferencesMetaData localRefs, ArrayList<String> unresolvedRefs) {
        if (localRefs == null) {
            return;
        }
        ArrayList<String> searched = new ArrayList<String>();
        for (EJBLocalReferenceMetaData ref : localRefs) {
            String link = ref.getLink();
            String target = ReferenceMetaDataResolverDeployer.findLocalEjbLink(unit, link, searched);
            if (target == null) {
                unresolvedRefs.add(ref.getEjbRefName() + "/ejb-local-ref/" + link + " available: " + searched);
                continue;
            }
            ref.setMappedName(target);
        }
    }

    protected void resolveEjbRefs(DeploymentUnit unit, EJBReferencesMetaData ejbRefs, ArrayList<String> unresolvedRefs) {
        if (ejbRefs == null) {
            return;
        }
        ArrayList<String> searched = new ArrayList<String>();
        for (EJBReferenceMetaData ref : ejbRefs) {
            String mappedName = ref.getMappedName();
            if (mappedName != null && mappedName.length() != 0) continue;
            String link = ref.getLink();
            String target = null;
            if (link != null) {
                target = ReferenceMetaDataResolverDeployer.findEjbLink(unit, link, searched);
            }
            if (target == null) {
                unresolvedRefs.add(ref.getEjbRefName() + "/ejb-ref/" + link + " available: " + searched);
                continue;
            }
            ref.setMappedName(target);
        }
    }

    public static String findEjbLink(DeploymentUnit unit, String link, ArrayList<String> searched) {
        return ReferenceMetaDataResolverDeployer.resolveLink(unit, link, searched, false);
    }

    public static String findLocalEjbLink(DeploymentUnit unit, String link, ArrayList<String> searched) {
        return ReferenceMetaDataResolverDeployer.resolveLink(unit, link, searched, true);
    }

    public static MessageDestinationMetaData findMessageDestination(MainDeployerStructure server, DeploymentUnit di, String link) {
        return ReferenceMetaDataResolverDeployer.resolveMessageDestination(server, di, link);
    }

    private static String resolveLink(DeploymentUnit di, String link, ArrayList<String> searched, boolean isLocal) {
        if (link == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("resolveLink( {" + di + "}, {" + link + "}, {" + isLocal + "}");
        }
        if (di == null) {
            return null;
        }
        if (link.indexOf(35) != -1) {
            return ReferenceMetaDataResolverDeployer.resolveRelativeLink(di, link, searched, isLocal);
        }
        DeploymentUnit top = di.getTopLevel();
        return ReferenceMetaDataResolverDeployer.resolveAbsoluteLink(top, link, searched, isLocal);
    }

    private static String resolveRelativeLink(DeploymentUnit unit, String link, ArrayList<String> searched, boolean isLocal) {
        DeploymentUnit targetUnit;
        DeploymentUnit top = unit.getTopLevel();
        String path = link.substring(0, link.indexOf(35));
        String ejbName = link.substring(link.indexOf(35) + 1);
        if (log.isTraceEnabled()) {
            log.trace("Resolving relative link: " + link);
        }
        if ((targetUnit = ReferenceMetaDataResolverDeployer.findLinkPath(top, path)) == null) {
            log.warn("Can't locate DeploymentUnit for target: " + path);
            return null;
        }
        String linkTarget = null;
        if (targetUnit.getAttachment(JBossMetaData.class) != null) {
            JBossMetaData appMD = targetUnit.getAttachment(JBossMetaData.class);
            JBossEnterpriseBeanMetaData beanMD = appMD.getEnterpriseBean(ejbName);
            if (beanMD != null) {
                linkTarget = ReferenceMetaDataResolverDeployer.getJndiName(beanMD, isLocal);
                if (linkTarget == null) {
                    if (isLocal) {
                        log.warn("Unable to determine local jndi name for " + beanMD.getEjbName());
                    } else {
                        log.warn("Unable to determine jndi name for " + beanMD.getEjbName());
                    }
                    searched.add(beanMD.getEjbName());
                }
            } else {
                log.warn("No Bean named '" + ejbName + "' found in '" + path + "'!");
                for (JBossEnterpriseBeanMetaData md : appMD.getEnterpriseBeans()) {
                    searched.add(md.getEjbName());
                }
            }
        } else {
            log.warn("DeploymentUnit " + targetUnit + " is not an EJB .jar " + "file!");
            searched.add(targetUnit.getName());
        }
        return linkTarget;
    }

    private static String resolveAbsoluteLink(DeploymentUnit unit, String link, ArrayList<String> searched, boolean isLocal) {
        if (log.isTraceEnabled()) {
            log.trace("Resolving absolute link, di: " + unit);
        }
        String ejbName = null;
        List<JBossMetaData> ejbMetaData = ReferenceMetaDataResolverDeployer.getAllAttachments(unit, JBossMetaData.class);
        for (JBossMetaData ejbMD : ejbMetaData) {
            JBossEnterpriseBeanMetaData beanMD = ejbMD.getEnterpriseBean(link);
            if (beanMD != null) {
                ejbName = ReferenceMetaDataResolverDeployer.getJndiName(beanMD, isLocal);
                if (ejbName == null) {
                    if (isLocal) {
                        log.warn("Unable to determine local jndi name for " + beanMD.getEjbName());
                    } else {
                        log.warn("Unable to determine jndi name for " + beanMD.getEjbName());
                    }
                    searched.add(beanMD.getEjbName());
                }
                if (log.isTraceEnabled()) {
                    log.trace("Found Bean: " + beanMD + ", resolves to: " + ejbName);
                }
                return ejbName;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("No match for ejb-link: " + link + ", module names:");
            for (JBossEnterpriseBeanMetaData md : ejbMD.getEnterpriseBeans()) {
                String beanEjbName = ReferenceMetaDataResolverDeployer.getJndiName(md, isLocal);
                searched.add(md.getEjbName());
                log.trace("... ejbName: " + beanEjbName);
            }
        }
        return ejbName;
    }

    private static <T> List<T> getAllAttachments(DeploymentUnit unit, Class<T> type) {
        ArrayList attachments = new ArrayList();
        DeploymentUnit top = unit.getTopLevel();
        ReferenceMetaDataResolverDeployer.getAllAttachments(top, type, attachments);
        return attachments;
    }

    private static <T> void getAllAttachments(DeploymentUnit unit, Class<T> type, ArrayList<T> attachments) {
        List<DeploymentUnit> children;
        T attachment = unit.getAttachment(type);
        if (attachment != null) {
            attachments.add(attachment);
        }
        if ((children = unit.getChildren()) != null) {
            for (DeploymentUnit child : children) {
                ReferenceMetaDataResolverDeployer.getAllAttachments(child, type, attachments);
            }
        }
    }

    private static String getJndiName(JBossEnterpriseBeanMetaData beanMD, boolean isLocal) {
        JBossSessionBeanMetaData md;
        String jndiName = null;
        if (isLocal) {
            jndiName = beanMD.determineLocalJndiName();
            if (jndiName == null) {
                log.warn("LocalHome jndi name requested for: '" + beanMD.getEjbName() + "' but there is no LocalHome class");
            }
        } else if (beanMD.isEntity()) {
            JBossEntityBeanMetaData md2 = (JBossEntityBeanMetaData)beanMD;
            jndiName = md2.determineJndiName();
        } else if (beanMD.isSession() && (jndiName = (md = (JBossSessionBeanMetaData)beanMD).getHomeJndiName()) == null) {
            jndiName = md.determineJndiName();
        }
        return jndiName;
    }

    private static MessageDestinationMetaData resolveMessageDestination(MainDeployerStructure server, DeploymentUnit di, String link) {
        if (link == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("resolveLink( {" + di + "}, {" + link + "})");
        }
        if (di == null) {
            return null;
        }
        if (link.indexOf(35) != -1) {
            return ReferenceMetaDataResolverDeployer.resolveRelativeMessageDestination(di, link);
        }
        DeploymentUnit top = di.getTopLevel();
        return ReferenceMetaDataResolverDeployer.resolveAbsoluteMessageDestination(top, link);
    }

    private static MessageDestinationMetaData resolveRelativeMessageDestination(DeploymentUnit unit, String link) {
        DeploymentUnit top;
        DeploymentUnit targetUnit;
        String path = link.substring(0, link.indexOf(35));
        String destinationName = link.substring(link.indexOf(35) + 1);
        if (log.isTraceEnabled()) {
            log.trace("Resolving relative message-destination-link: " + link);
        }
        if ((targetUnit = ReferenceMetaDataResolverDeployer.findLinkPath(top = unit.getTopLevel(), path)) == null) {
            log.warn("Can't locate DeploymentUnit for target: " + path);
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("Found appropriate DeploymentUnit: " + targetUnit);
        }
        if (targetUnit.getAttachment(JBossMetaData.class) != null) {
            JBossMetaData appMD = targetUnit.getAttachment(JBossMetaData.class);
            return appMD.getAssemblyDescriptor().getMessageDestination(destinationName);
        }
        if (targetUnit.getAttachment(JBossWebMetaData.class) != null) {
            JBossWebMetaData webMD = targetUnit.getAttachment(JBossWebMetaData.class);
            return webMD.getMessageDestination(destinationName);
        }
        log.warn("DeploymentUnit " + targetUnit + " is not an EJB .jar " + "file!");
        return null;
    }

    private static MessageDestinationMetaData resolveAbsoluteMessageDestination(DeploymentUnit unit, String link) {
        JBossMetaData appMD;
        MessageDestinationMetaData mdMD;
        if (log.isTraceEnabled()) {
            log.trace("Resolving absolute link, di: " + unit);
        }
        if (unit.getAttachment(JBossMetaData.class) != null && (mdMD = (appMD = unit.getAttachment(JBossMetaData.class)).getAssemblyDescriptor().getMessageDestination(link)) != null) {
            return mdMD;
        }
        if (unit.getAttachment(JBossWebMetaData.class) != null) {
            JBossWebMetaData webMD = unit.getAttachment(JBossWebMetaData.class);
            return webMD.getMessageDestination(link);
        }
        for (DeploymentUnit child : unit.getChildren()) {
            MessageDestinationMetaData mdMD2 = ReferenceMetaDataResolverDeployer.resolveAbsoluteMessageDestination(child, link);
            if (mdMD2 == null) continue;
            return mdMD2;
        }
        return null;
    }

    private static DeploymentUnit findLinkPath(DeploymentUnit top, String path) {
        List<DeploymentUnit> children = top.getChildren();
        DeploymentUnit targetUnit = null;
        if (children != null) {
            for (DeploymentUnit child : children) {
                String childPath = child.getRelativePath();
                if (!childPath.endsWith(path)) continue;
                targetUnit = child;
            }
        }
        if (targetUnit == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("Found appropriate DeploymentUnit: " + targetUnit);
        }
        return targetUnit;
    }

    private void dump(DeploymentUnit unit) {
        DeploymentUnit top = unit.getTopLevel();
        StringBuffer tmp = new StringBuffer();
        this.dump(top, tmp, 0);
        log.debug("Processing unit:\n" + tmp);
    }

    private void dump(DeploymentUnit unit, StringBuffer tmp, int depth) {
        JBossEnterpriseBeansMetaData beans;
        for (int n = 0; n < depth; ++n) {
            tmp.append('+');
        }
        tmp.append(unit.getRelativePath());
        JBossMetaData metaData = unit.getAttachment(JBossMetaData.class);
        if (metaData != null && (beans = metaData.getEnterpriseBeans()) != null) {
            for (JBossEnterpriseBeanMetaData bean : beans) {
                BusinessRemotesMetaData remotes;
                BusinessLocalsMetaData locals;
                tmp.append(",ejbName=");
                tmp.append(bean.getEjbName());
                if (bean.getEjbClass() != null) {
                    tmp.append(",ejbClass=");
                    tmp.append(bean.getEjbClass());
                }
                if (!(bean instanceof JBossSessionBeanMetaData)) continue;
                JBossSessionBeanMetaData sbean = (JBossSessionBeanMetaData)bean;
                if (sbean.getHome() != null) {
                    tmp.append(",home=");
                    tmp.append(sbean.getHome());
                }
                if (sbean.getRemote() != null) {
                    tmp.append(",remote=");
                    tmp.append(sbean.getRemote());
                }
                if ((locals = sbean.getBusinessLocals()) != null) {
                    tmp.append(",BusinessLocals: ");
                    tmp.append(locals);
                }
                if ((remotes = sbean.getBusinessRemotes()) == null) continue;
                tmp.append(",BusinessRemotes: ");
                tmp.append(remotes);
            }
        }
        tmp.append('\n');
        List<DeploymentUnit> children = unit.getChildren();
        if (children != null) {
            for (DeploymentUnit child : children) {
                this.dump(child, tmp, depth + 1);
            }
        }
    }
}

