/*     */ package org.jnp.server;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.Socket;
/*     */ import java.net.UnknownHostException;
/*     */ import java.rmi.MarshalledObject;
/*     */ import java.rmi.Remote;
/*     */ import java.rmi.server.RMIClientSocketFactory;
/*     */ import java.rmi.server.RMIServerSocketFactory;
/*     */ import java.rmi.server.UnicastRemoteObject;
/*     */ import java.util.Properties;
/*     */ import javax.net.ServerSocketFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.net.sockets.DefaultSocketFactory;
/*     */ import org.jboss.util.threadpool.BasicThreadPool;
/*     */ import org.jboss.util.threadpool.ThreadPool;
/*     */ import org.jnp.interfaces.Naming;
/*     */ 
/*     */ public class Main
/*     */   implements MainMBean
/*     */ {
/*     */   protected NamingBean theServer;
/*     */   protected MarshalledObject serverStub;
/*     */   protected boolean isStubExported;
/*     */   protected ServerSocket serverSocket;
/*     */   protected RMIClientSocketFactory clientSocketFactory;
/*     */   protected RMIServerSocketFactory serverSocketFactory;
/*     */   protected ServerSocketFactory jnpServerSocketFactory;
/*     */   protected String clientSocketFactoryName;
/*     */   protected String serverSocketFactoryName;
/*     */   protected String jnpServerSocketFactoryName;
/*     */   protected InetAddress bindAddress;
/*     */   protected InetAddress rmiBindAddress;
/*  85 */   protected int backlog = 50;
/*     */ 
/*  88 */   protected int port = 1099;
/*     */ 
/*  91 */   protected int rmiPort = 0;
/*     */ 
/*  93 */   protected boolean InstallGlobalService = true;
/*     */ 
/*  95 */   protected boolean UseGlobalService = true;
/*     */   protected Logger log;
/*     */   protected ThreadPool lookupPool;
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws Exception
/*     */   {
/* 104 */     new Main().start();
/*     */   }
/*     */ 
/*     */   public Main()
/*     */   {
/* 110 */     this("org.jboss.naming.Naming");
/*     */   }
/*     */ 
/*     */   public Main(String categoryName)
/*     */   {
/*     */     try
/*     */     {
/* 117 */       ClassLoader loader = getClass().getClassLoader();
/* 118 */       InputStream is = loader.getResourceAsStream("jnp.properties");
/* 119 */       System.getProperties().load(is);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */ 
/* 127 */     setPort(Integer.getInteger("jnp.port", getPort()).intValue());
/* 128 */     setRmiPort(Integer.getInteger("jnp.rmiPort", getRmiPort()).intValue());
/* 129 */     this.log = Logger.getLogger(categoryName);
/*     */   }
/*     */ 
/*     */   public NamingBean getNamingInfo()
/*     */   {
/* 135 */     return this.theServer;
/*     */   }
/*     */ 
/*     */   public void setNamingInfo(NamingBean info) {
/* 139 */     this.theServer = info;
/*     */   }
/*     */ 
/*     */   public ThreadPool getLookupPool()
/*     */   {
/* 144 */     return this.lookupPool;
/*     */   }
/*     */ 
/*     */   public void setLookupPool(ThreadPool lookupPool) {
/* 148 */     this.lookupPool = lookupPool;
/*     */   }
/*     */ 
/*     */   public void setNamingProxy(Object proxy)
/*     */     throws IOException
/*     */   {
/* 154 */     this.serverStub = new MarshalledObject(proxy);
/*     */   }
/*     */ 
/*     */   public void setRmiPort(int p)
/*     */   {
/* 159 */     this.rmiPort = p;
/*     */   }
/*     */ 
/*     */   public int getRmiPort() {
/* 163 */     return this.rmiPort;
/*     */   }
/*     */ 
/*     */   public void setPort(int p)
/*     */   {
/* 168 */     this.port = p;
/*     */   }
/*     */ 
/*     */   public int getPort() {
/* 172 */     return this.port;
/*     */   }
/*     */ 
/*     */   public String getBindAddress()
/*     */   {
/* 177 */     String address = null;
/* 178 */     if (this.bindAddress != null)
/* 179 */       address = this.bindAddress.getHostAddress();
/* 180 */     return address;
/*     */   }
/*     */ 
/*     */   public void setBindAddress(String host) throws UnknownHostException {
/* 184 */     if ((host == null) || (host.length() == 0))
/* 185 */       this.bindAddress = null;
/*     */     else
/* 187 */       this.bindAddress = InetAddress.getByName(host);
/*     */   }
/*     */ 
/*     */   public String getRmiBindAddress()
/*     */   {
/* 192 */     String address = null;
/* 193 */     if (this.rmiBindAddress != null)
/* 194 */       address = this.rmiBindAddress.getHostAddress();
/* 195 */     return address;
/*     */   }
/*     */ 
/*     */   public void setRmiBindAddress(String host) throws UnknownHostException {
/* 199 */     if ((host == null) || (host.length() == 0))
/* 200 */       this.rmiBindAddress = null;
/*     */     else
/* 202 */       this.rmiBindAddress = InetAddress.getByName(host);
/*     */   }
/*     */ 
/*     */   public int getBacklog()
/*     */   {
/* 207 */     return this.backlog;
/*     */   }
/*     */ 
/*     */   public void setBacklog(int backlog) {
/* 211 */     if (backlog <= 0)
/* 212 */       backlog = 50;
/* 213 */     this.backlog = backlog;
/*     */   }
/*     */ 
/*     */   public boolean getInstallGlobalService()
/*     */   {
/* 218 */     return this.InstallGlobalService;
/*     */   }
/*     */ 
/*     */   public void setInstallGlobalService(boolean flag) {
/* 222 */     this.InstallGlobalService = flag;
/*     */   }
/*     */ 
/*     */   public boolean getUseGlobalService() {
/* 226 */     return this.UseGlobalService;
/*     */   }
/*     */ 
/*     */   public void setUseGlobalService(boolean flag) {
/* 230 */     this.UseGlobalService = flag;
/*     */   }
/*     */ 
/*     */   public String getClientSocketFactory()
/*     */   {
/* 235 */     return this.clientSocketFactoryName;
/*     */   }
/*     */ 
/*     */   public void setClientSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException
/*     */   {
/* 240 */     this.clientSocketFactoryName = factoryClassName;
/* 241 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 242 */     Class clazz = loader.loadClass(this.clientSocketFactoryName);
/* 243 */     this.clientSocketFactory = ((RMIClientSocketFactory)clazz.newInstance());
/*     */   }
/*     */ 
/*     */   public RMIClientSocketFactory getClientSocketFactoryBean()
/*     */   {
/* 248 */     return this.clientSocketFactory;
/*     */   }
/*     */ 
/*     */   public void setClientSocketFactoryBean(RMIClientSocketFactory factory) {
/* 252 */     this.clientSocketFactory = factory;
/*     */   }
/*     */ 
/*     */   public String getServerSocketFactory()
/*     */   {
/* 257 */     return this.serverSocketFactoryName;
/*     */   }
/*     */ 
/*     */   public void setServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException
/*     */   {
/* 262 */     this.serverSocketFactoryName = factoryClassName;
/* 263 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 264 */     Class clazz = loader.loadClass(this.serverSocketFactoryName);
/* 265 */     this.serverSocketFactory = ((RMIServerSocketFactory)clazz.newInstance());
/*     */   }
/*     */ 
/*     */   public RMIServerSocketFactory getServerSocketFactoryBean()
/*     */   {
/* 270 */     return this.serverSocketFactory;
/*     */   }
/*     */ 
/*     */   public void setServerSocketFactoryBean(RMIServerSocketFactory factory) {
/* 274 */     this.serverSocketFactory = factory;
/*     */   }
/*     */ 
/*     */   public String getJNPServerSocketFactory()
/*     */   {
/* 279 */     return this.jnpServerSocketFactoryName;
/*     */   }
/*     */ 
/*     */   public void setJNPServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException
/*     */   {
/* 284 */     this.jnpServerSocketFactoryName = factoryClassName;
/* 285 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 286 */     Class clazz = loader.loadClass(this.jnpServerSocketFactoryName);
/* 287 */     this.jnpServerSocketFactory = ((ServerSocketFactory)clazz.newInstance());
/*     */   }
/*     */ 
/*     */   public ServerSocketFactory getJNPServerSocketFactoryBean()
/*     */   {
/* 292 */     return this.jnpServerSocketFactory;
/*     */   }
/*     */ 
/*     */   public void setJNPServerSocketFactoryBean(ServerSocketFactory factory) {
/* 296 */     this.jnpServerSocketFactory = factory;
/*     */   }
/*     */ 
/*     */   public Naming getNamingInstance()
/*     */   {
/* 301 */     return this.theServer.getNamingInstance();
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 309 */     initCustomSocketFactories();
/*     */ 
/* 314 */     if ((this.serverStub == null) && (this.port >= 0))
/*     */     {
/* 316 */       initJnpInvoker();
/*     */     }
/*     */ 
/* 319 */     if (this.serverStub != null)
/*     */     {
/* 321 */       initBootstrapListener();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */     try
/*     */     {
/* 330 */       if (this.serverSocket != null)
/*     */       {
/* 332 */         ServerSocket s = this.serverSocket;
/* 333 */         this.serverSocket = null;
/* 334 */         s.close();
/*     */       }
/* 336 */       if (this.isStubExported == true)
/* 337 */         UnicastRemoteObject.unexportObject(this.theServer.getNamingInstance(), false);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 341 */       this.log.error("Exception during shutdown", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initJnpInvoker()
/*     */     throws IOException
/*     */   {
/* 350 */     this.log.debug("Creating NamingServer stub, theServer=" + this.theServer + ",rmiPort=" + this.rmiPort + ",clientSocketFactory=" + this.clientSocketFactory + ",serverSocketFactory=" + this.serverSocketFactory);
/*     */ 
/* 354 */     Remote stub = UnicastRemoteObject.exportObject(getNamingInstance(), this.rmiPort, this.clientSocketFactory, this.serverSocketFactory);
/*     */ 
/* 356 */     this.log.debug("NamingServer stub: " + stub);
/* 357 */     this.serverStub = new MarshalledObject(stub);
/*     */   }
/*     */ 
/*     */   protected void initBootstrapListener()
/*     */   {
/*     */     try
/*     */     {
/* 369 */       if (this.jnpServerSocketFactory == null)
/* 370 */         this.jnpServerSocketFactory = ServerSocketFactory.getDefault();
/* 371 */       this.serverSocket = this.jnpServerSocketFactory.createServerSocket(this.port, this.backlog, this.bindAddress);
/*     */ 
/* 373 */       if (this.port == 0)
/* 374 */         this.port = this.serverSocket.getLocalPort();
/* 375 */       String msg = "JNDI bootstrap JNP=" + this.bindAddress + ":" + this.port + ", RMI=" + this.bindAddress + ":" + this.rmiPort + ", backlog=" + this.backlog;
/*     */ 
/* 379 */       if (this.clientSocketFactory == null)
/* 380 */         msg = msg + ", no client SocketFactory";
/*     */       else {
/* 382 */         msg = msg + ", Client SocketFactory=" + this.clientSocketFactory.toString();
/*     */       }
/* 384 */       if (this.serverSocketFactory == null)
/* 385 */         msg = msg + ", no server SocketFactory";
/*     */       else {
/* 387 */         msg = msg + ", Server SocketFactory=" + this.serverSocketFactory.toString();
/*     */       }
/* 389 */       this.log.debug(msg);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 393 */       this.log.error("Could not start on port " + this.port, e);
/*     */     }
/*     */ 
/* 396 */     if (this.lookupPool == null)
/* 397 */       this.lookupPool = new BasicThreadPool("NamingBootstrap Pool");
/* 398 */     AcceptHandler handler = new AcceptHandler(null);
/* 399 */     this.lookupPool.run(handler);
/*     */   }
/*     */ 
/*     */   protected void initCustomSocketFactories()
/*     */   {
/* 408 */     InetAddress addr = this.rmiBindAddress != null ? this.rmiBindAddress : this.bindAddress;
/*     */ 
/* 410 */     if ((this.clientSocketFactory != null) && (addr != null))
/*     */     {
/*     */       try
/*     */       {
/* 415 */         Class csfClass = this.clientSocketFactory.getClass();
/* 416 */         Class[] parameterTypes = { String.class };
/* 417 */         Method m = csfClass.getMethod("setBindAddress", parameterTypes);
/* 418 */         Object[] args = { addr.getHostAddress() };
/* 419 */         m.invoke(this.clientSocketFactory, args);
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/* 423 */         this.log.warn("Socket factory does not support setBindAddress(String)");
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 428 */         this.log.warn("Failed to setBindAddress=" + addr + " on socket factory", e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 435 */       if (this.serverSocketFactory == null) {
/* 436 */         this.serverSocketFactory = new DefaultSocketFactory(addr);
/*     */       }
/* 439 */       else if (addr != null)
/*     */       {
/*     */         try
/*     */         {
/* 444 */           Class ssfClass = this.serverSocketFactory.getClass();
/* 445 */           Class[] parameterTypes = { String.class };
/* 446 */           Method m = ssfClass.getMethod("setBindAddress", parameterTypes);
/* 447 */           Object[] args = { addr.getHostAddress() };
/* 448 */           m.invoke(this.serverSocketFactory, args);
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/* 452 */           this.log.warn("Socket factory does not support setBindAddress(String)");
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 457 */           this.log.warn("Failed to setBindAddress=" + addr + " on socket factory", e);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 465 */       this.log.error("operation failed", e);
/* 466 */       this.serverSocketFactory = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private class BootstrapRequestHandler
/*     */     implements Runnable
/*     */   {
/*     */     private Socket socket;
/*     */ 
/*     */     BootstrapRequestHandler(Socket socket)
/*     */     {
/* 507 */       this.socket = socket;
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       try
/*     */       {
/* 514 */         OutputStream os = this.socket.getOutputStream();
/* 515 */         ObjectOutputStream out = new ObjectOutputStream(os);
/* 516 */         out.writeObject(Main.this.serverStub);
/* 517 */         out.close();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 521 */         Main.this.log.debug("Error writing response to " + this.socket.getInetAddress(), ex);
/*     */       }
/*     */       finally
/*     */       {
/*     */         try
/*     */         {
/* 527 */           this.socket.close();
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private class AcceptHandler
/*     */     implements Runnable
/*     */   {
/*     */     private AcceptHandler()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 474 */       boolean trace = Main.this.log.isTraceEnabled();
/* 475 */       while (Main.this.serverSocket != null)
/*     */       {
/* 477 */         Socket socket = null;
/*     */         try
/*     */         {
/* 481 */           socket = Main.this.serverSocket.accept();
/* 482 */           if (trace)
/* 483 */             Main.this.log.trace("Accepted bootstrap client: " + socket);
/* 484 */           Main.BootstrapRequestHandler handler = new Main.BootstrapRequestHandler(Main.this, socket);
/* 485 */           Main.this.lookupPool.run(handler);
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 490 */           if (Main.this.serverSocket == null)
/* 491 */             return;
/* 492 */           Main.this.log.error("Naming accept handler stopping", e);
/*     */         }
/*     */         catch (Throwable e)
/*     */         {
/* 496 */           Main.this.log.error("Unexpected exception during accept", e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jnp.server.Main
 * JD-Core Version:    0.6.0
 */