/*     */ package org.jnp.interfaces;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.ConnectException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.Socket;
/*     */ import java.net.UnknownHostException;
/*     */ import java.util.Hashtable;
/*     */ import javax.net.SocketFactory;
/*     */ 
/*     */ public class TimedSocketFactory extends SocketFactory
/*     */ {
/*     */   public static final String JNP_TIMEOUT = "jnp.timeout";
/*     */   public static final String JNP_SO_TIMEOUT = "jnp.sotimeout";
/*  45 */   protected int timeout = 0;
/*     */ 
/*  47 */   protected int soTimeout = 0;
/*     */ 
/*     */   public TimedSocketFactory()
/*     */   {
/*     */   }
/*     */ 
/*     */   public TimedSocketFactory(Hashtable env)
/*     */   {
/*  55 */     String value = (String)env.get("jnp.timeout");
/*  56 */     if (value != null)
/*  57 */       this.timeout = Integer.parseInt(value);
/*  58 */     value = (String)env.get("jnp.sotimeout");
/*  59 */     if (value != null)
/*  60 */       this.soTimeout = Integer.parseInt(value);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String host, int port) throws IOException, UnknownHostException
/*     */   {
/*  65 */     InetAddress hostAddr = InetAddress.getByName(host);
/*  66 */     return createSocket(hostAddr, port, null, 0);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(InetAddress hostAddr, int port) throws IOException {
/*  70 */     return createSocket(hostAddr, port, null, 0);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String host, int port, InetAddress localAddr, int localPort)
/*     */     throws IOException, UnknownHostException
/*     */   {
/*  76 */     InetAddress hostAddr = InetAddress.getByName(host);
/*  77 */     return createSocket(hostAddr, port, localAddr, localPort);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(InetAddress hostAddr, int port, InetAddress localAddr, int localPort) throws IOException
/*     */   {
/*  82 */     Socket socket = null;
/*  83 */     if (this.timeout <= 0)
/*  84 */       socket = new Socket(hostAddr, port, localAddr, localPort);
/*     */     else {
/*  86 */       socket = createSocket(hostAddr, port, localAddr, localPort, this.timeout);
/*     */     }
/*  88 */     socket.setSoTimeout(this.soTimeout);
/*  89 */     return socket;
/*     */   }
/*     */ 
/*     */   protected Socket createSocket(InetAddress hostAddr, int port, InetAddress localAddr, int localPort, int connectTimeout)
/*     */     throws IOException
/*     */   {
/*  96 */     ConnectThread t = new ConnectThread();
/*  97 */     Socket socket = t.createSocket(hostAddr, port, localAddr, localPort, connectTimeout);
/*  98 */     return socket;
/*     */   }
/*     */   class ConnectThread extends Thread {
/*     */     IOException ex;
/*     */     InetAddress hostAddr;
/*     */     InetAddress localAddr;
/*     */     int port;
/*     */     int localPort;
/*     */     int connectTimeout;
/*     */     Socket socket;
/*     */ 
/* 116 */     ConnectThread() { super();
/* 117 */       super.setDaemon(true);
/*     */     }
/*     */ 
/*     */     Socket createSocket(InetAddress hostAddr, int port, InetAddress localAddr, int localPort, int connectTimeout)
/*     */       throws IOException
/*     */     {
/* 128 */       this.hostAddr = hostAddr;
/* 129 */       this.port = port;
/* 130 */       this.localAddr = localAddr;
/* 131 */       this.localPort = localPort;
/* 132 */       this.connectTimeout = connectTimeout;
/*     */       try
/*     */       {
/* 136 */         synchronized (this)
/*     */         {
/* 139 */           start();
/*     */ 
/* 141 */           wait(connectTimeout);
/*     */         }
/*     */       }
/*     */       catch (InterruptedException e)
/*     */       {
/* 146 */         throw new ConnectException("Connect attempt timed out");
/*     */       }
/*     */ 
/* 150 */       if (this.ex != null) {
/* 151 */         throw this.ex;
/*     */       }
/* 153 */       if (this.socket == null) {
/* 154 */         throw new ConnectException("Connect attempt timed out");
/*     */       }
/* 156 */       return this.socket;
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       try
/*     */       {
/* 163 */         this.socket = new Socket(this.hostAddr, this.port, this.localAddr, this.localPort);
/* 164 */         synchronized (this)
/*     */         {
/* 166 */           notify();
/*     */         }
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 171 */         this.ex = e;
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jnp.interfaces.TimedSocketFactory
 * JD-Core Version:    0.6.0
 */