/*      */ package org.jnp.interfaces;
/*      */ 
/*      */ import java.io.BufferedInputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.ObjectInputStream;
/*      */ import java.io.Serializable;
/*      */ import java.lang.ref.WeakReference;
/*      */ import java.lang.reflect.Constructor;
/*      */ import java.lang.reflect.InvocationTargetException;
/*      */ import java.net.DatagramPacket;
/*      */ import java.net.InetAddress;
/*      */ import java.net.InetSocketAddress;
/*      */ import java.net.MulticastSocket;
/*      */ import java.net.Socket;
/*      */ import java.rmi.ConnectException;
/*      */ import java.rmi.MarshalledObject;
/*      */ import java.rmi.NoSuchObjectException;
/*      */ import java.rmi.RemoteException;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Arrays;
/*      */ import java.util.Collection;
/*      */ import java.util.Enumeration;
/*      */ import java.util.HashMap;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Iterator;
/*      */ import java.util.StringTokenizer;
/*      */ import javax.naming.Binding;
/*      */ import javax.naming.CannotProceedException;
/*      */ import javax.naming.CommunicationException;
/*      */ import javax.naming.ConfigurationException;
/*      */ import javax.naming.Context;
/*      */ import javax.naming.ContextNotEmptyException;
/*      */ import javax.naming.InitialContext;
/*      */ import javax.naming.InvalidNameException;
/*      */ import javax.naming.LinkRef;
/*      */ import javax.naming.Name;
/*      */ import javax.naming.NameParser;
/*      */ import javax.naming.NamingEnumeration;
/*      */ import javax.naming.NamingException;
/*      */ import javax.naming.NotContextException;
/*      */ import javax.naming.Reference;
/*      */ import javax.naming.Referenceable;
/*      */ import javax.naming.ServiceUnavailableException;
/*      */ import javax.naming.event.EventContext;
/*      */ import javax.naming.event.NamingListener;
/*      */ import javax.naming.spi.NamingManager;
/*      */ import javax.naming.spi.ResolveResult;
/*      */ import javax.net.SocketFactory;
/*      */ import org.jboss.logging.Logger;
/*      */ 
/*      */ public class NamingContext
/*      */   implements EventContext, Serializable
/*      */ {
/*      */   static final long serialVersionUID = 8906455608484282128L;
/*      */   public static final String JNP_SOCKET_FACTORY = "jnp.socketFactory";
/*      */   public static final String JNP_LOCAL_ADDRESS = "jnp.localAddress";
/*      */   public static final String JNP_LOCAL_PORT = "jnp.localPort";
/*      */   public static final String JNP_DISABLE_DISCOVERY = "jnp.disableDiscovery";
/*      */   public static final String JNP_PARTITION_NAME = "jnp.partitionName";
/*      */   public static final String JNP_DISCOVERY_GROUP = "jnp.discoveryGroup";
/*      */   public static final String JNP_DISCOVERY_PORT = "jnp.discoveryPort";
/*      */   public static final String JNP_DISCOVERY_TTL = "jnp.discoveryTTL";
/*      */   public static final String JNP_DISCOVERY_TIMEOUT = "jnp.discoveryTimeout";
/*      */   public static final String JNP_PARSED_NAME = "jnp.parsedName";
/*      */   public static final String JNP_USE_RELATIVE_NAME = "jnp.useRelativeName";
/*      */   public static final String JNP_MAX_RETRIES = "jnp.maxRetries";
/*      */   public static final String DEFAULT_DISCOVERY_GROUP_ADDRESS = "230.0.0.4";
/*      */   public static final int DEFAULT_DISCOVERY_GROUP_PORT = 1102;
/*      */   public static final int DEFAULT_DISCOVERY_TIMEOUT = 5000;
/*  158 */   public static int MAX_RETRIES = 1;
/*      */ 
/*  162 */   private static Logger log = Logger.getLogger(NamingContext.class);
/*      */ 
/*  166 */   public static Hashtable haServers = new Hashtable();
/*      */   public static Naming localServer;
/*      */   Naming naming;
/*      */   Hashtable env;
/*      */   Name prefix;
/*  190 */   NameParser parser = new NamingParser();
/*      */ 
/*  200 */   static HashMap cachedServers = new HashMap();
/*      */ 
/*      */   public static void setHANamingServerForPartition(String partitionName, Naming haServer)
/*      */   {
/*  170 */     haServers.put(partitionName, haServer);
/*      */   }
/*      */ 
/*      */   public static void removeHANamingServerForPartition(String partitionName)
/*      */   {
/*  175 */     haServers.remove(partitionName);
/*      */   }
/*      */ 
/*      */   public static Naming getHANamingServerForPartition(String partitionName)
/*      */   {
/*  180 */     return (Naming)haServers.get(partitionName);
/*      */   }
/*      */ 
/*      */   static void addServer(String name, Naming server)
/*      */   {
/*  205 */     synchronized (NamingContext.class)
/*      */     {
/*  207 */       cachedServers.put(name, new WeakReference(server));
/*      */     }
/*      */   }
/*      */ 
/*      */   static Naming getServer(String host, int port, Hashtable serverEnv)
/*      */     throws NamingException
/*      */   {
/*  215 */     String hostKey = host + ":" + port;
/*  216 */     WeakReference ref = (WeakReference)cachedServers.get(hostKey);
/*      */ 
/*  218 */     if (ref != null)
/*      */     {
/*  220 */       Naming server = (Naming)ref.get();
/*  221 */       if (server != null)
/*      */       {
/*  225 */         serverEnv.put("hostKey", hostKey);
/*  226 */         return server;
/*      */       }
/*      */     }
/*      */     NamingException ex;
/*      */     try
/*      */     {
/*  233 */       SocketFactory factory = loadSocketFactory(serverEnv);
/*      */       Socket s;
/*      */       try {
/*  238 */         InetAddress localAddr = null;
/*  239 */         int localPort = 0;
/*  240 */         String localAddrStr = (String)serverEnv.get("jnp.localAddress");
/*  241 */         String localPortStr = (String)serverEnv.get("jnp.localPort");
/*  242 */         if (localAddrStr != null)
/*  243 */           localAddr = InetAddress.getByName(localAddrStr);
/*  244 */         if (localPortStr != null)
/*  245 */           localPort = Integer.parseInt(localPortStr);
/*  246 */         s = factory.createSocket(host, port, localAddr, localPort);
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/*  250 */         NamingException ex = new ServiceUnavailableException("Failed to connect to server " + hostKey);
/*  251 */         ex.setRootCause(e);
/*  252 */         throw ex;
/*      */       }
/*      */ 
/*  256 */       BufferedInputStream bis = new BufferedInputStream(s.getInputStream());
/*  257 */       ObjectInputStream in = new ObjectInputStream(bis);
/*  258 */       MarshalledObject stub = (MarshalledObject)in.readObject();
/*  259 */       Naming server = (Naming)stub.get();
/*  260 */       s.close();
/*      */ 
/*  263 */       addServer(hostKey, server);
/*  264 */       serverEnv.put("hostKey", hostKey);
/*      */ 
/*  266 */       return server;
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  270 */       NamingException ex = new CommunicationException("Failed to retrieve stub from server " + hostKey);
/*  271 */       ex.setRootCause(e);
/*  272 */       throw ex;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  276 */       ex = new CommunicationException("Failed to connect to server " + hostKey);
/*  277 */       ex.setRootCause(e);
/*  278 */     }throw ex;
/*      */   }
/*      */ 
/*      */   static SocketFactory loadSocketFactory(Hashtable serverEnv)
/*      */     throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException
/*      */   {
/*  291 */     SocketFactory factory = null;
/*      */ 
/*  294 */     String socketFactoryName = (String)serverEnv.get("jnp.socketFactory");
/*  295 */     if ((socketFactoryName == null) || (socketFactoryName.equals(TimedSocketFactory.class.getName())))
/*      */     {
/*  298 */       factory = new TimedSocketFactory(serverEnv);
/*  299 */       return factory;
/*      */     }
/*      */ 
/*  305 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*  306 */     Class factoryClass = loader.loadClass(socketFactoryName);
/*      */     try
/*      */     {
/*  309 */       Class[] ctorSig = { Hashtable.class };
/*  310 */       Constructor ctor = factoryClass.getConstructor(ctorSig);
/*  311 */       Object[] ctorArgs = { serverEnv };
/*  312 */       factory = (SocketFactory)ctor.newInstance(ctorArgs);
/*      */     }
/*      */     catch (NoSuchMethodException e)
/*      */     {
/*  317 */       factory = (SocketFactory)factoryClass.newInstance();
/*      */     }
/*  319 */     return factory;
/*      */   }
/*      */ 
/*      */   static void removeServer(Hashtable serverEnv)
/*      */   {
/*  324 */     String host = "localhost";
/*  325 */     int port = 1099;
/*      */ 
/*  328 */     if (serverEnv.get("java.naming.provider.url") != null)
/*      */     {
/*  330 */       String providerURL = (String)serverEnv.get("java.naming.provider.url");
/*      */ 
/*  332 */       StringTokenizer tokenizer = new StringTokenizer(providerURL, ", ");
/*  333 */       while (tokenizer.hasMoreElements())
/*      */       {
/*  335 */         String url = tokenizer.nextToken();
/*      */         try
/*      */         {
/*  340 */           Name urlAsName = new NamingParser().parse(url);
/*  341 */           String server = parseNameForScheme(urlAsName, null);
/*  342 */           if (server != null)
/*  343 */             url = server;
/*  344 */           int colon = url.indexOf(':');
/*  345 */           if (colon < 0)
/*      */           {
/*  347 */             host = url.trim();
/*      */           }
/*      */           else
/*      */           {
/*  351 */             host = url.substring(0, colon).trim();
/*      */             try
/*      */             {
/*  354 */               port = Integer.parseInt(url.substring(colon + 1).trim());
/*      */             }
/*      */             catch (Exception ex)
/*      */             {
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*  363 */           synchronized (NamingContext.class)
/*      */           {
/*  365 */             cachedServers.remove(host + ":" + port);
/*      */           }
/*      */         }
/*      */         catch (NamingException ignored)
/*      */         {
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  375 */     Object hostKey = serverEnv.remove("hostKey");
/*  376 */     if (hostKey != null)
/*      */     {
/*  378 */       synchronized (NamingContext.class)
/*      */       {
/*  380 */         cachedServers.remove(hostKey);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   static String parseNameForScheme(Name n, Hashtable nameEnv)
/*      */     throws InvalidNameException
/*      */   {
/*  396 */     String serverInfo = null;
/*  397 */     if (n.size() > 0)
/*      */     {
/*  399 */       String scheme = n.get(0);
/*  400 */       int schemeLength = 0;
/*  401 */       if (scheme.startsWith("java:"))
/*  402 */         schemeLength = 5;
/*  403 */       else if (scheme.startsWith("jnp:"))
/*  404 */         schemeLength = 4;
/*  405 */       else if (scheme.startsWith("jnps:"))
/*  406 */         schemeLength = 5;
/*  407 */       else if (scheme.startsWith("jnp-http:"))
/*  408 */         schemeLength = 9;
/*  409 */       else if (scheme.startsWith("jnp-https:"))
/*  410 */         schemeLength = 10;
/*  411 */       if (schemeLength > 0)
/*      */       {
/*  414 */         n = (Name)n.clone();
/*  415 */         String suffix = scheme.substring(schemeLength);
/*  416 */         if (suffix.length() == 0)
/*      */         {
/*  419 */           n.remove(0);
/*  420 */           if ((n.size() > 1) && (n.get(0).equals("")))
/*      */           {
/*  424 */             serverInfo = n.get(1);
/*  425 */             n.remove(0);
/*  426 */             n.remove(0);
/*      */ 
/*  428 */             if ((n.size() == 1) && (n.get(0).length() == 0)) {
/*  429 */               n.remove(0);
/*      */             }
/*      */           }
/*      */         }
/*      */         else
/*      */         {
/*  435 */           n.remove(0);
/*  436 */           n.add(0, suffix);
/*      */         }
/*  438 */         if (nameEnv != null)
/*  439 */           nameEnv.put("jnp.parsedName", n);
/*      */       }
/*      */     }
/*  442 */     return serverInfo;
/*      */   }
/*      */ 
/*      */   public static void setLocal(Naming server)
/*      */   {
/*  447 */     localServer = server;
/*      */   }
/*      */ 
/*      */   public NamingContext(Hashtable e, Name baseName, Naming server)
/*      */     throws NamingException
/*      */   {
/*  454 */     if (baseName == null)
/*  455 */       this.prefix = this.parser.parse("");
/*      */     else {
/*  457 */       this.prefix = baseName;
/*      */     }
/*  459 */     if (e != null)
/*  460 */       this.env = ((Hashtable)e.clone());
/*      */     else {
/*  462 */       this.env = new Hashtable();
/*      */     }
/*  464 */     this.naming = server;
/*      */   }
/*      */ 
/*      */   public Naming getNaming()
/*      */   {
/*  470 */     return this.naming;
/*      */   }
/*      */ 
/*      */   public void setNaming(Naming server)
/*      */   {
/*  475 */     this.naming = server;
/*      */   }
/*      */ 
/*      */   public void rebind(String name, Object obj)
/*      */     throws NamingException
/*      */   {
/*  482 */     rebind(getNameParser(name).parse(name), obj);
/*      */   }
/*      */ 
/*      */   public void rebind(Name name, Object obj)
/*      */     throws NamingException
/*      */   {
/*  488 */     Hashtable refEnv = getEnv(name);
/*  489 */     checkRef(refEnv);
/*  490 */     Name parsedName = (Name)refEnv.get("jnp.parsedName");
/*  491 */     if (parsedName != null) {
/*  492 */       name = parsedName;
/*      */     }
/*      */ 
/*  495 */     obj = getStateToBind(obj, name, refEnv);
/*      */     try
/*      */     {
/*  499 */       String className = null;
/*      */ 
/*  502 */       if ((obj instanceof Referenceable)) {
/*  503 */         obj = ((Referenceable)obj).getReference();
/*      */       }
/*  505 */       if (!(obj instanceof Reference))
/*      */       {
/*  507 */         if (obj != null) {
/*  508 */           className = obj.getClass().getName();
/*      */         }
/*  510 */         obj = new MarshalledValuePair(obj);
/*      */       }
/*      */       else
/*      */       {
/*  514 */         className = ((Reference)obj).getClassName();
/*      */       }
/*      */       try
/*      */       {
/*  518 */         this.naming.rebind(getAbsoluteName(name), obj, className);
/*      */       }
/*      */       catch (RemoteException re)
/*      */       {
/*  523 */         if (handleStaleNamingStub(re, refEnv))
/*      */         {
/*  526 */           this.naming.rebind(getAbsoluteName(name), obj, className);
/*      */         }
/*      */         else
/*      */         {
/*  531 */           throw re;
/*      */         }
/*      */       }
/*      */     }
/*      */     catch (CannotProceedException cpe)
/*      */     {
/*  537 */       cpe.setEnvironment(refEnv);
/*  538 */       Context cctx = NamingManager.getContinuationContext(cpe);
/*  539 */       cctx.rebind(cpe.getRemainingName(), obj);
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  543 */       this.naming = null;
/*  544 */       removeServer(refEnv);
/*  545 */       NamingException ex = new CommunicationException();
/*  546 */       ex.setRootCause(e);
/*  547 */       throw ex;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void bind(String name, Object obj)
/*      */     throws NamingException
/*      */   {
/*  554 */     bind(getNameParser(name).parse(name), obj);
/*      */   }
/*      */ 
/*      */   public void bind(Name name, Object obj)
/*      */     throws NamingException
/*      */   {
/*  560 */     Hashtable refEnv = getEnv(name);
/*  561 */     checkRef(refEnv);
/*  562 */     Name parsedName = (Name)refEnv.get("jnp.parsedName");
/*  563 */     if (parsedName != null) {
/*  564 */       name = parsedName;
/*      */     }
/*      */ 
/*  567 */     obj = getStateToBind(obj, name, refEnv);
/*      */     try
/*      */     {
/*  571 */       String className = null;
/*      */ 
/*  574 */       if ((obj instanceof Referenceable)) {
/*  575 */         obj = ((Referenceable)obj).getReference();
/*      */       }
/*  577 */       if (!(obj instanceof Reference))
/*      */       {
/*  579 */         if (obj != null) {
/*  580 */           className = obj.getClass().getName();
/*      */         }
/*      */ 
/*  583 */         obj = new MarshalledValuePair(obj);
/*      */       }
/*      */       else
/*      */       {
/*  587 */         className = ((Reference)obj).getClassName();
/*      */       }
/*  589 */       name = getAbsoluteName(name);
/*      */       try
/*      */       {
/*  593 */         this.naming.bind(name, obj, className);
/*      */       }
/*      */       catch (RemoteException re)
/*      */       {
/*  598 */         if (handleStaleNamingStub(re, refEnv))
/*      */         {
/*  601 */           this.naming.bind(name, obj, className);
/*      */         }
/*      */         else
/*      */         {
/*  606 */           throw re;
/*      */         }
/*      */       }
/*      */     }
/*      */     catch (CannotProceedException cpe)
/*      */     {
/*  612 */       cpe.setEnvironment(refEnv);
/*  613 */       Context cctx = NamingManager.getContinuationContext(cpe);
/*  614 */       cctx.bind(cpe.getRemainingName(), obj);
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  618 */       this.naming = null;
/*  619 */       removeServer(refEnv);
/*  620 */       NamingException ex = new CommunicationException();
/*  621 */       ex.setRootCause(e);
/*  622 */       throw ex;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object lookup(String name)
/*      */     throws NamingException
/*      */   {
/*  629 */     return lookup(getNameParser(name).parse(name));
/*      */   }
/*      */ 
/*      */   public Object lookup(Name name)
/*      */     throws NamingException
/*      */   {
/*  635 */     Hashtable refEnv = getEnv(name);
/*  636 */     checkRef(refEnv);
/*  637 */     Name parsedName = (Name)refEnv.get("jnp.parsedName");
/*  638 */     if (parsedName != null) {
/*  639 */       name = parsedName;
/*      */     }
/*      */ 
/*  642 */     if (name.isEmpty())
/*  643 */       return new NamingContext(refEnv, this.prefix, this.naming);
/*      */     NamingException ex;
/*      */     try {
/*  647 */       int maxTries = 1;
/*      */       try
/*      */       {
/*  650 */         String n = (String)refEnv.get("jnp.maxRetries");
/*  651 */         if (n != null)
/*  652 */           maxTries = Integer.parseInt(n);
/*  653 */         if (maxTries <= 0)
/*  654 */           maxTries = 1;
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  658 */         log.debug("Failed to get JNP_MAX_RETRIES, using 1", e);
/*      */       }
/*  660 */       Name n = getAbsoluteName(name);
/*  661 */       Object res = null;
/*  662 */       boolean trace = log.isTraceEnabled();
/*  663 */       for (int i = 0; i < maxTries; i++)
/*      */       {
/*      */         try
/*      */         {
/*      */           try
/*      */           {
/*  669 */             res = this.naming.lookup(n);
/*      */           }
/*      */           catch (RemoteException re)
/*      */           {
/*  674 */             if (handleStaleNamingStub(re, refEnv))
/*      */             {
/*  677 */               res = this.naming.lookup(n);
/*      */             }
/*      */             else
/*      */             {
/*  682 */               throw re;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */         catch (ConnectException ce)
/*      */         {
/*  690 */           int retries = maxTries - i - 1;
/*  691 */           if (trace) {
/*  692 */             log.trace("Connect failed, retry count: " + retries, ce);
/*      */           }
/*  694 */           if (retries > 0)
/*      */           {
/*      */             try
/*      */             {
/*  698 */               Thread.sleep(1L);
/*      */             }
/*      */             catch (InterruptedException ignored)
/*      */             {
/*      */             }
/*      */           }
/*      */           else
/*      */           {
/*  706 */             throw ce;
/*      */           }
/*      */         }
/*      */       }
/*  709 */       if ((res instanceof MarshalledValuePair))
/*      */       {
/*  711 */         MarshalledValuePair mvp = (MarshalledValuePair)res;
/*  712 */         Object storedObj = mvp.get();
/*  713 */         return getObjectInstanceWrapFailure(storedObj, name, refEnv);
/*      */       }
/*  715 */       if ((res instanceof MarshalledObject))
/*      */       {
/*  717 */         MarshalledObject mo = (MarshalledObject)res;
/*  718 */         return mo.get();
/*      */       }
/*  720 */       if ((res instanceof Context))
/*      */       {
/*  723 */         Enumeration keys = refEnv.keys();
/*  724 */         while (keys.hasMoreElements())
/*      */         {
/*  726 */           String key = (String)keys.nextElement();
/*  727 */           ((Context)res).addToEnvironment(key, refEnv.get(key));
/*      */         }
/*  729 */         return res;
/*      */       }
/*  731 */       if ((res instanceof ResolveResult))
/*      */       {
/*  734 */         ResolveResult rr = (ResolveResult)res;
/*  735 */         Object resolveRes = rr.getResolvedObj();
/*      */         Object instanceID;
/*      */         Object context;
/*      */         Object instanceID;
/*  739 */         if ((resolveRes instanceof LinkRef))
/*      */         {
/*  741 */           Object context = resolveLink(resolveRes, null);
/*  742 */           instanceID = ((LinkRef)resolveRes).getLinkName();
/*      */         }
/*      */         else
/*      */         {
/*  746 */           context = getObjectInstanceWrapFailure(resolveRes, name, refEnv);
/*  747 */           instanceID = context;
/*      */         }
/*      */ 
/*  750 */         if (!(context instanceof Context))
/*      */         {
/*  752 */           throw new NotContextException(instanceID + " is not a Context");
/*      */         }
/*  754 */         Context ncontext = (Context)context;
/*  755 */         return ncontext.lookup(rr.getRemainingName());
/*      */       }
/*  757 */       if ((res instanceof LinkRef))
/*      */       {
/*  760 */         res = resolveLink(res, refEnv);
/*      */       }
/*  762 */       else if ((res instanceof Reference))
/*      */       {
/*  765 */         res = getObjectInstanceWrapFailure(res, name, refEnv);
/*  766 */         if ((res instanceof LinkRef)) {
/*  767 */           res = resolveLink(res, refEnv);
/*      */         }
/*      */       }
/*  770 */       return res;
/*      */     }
/*      */     catch (CannotProceedException cpe)
/*      */     {
/*  774 */       cpe.setEnvironment(refEnv);
/*  775 */       Context cctx = NamingManager.getContinuationContext(cpe);
/*  776 */       return cctx.lookup(cpe.getRemainingName());
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  780 */       this.naming = null;
/*  781 */       removeServer(refEnv);
/*  782 */       NamingException ex = new CommunicationException();
/*  783 */       ex.setRootCause(e);
/*  784 */       throw ex;
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*  788 */       ex = new CommunicationException();
/*  789 */       ex.setRootCause(e);
/*  790 */     }throw ex;
/*      */   }
/*      */ 
/*      */   public void unbind(String name)
/*      */     throws NamingException
/*      */   {
/*  797 */     unbind(getNameParser(name).parse(name));
/*      */   }
/*      */ 
/*      */   public void unbind(Name name)
/*      */     throws NamingException
/*      */   {
/*  804 */     Hashtable refEnv = getEnv(name);
/*  805 */     checkRef(refEnv);
/*  806 */     Name parsedName = (Name)refEnv.get("jnp.parsedName");
/*  807 */     if (parsedName != null) {
/*  808 */       name = parsedName;
/*      */     }
/*      */     try
/*      */     {
/*      */       try
/*      */       {
/*  814 */         this.naming.unbind(getAbsoluteName(name));
/*      */       }
/*      */       catch (RemoteException re)
/*      */       {
/*  819 */         if (handleStaleNamingStub(re, refEnv))
/*      */         {
/*  822 */           this.naming.unbind(getAbsoluteName(name));
/*      */         }
/*      */         else
/*      */         {
/*  827 */           throw re;
/*      */         }
/*      */       }
/*      */     }
/*      */     catch (CannotProceedException cpe)
/*      */     {
/*  833 */       cpe.setEnvironment(refEnv);
/*  834 */       Context cctx = NamingManager.getContinuationContext(cpe);
/*  835 */       cctx.unbind(cpe.getRemainingName());
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  839 */       this.naming = null;
/*  840 */       removeServer(refEnv);
/*  841 */       NamingException ex = new CommunicationException();
/*  842 */       ex.setRootCause(e);
/*  843 */       throw ex;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void rename(String oldname, String newname)
/*      */     throws NamingException
/*      */   {
/*  850 */     rename(getNameParser(oldname).parse(oldname), getNameParser(newname).parse(newname));
/*      */   }
/*      */ 
/*      */   public void rename(Name oldName, Name newName)
/*      */     throws NamingException
/*      */   {
/*  856 */     bind(newName, lookup(oldName));
/*  857 */     unbind(oldName);
/*      */   }
/*      */ 
/*      */   public NamingEnumeration list(String name)
/*      */     throws NamingException
/*      */   {
/*  863 */     return list(getNameParser(name).parse(name));
/*      */   }
/*      */ 
/*      */   public NamingEnumeration list(Name name)
/*      */     throws NamingException
/*      */   {
/*  869 */     Hashtable refEnv = getEnv(name);
/*  870 */     checkRef(refEnv);
/*  871 */     Name parsedName = (Name)refEnv.get("jnp.parsedName");
/*  872 */     if (parsedName != null)
/*  873 */       name = parsedName;
/*      */     NamingException ex;
/*      */     try {
/*  877 */       Collection c = null;
/*      */       try
/*      */       {
/*  880 */         c = this.naming.list(getAbsoluteName(name));
/*      */       }
/*      */       catch (RemoteException re)
/*      */       {
/*  885 */         if (handleStaleNamingStub(re, refEnv))
/*      */         {
/*  888 */           c = this.naming.list(getAbsoluteName(name));
/*      */         }
/*      */         else
/*      */         {
/*  893 */           throw re;
/*      */         }
/*      */       }
/*  896 */       return new NamingEnumerationImpl(c);
/*      */     }
/*      */     catch (CannotProceedException cpe)
/*      */     {
/*  900 */       cpe.setEnvironment(refEnv);
/*  901 */       Context cctx = NamingManager.getContinuationContext(cpe);
/*  902 */       return cctx.list(cpe.getRemainingName());
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  906 */       this.naming = null;
/*  907 */       removeServer(refEnv);
/*  908 */       ex = new CommunicationException();
/*  909 */       ex.setRootCause(e);
/*  910 */     }throw ex;
/*      */   }
/*      */ 
/*      */   public NamingEnumeration listBindings(String name)
/*      */     throws NamingException
/*      */   {
/*  917 */     return listBindings(getNameParser(name).parse(name));
/*      */   }
/*      */ 
/*      */   public NamingEnumeration listBindings(Name name)
/*      */     throws NamingException
/*      */   {
/*  923 */     Hashtable refEnv = getEnv(name);
/*  924 */     checkRef(refEnv);
/*  925 */     Name parsedName = (Name)refEnv.get("jnp.parsedName");
/*  926 */     if (parsedName != null)
/*  927 */       name = parsedName;
/*      */     NamingException ex;
/*      */     try
/*      */     {
/*  932 */       Collection bindings = null;
/*      */       try
/*      */       {
/*  936 */         bindings = this.naming.listBindings(getAbsoluteName(name));
/*      */       }
/*      */       catch (RemoteException re)
/*      */       {
/*  941 */         if (handleStaleNamingStub(re, refEnv))
/*      */         {
/*  944 */           bindings = this.naming.listBindings(getAbsoluteName(name));
/*      */         }
/*      */         else
/*      */         {
/*  949 */           throw re;
/*      */         }
/*      */       }
/*  952 */       Collection realBindings = new ArrayList(bindings.size());
/*      */ 
/*  955 */       Iterator i = bindings.iterator();
/*  956 */       while (i.hasNext())
/*      */       {
/*  958 */         Binding binding = (Binding)i.next();
/*  959 */         Object obj = binding.getObject();
/*  960 */         if ((obj instanceof MarshalledValuePair))
/*      */         {
/*      */           try
/*      */           {
/*  964 */             obj = ((MarshalledValuePair)obj).get();
/*      */           }
/*      */           catch (ClassNotFoundException e)
/*      */           {
/*  968 */             NamingException ex = new CommunicationException();
/*  969 */             ex.setRootCause(e);
/*  970 */             throw ex;
/*      */           }
/*      */         }
/*  973 */         else if ((obj instanceof MarshalledObject))
/*      */         {
/*      */           try
/*      */           {
/*  977 */             obj = ((MarshalledObject)obj).get();
/*      */           }
/*      */           catch (ClassNotFoundException e)
/*      */           {
/*  981 */             NamingException ex = new CommunicationException();
/*  982 */             ex.setRootCause(e);
/*  983 */             throw ex;
/*      */           }
/*      */         }
/*  986 */         realBindings.add(new Binding(binding.getName(), binding.getClassName(), obj));
/*      */       }
/*      */ 
/*  990 */       return new NamingEnumerationImpl(realBindings);
/*      */     }
/*      */     catch (CannotProceedException cpe)
/*      */     {
/*  994 */       cpe.setEnvironment(refEnv);
/*  995 */       Context cctx = NamingManager.getContinuationContext(cpe);
/*  996 */       return cctx.listBindings(cpe.getRemainingName());
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/* 1000 */       this.naming = null;
/* 1001 */       removeServer(refEnv);
/* 1002 */       ex = new CommunicationException();
/* 1003 */       ex.setRootCause(e);
/* 1004 */     }throw ex;
/*      */   }
/*      */ 
/*      */   public String composeName(String name, String prefix)
/*      */     throws NamingException
/*      */   {
/* 1011 */     Name result = composeName(this.parser.parse(name), this.parser.parse(prefix));
/*      */ 
/* 1013 */     return result.toString();
/*      */   }
/*      */ 
/*      */   public Name composeName(Name name, Name prefix)
/*      */     throws NamingException
/*      */   {
/* 1019 */     Name result = (Name)(Name)prefix.clone();
/* 1020 */     result.addAll(name);
/* 1021 */     return result;
/*      */   }
/*      */ 
/*      */   public NameParser getNameParser(String name)
/*      */     throws NamingException
/*      */   {
/* 1027 */     return this.parser;
/*      */   }
/*      */ 
/*      */   public NameParser getNameParser(Name name)
/*      */     throws NamingException
/*      */   {
/* 1033 */     return getNameParser(name.toString());
/*      */   }
/*      */ 
/*      */   public Context createSubcontext(String name)
/*      */     throws NamingException
/*      */   {
/* 1039 */     return createSubcontext(getNameParser(name).parse(name));
/*      */   }
/*      */ 
/*      */   public Context createSubcontext(Name name)
/*      */     throws NamingException
/*      */   {
/* 1045 */     if (name.size() == 0) {
/* 1046 */       throw new InvalidNameException("Cannot pass an empty name to createSubcontext");
/*      */     }
/* 1048 */     Hashtable refEnv = getEnv(name);
/* 1049 */     checkRef(refEnv);
/* 1050 */     Name parsedName = (Name)refEnv.get("jnp.parsedName");
/* 1051 */     if (parsedName != null)
/* 1052 */       name = parsedName;
/*      */     NamingException ex;
/*      */     try {
/* 1056 */       name = getAbsoluteName(name);
/*      */       try
/*      */       {
/* 1059 */         return this.naming.createSubcontext(name);
/*      */       }
/*      */       catch (RemoteException re)
/*      */       {
/* 1064 */         if (handleStaleNamingStub(re, refEnv))
/*      */         {
/* 1067 */           return this.naming.createSubcontext(name);
/*      */         }
/*      */ 
/* 1072 */         throw re;
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (CannotProceedException cpe)
/*      */     {
/* 1078 */       cpe.setEnvironment(refEnv);
/* 1079 */       Context cctx = NamingManager.getContinuationContext(cpe);
/* 1080 */       return cctx.createSubcontext(cpe.getRemainingName());
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/* 1084 */       this.naming = null;
/* 1085 */       removeServer(refEnv);
/* 1086 */       ex = new CommunicationException();
/* 1087 */       ex.setRootCause(e);
/* 1088 */     }throw ex;
/*      */   }
/*      */ 
/*      */   public Object addToEnvironment(String propName, Object propVal)
/*      */     throws NamingException
/*      */   {
/* 1095 */     Object old = this.env.get(propName);
/* 1096 */     this.env.put(propName, propVal);
/* 1097 */     return old;
/*      */   }
/*      */ 
/*      */   public Object removeFromEnvironment(String propName)
/*      */     throws NamingException
/*      */   {
/* 1103 */     return this.env.remove(propName);
/*      */   }
/*      */ 
/*      */   public Hashtable getEnvironment()
/*      */     throws NamingException
/*      */   {
/* 1109 */     return this.env;
/*      */   }
/*      */ 
/*      */   public void close()
/*      */     throws NamingException
/*      */   {
/* 1115 */     this.env = null;
/* 1116 */     this.naming = null;
/*      */   }
/*      */ 
/*      */   public String getNameInNamespace()
/*      */     throws NamingException
/*      */   {
/* 1122 */     return this.prefix.toString();
/*      */   }
/*      */ 
/*      */   public void destroySubcontext(String name)
/*      */     throws NamingException
/*      */   {
/* 1128 */     destroySubcontext(getNameParser(name).parse(name));
/*      */   }
/*      */ 
/*      */   public void destroySubcontext(Name name)
/*      */     throws NamingException
/*      */   {
/* 1134 */     if (!list(name).hasMore())
/*      */     {
/* 1136 */       unbind(name);
/*      */     }
/*      */     else
/* 1139 */       throw new ContextNotEmptyException();
/*      */   }
/*      */ 
/*      */   public Object lookupLink(String name)
/*      */     throws NamingException
/*      */   {
/* 1145 */     return lookupLink(getNameParser(name).parse(name));
/*      */   }
/*      */ 
/*      */   public Object lookupLink(Name name)
/*      */     throws NamingException
/*      */   {
/* 1159 */     if (name.isEmpty()) {
/* 1160 */       return lookup(name);
/*      */     }
/* 1162 */     Object link = null;
/*      */     try
/*      */     {
/* 1165 */       Name n = getAbsoluteName(name);
/*      */       try
/*      */       {
/* 1168 */         link = this.naming.lookup(n);
/*      */       }
/*      */       catch (RemoteException re)
/*      */       {
/* 1174 */         if (handleStaleNamingStub(re, this.env))
/*      */         {
/* 1177 */           link = this.naming.lookup(n);
/*      */         }
/*      */         else
/*      */         {
/* 1182 */           throw re;
/*      */         }
/*      */       }
/* 1185 */       if ((!(link instanceof LinkRef)) && ((link instanceof Reference))) {
/* 1186 */         link = getObjectInstance(link, name, null);
/*      */       }
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/* 1191 */       this.naming = null;
/* 1192 */       removeServer(this.env);
/* 1193 */       NamingException ex = new CommunicationException();
/* 1194 */       ex.setRootCause(e);
/* 1195 */       throw ex;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1199 */       NamingException ex = new NamingException("Could not lookup link");
/* 1200 */       ex.setRemainingName(name);
/* 1201 */       ex.setRootCause(e);
/* 1202 */       throw ex;
/*      */     }
/* 1204 */     return link;
/*      */   }
/*      */ 
/*      */   public void addNamingListener(Name target, int scope, NamingListener l)
/*      */     throws NamingException
/*      */   {
/* 1212 */     throw new UnsupportedOperationException("This is not supported currently");
/*      */   }
/*      */ 
/*      */   public void addNamingListener(String target, int scope, NamingListener l)
/*      */     throws NamingException
/*      */   {
/* 1219 */     throw new UnsupportedOperationException("This is not supported currently");
/*      */   }
/*      */ 
/*      */   public void removeNamingListener(NamingListener l)
/*      */     throws NamingException
/*      */   {
/* 1226 */     throw new UnsupportedOperationException("This is not supported currently");
/*      */   }
/*      */ 
/*      */   public boolean targetMustExist()
/*      */     throws NamingException
/*      */   {
/* 1233 */     return false;
/*      */   }
/*      */ 
/*      */   protected Object resolveLink(Object res, Hashtable refEnv)
/*      */     throws NamingException
/*      */   {
/* 1240 */     Object linkResult = null;
/*      */     try
/*      */     {
/* 1243 */       LinkRef link = (LinkRef)res;
/* 1244 */       String ref = link.getLinkName();
/* 1245 */       if (ref.startsWith("./"))
/* 1246 */         linkResult = lookup(ref.substring(2));
/* 1247 */       else if (refEnv != null)
/* 1248 */         linkResult = new InitialContext(refEnv).lookup(ref);
/*      */       else
/* 1250 */         linkResult = new InitialContext().lookup(ref);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1254 */       NamingException ex = new NamingException("Could not dereference object");
/* 1255 */       ex.setRootCause(e);
/* 1256 */       throw ex;
/*      */     }
/* 1258 */     return linkResult;
/*      */   }
/*      */ 
/*      */   private boolean useAbsoluteName(Hashtable env)
/*      */   {
/* 1275 */     if (env == null)
/* 1276 */       return true;
/* 1277 */     String useRelativeName = (String)env.get("jnp.useRelativeName");
/* 1278 */     return Boolean.valueOf(useRelativeName) == Boolean.FALSE;
/*      */   }
/*      */ 
/*      */   private Object getStateToBind(Object obj, Name name, Hashtable env)
/*      */     throws NamingException
/*      */   {
/* 1293 */     if (useAbsoluteName(env))
/* 1294 */       name = getAbsoluteName(name);
/* 1295 */     return NamingManager.getStateToBind(obj, name, this, env);
/*      */   }
/*      */ 
/*      */   private Object getObjectInstance(Object obj, Name name, Hashtable env)
/*      */     throws Exception
/*      */   {
/* 1310 */     if (useAbsoluteName(env))
/* 1311 */       name = getAbsoluteName(name);
/* 1312 */     return NamingManager.getObjectInstance(obj, name, this, env);
/*      */   }
/*      */ 
/*      */   private Object getObjectInstanceWrapFailure(Object obj, Name name, Hashtable env)
/*      */     throws NamingException
/*      */   {
/*      */     NamingException ex;
/*      */     try
/*      */     {
/* 1329 */       return getObjectInstance(obj, name, env);
/*      */     }
/*      */     catch (NamingException e)
/*      */     {
/* 1333 */       throw e;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1337 */       ex = new NamingException("Could not dereference object");
/* 1338 */       ex.setRootCause(e);
/* 1339 */     }throw ex;
/*      */   }
/*      */ 
/*      */   private Naming discoverServer(Hashtable serverEnv)
/*      */     throws NamingException
/*      */   {
/* 1349 */     boolean trace = log.isTraceEnabled();
/*      */ 
/* 1351 */     String disableDiscovery = (String)serverEnv.get("jnp.disableDiscovery");
/* 1352 */     if (Boolean.valueOf(disableDiscovery) == Boolean.TRUE)
/*      */     {
/* 1354 */       if (trace)
/* 1355 */         log.trace("Skipping discovery due to disable flag");
/* 1356 */       return null;
/*      */     }
/*      */ 
/* 1361 */     String partitionName = (String)serverEnv.get("jnp.partitionName");
/* 1362 */     Naming server = null;
/* 1363 */     if (partitionName != null)
/*      */     {
/* 1365 */       server = getHANamingServerForPartition(partitionName);
/* 1366 */       if (server != null) {
/* 1367 */         return server;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1374 */     MulticastSocket s = null;
/* 1375 */     InetAddress iaGroup = null;
/*      */     try
/*      */     {
/* 1378 */       String group = "230.0.0.4";
/* 1379 */       int port = 1102;
/* 1380 */       int timeout = 5000;
/* 1381 */       int ttl = 16;
/*      */ 
/* 1383 */       String discoveryGroup = (String)serverEnv.get("jnp.discoveryGroup");
/* 1384 */       if (discoveryGroup != null) {
/* 1385 */         group = discoveryGroup;
/*      */       }
/* 1387 */       String discoveryTTL = (String)serverEnv.get("jnp.discoveryTTL");
/* 1388 */       if (discoveryTTL != null) {
/* 1389 */         ttl = Integer.parseInt(discoveryTTL);
/*      */       }
/* 1391 */       String discoveryTimeout = (String)serverEnv.get("jnp.discoveryTimeout");
/* 1392 */       if (discoveryTimeout == null)
/*      */       {
/* 1395 */         discoveryTimeout = (String)serverEnv.get("DISCOVERY_TIMEOUT");
/*      */       }
/* 1397 */       if ((discoveryTimeout != null) && (!discoveryTimeout.equals(""))) {
/* 1398 */         timeout = Integer.parseInt(discoveryTimeout);
/*      */       }
/* 1400 */       String discoveryGroupPort = (String)serverEnv.get("jnp.discoveryPort");
/* 1401 */       if (discoveryGroupPort == null)
/*      */       {
/* 1404 */         discoveryGroupPort = (String)serverEnv.get("DISCOVERY_GROUP");
/*      */       }
/* 1406 */       if ((discoveryGroupPort != null) && (!discoveryGroupPort.equals("")))
/*      */       {
/* 1408 */         int colon = discoveryGroupPort.indexOf(':');
/* 1409 */         if (colon < 0)
/*      */         {
/*      */           try
/*      */           {
/* 1414 */             port = Integer.parseInt(discoveryGroupPort);
/*      */           }
/*      */           catch (Exception ex)
/*      */           {
/* 1418 */             log.warn("Failed to parse port: " + discoveryGroupPort, ex);
/*      */           }
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/* 1424 */           group = discoveryGroupPort.substring(0, colon);
/* 1425 */           String portStr = discoveryGroupPort.substring(colon + 1);
/*      */           try
/*      */           {
/* 1428 */             port = Integer.parseInt(portStr);
/*      */           }
/*      */           catch (Exception ex)
/*      */           {
/* 1432 */             log.warn("Failed to parse port: " + portStr, ex);
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/* 1437 */       iaGroup = InetAddress.getByName(group);
/* 1438 */       String localAddrStr = (String)serverEnv.get("jnp.localAddress");
/* 1439 */       String localPortStr = (String)serverEnv.get("jnp.localPort");
/* 1440 */       int localPort = 0;
/* 1441 */       if (localPortStr != null)
/* 1442 */         localPort = Integer.parseInt(localPortStr);
/* 1443 */       if (localAddrStr != null)
/*      */       {
/* 1445 */         InetSocketAddress localAddr = new InetSocketAddress(localAddrStr, localPort);
/* 1446 */         s = new MulticastSocket(localAddr);
/*      */       }
/*      */       else
/*      */       {
/* 1450 */         s = new MulticastSocket(localPort);
/*      */       }
/* 1452 */       s.setSoTimeout(timeout);
/* 1453 */       s.setTimeToLive(ttl);
/* 1454 */       if (log.isTraceEnabled())
/* 1455 */         log.trace("TTL on multicast discovery socket is " + ttl);
/* 1456 */       s.joinGroup(iaGroup);
/* 1457 */       if (trace) {
/* 1458 */         log.trace("MulticastSocket: " + s);
/*      */       }
/*      */ 
/* 1461 */       StringBuffer data = new StringBuffer("GET_ADDRESS");
/* 1462 */       if (partitionName != null)
/* 1463 */         data.append(":" + partitionName);
/* 1464 */       byte[] buf = data.toString().getBytes();
/* 1465 */       DatagramPacket packet = new DatagramPacket(buf, buf.length, iaGroup, port);
/* 1466 */       if (trace)
/* 1467 */         log.trace("Sending discovery packet(" + data + ") to: " + iaGroup + ":" + port);
/* 1468 */       s.send(packet);
/*      */ 
/* 1472 */       buf = new byte[50];
/* 1473 */       packet = new DatagramPacket(buf, buf.length);
/* 1474 */       s.receive(packet);
/* 1475 */       String myServer = new String(packet.getData()).trim();
/* 1476 */       if (trace)
/* 1477 */         log.trace("Received answer packet: " + myServer);
/* 1478 */       while ((myServer != null) && (myServer.startsWith("GET_ADDRESS")))
/*      */       {
/* 1480 */         Arrays.fill(buf, 0);
/* 1481 */         packet.setLength(buf.length);
/* 1482 */         s.receive(packet);
/* 1483 */         byte[] reply = packet.getData();
/* 1484 */         myServer = new String(reply).trim();
/* 1485 */         if (trace) {
/* 1486 */           log.trace("Received answer packet: " + myServer);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1491 */       int colon = myServer.indexOf(':');
/* 1492 */       if (colon >= 0)
/*      */       {
/* 1494 */         String serverHost = myServer.substring(0, colon);
/* 1495 */         int serverPort = Integer.valueOf(myServer.substring(colon + 1)).intValue();
/* 1496 */         server = getServer(serverHost, serverPort, serverEnv);
/*      */       }
/* 1498 */       Naming localNaming1 = server;
/*      */       return localNaming1;
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/* 1502 */       if (trace)
/* 1503 */         log.trace("Discovery failed", e);
/* 1504 */       NamingException ex = new CommunicationException(e.getMessage());
/* 1505 */       ex.setRootCause(e);
/* 1506 */       throw ex;
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/* 1512 */         if (s != null)
/* 1513 */           s.leaveGroup(iaGroup);
/*      */       }
/*      */       catch (Exception ignore)
/*      */       {
/*      */       }
/*      */       try
/*      */       {
/* 1520 */         if (s != null)
/* 1521 */           s.close();
/*      */       } catch (Exception ignore) {
/*      */       }
/*      */     }
/* 1525 */     throw localObject;
/*      */   }
/*      */ 
/*      */   private void checkRef(Hashtable refEnv)
/*      */     throws NamingException
/*      */   {
/* 1532 */     if (this.naming == null)
/*      */     {
/* 1534 */       String host = "localhost";
/* 1535 */       int port = 1099;
/* 1536 */       Exception serverEx = null;
/*      */ 
/* 1539 */       String urls = (String)refEnv.get("java.naming.provider.url");
/* 1540 */       if ((urls != null) && (urls.length() > 0))
/*      */       {
/* 1542 */         StringTokenizer tokenizer = new StringTokenizer(urls, ",");
/*      */ 
/* 1544 */         while ((this.naming == null) && (tokenizer.hasMoreElements()))
/*      */         {
/* 1546 */           String url = tokenizer.nextToken();
/*      */ 
/* 1548 */           Name urlAsName = getNameParser("").parse(url);
/* 1549 */           String server = parseNameForScheme(urlAsName, null);
/* 1550 */           if (server != null)
/* 1551 */             url = server;
/* 1552 */           int colon = url.indexOf(':');
/* 1553 */           if (colon < 0)
/*      */           {
/* 1555 */             host = url;
/*      */           }
/*      */           else
/*      */           {
/* 1559 */             host = url.substring(0, colon).trim();
/*      */             try
/*      */             {
/* 1562 */               port = Integer.parseInt(url.substring(colon + 1).trim());
/*      */             }
/*      */             catch (Exception ex)
/*      */             {
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */           try
/*      */           {
/* 1572 */             this.naming = getServer(host, port, refEnv);
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/* 1576 */             serverEx = e;
/* 1577 */             log.debug("Failed to connect to " + host + ":" + port, e);
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 1582 */         Exception discoveryFailure = null;
/* 1583 */         if (this.naming == null)
/*      */         {
/*      */           try
/*      */           {
/* 1587 */             this.naming = discoverServer(refEnv);
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/* 1591 */             discoveryFailure = e;
/* 1592 */             if (serverEx == null)
/* 1593 */               serverEx = e;
/*      */           }
/* 1595 */           if (this.naming == null)
/*      */           {
/* 1597 */             StringBuffer buffer = new StringBuffer(50);
/* 1598 */             buffer.append("Could not obtain connection to any of these urls: ").append(urls);
/* 1599 */             if (discoveryFailure != null)
/* 1600 */               buffer.append(" and discovery failed with error: ").append(discoveryFailure);
/* 1601 */             CommunicationException ce = new CommunicationException(buffer.toString());
/* 1602 */             ce.setRootCause(serverEx);
/* 1603 */             throw ce;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 1616 */         String jnpPartitionName = (String)refEnv.get("jnp.partitionName");
/* 1617 */         if (jnpPartitionName != null)
/*      */         {
/* 1621 */           this.naming = discoverServer(refEnv);
/* 1622 */           if (this.naming == null) {
/* 1623 */             throw new ConfigurationException("No valid context could be build for jnp.partitionName=" + jnpPartitionName);
/*      */           }
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/* 1629 */           this.naming = localServer;
/*      */ 
/* 1631 */           if (this.naming == null)
/*      */           {
/* 1633 */             this.naming = discoverServer(refEnv);
/* 1634 */             if (this.naming == null)
/*      */             {
/* 1636 */               throw new ConfigurationException("No valid Context.PROVIDER_URL was found");
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private Name getAbsoluteName(Name n) throws NamingException
/*      */   {
/* 1646 */     if (n.isEmpty())
/* 1647 */       return composeName(n, this.prefix);
/* 1648 */     if (n.get(0).toString().equals("")) {
/* 1649 */       return n.getSuffix(1);
/*      */     }
/* 1651 */     return composeName(n, this.prefix);
/*      */   }
/*      */ 
/*      */   private Hashtable getEnv(Name n)
/*      */     throws InvalidNameException
/*      */   {
/* 1657 */     Hashtable nameEnv = this.env;
/* 1658 */     this.env.remove("jnp.parsedName");
/* 1659 */     String serverInfo = parseNameForScheme(n, nameEnv);
/* 1660 */     if (serverInfo != null)
/*      */     {
/* 1663 */       nameEnv = (Hashtable)this.env.clone();
/* 1664 */       nameEnv.put("java.naming.provider.url", serverInfo);
/*      */     }
/* 1666 */     return nameEnv;
/*      */   }
/*      */ 
/*      */   private boolean handleStaleNamingStub(Exception e, Hashtable refEnv)
/*      */   {
/* 1684 */     if (((e instanceof NoSuchObjectException)) || ((e.getCause() instanceof NoSuchObjectException)))
/*      */     {
/*      */       try
/*      */       {
/* 1689 */         if (log.isTraceEnabled())
/*      */         {
/* 1691 */           log.trace("Call failed with NoSuchObjectException, flushing server cache and retrying", e);
/*      */         }
/*      */ 
/* 1694 */         this.naming = null;
/* 1695 */         removeServer(refEnv);
/*      */ 
/* 1697 */         checkRef(refEnv);
/*      */ 
/* 1699 */         return true;
/*      */       }
/*      */       catch (Exception e1)
/*      */       {
/* 1705 */         log.error("Caught exception flushing server cache and re-establish naming after exception " + e.getLocalizedMessage(), e1);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1710 */     return false;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jnp.interfaces.NamingContext
 * JD-Core Version:    0.6.0
 */